/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics;

import com.sonicether.soundphysics.SoundPhysics;
import com.sonicether.soundphysics.SoundPhysicsMod;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RaycastFix {
    private static long lastUpdate = 0L;
    private static final Map<Long, VoxelShape> shapeCache = new Long2ObjectOpenHashMap(65536, 0.75f);
    private static final Minecraft mc = Minecraft.m_91087_();

    public static void updateCache() {
        long gameTime = Minecraft.m_91087_().f_91073_.m_46467_();
        if (lastUpdate != gameTime) {
            if (!shapeCache.isEmpty() && SoundPhysicsMod.CONFIG.performanceLogging.get().booleanValue()) {
                SoundPhysics.LOGGER.info("Clearing {} raycasting block cache entries", (Object)shapeCache.size());
            }
            shapeCache.clear();
            lastUpdate = gameTime;
        }
    }

    public static BlockHitResult fixedRaycast(Vec3 start, Vec3 end, @Nullable BlockPos ignore) {
        ClipContext context = new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)RaycastFix.mc.f_91074_);
        return RaycastFix.traverseBlocks(context.m_45702_(), context.m_45693_(), context, (c, pos) -> {
            double fluidLocation;
            if (new BlockPos((Vec3i)pos).equals((Object)ignore)) {
                return null;
            }
            BlockState blockState = RaycastFix.mc.f_91073_.m_8055_(pos);
            FluidState fluidState = RaycastFix.mc.f_91073_.m_6425_(pos);
            VoxelShape blockShape = shapeCache.computeIfAbsent(pos.m_121878_(), key -> blockState.m_60812_((BlockGetter)RaycastFix.mc.f_91073_, pos));
            BlockHitResult blockHit = RaycastFix.mc.f_91073_.m_45558_(start, end, pos, blockShape, blockState);
            VoxelShape fluidShape = shapeCache.computeIfAbsent(pos.m_121878_(), key -> context.m_45698_(fluidState, (BlockGetter)RaycastFix.mc.f_91073_, pos));
            BlockHitResult fluidHit = fluidShape.m_83220_(start, end, pos);
            if (fluidHit == null) {
                return blockHit;
            }
            if (blockHit == null) {
                return fluidHit;
            }
            double blockLocation = start.m_82557_(blockHit.m_82450_());
            return blockLocation <= (fluidLocation = start.m_82557_(fluidHit.m_82450_())) ? blockHit : fluidHit;
        }, c -> BlockHitResult.m_82426_((Vec3)context.m_45693_(), null, (BlockPos)new BlockPos(context.m_45693_())));
    }

    private static <T, C> T traverseBlocks(Vec3 start, Vec3 end, C context, BiFunction<C, BlockPos, T> blockHitFactory, Function<C, T> missFactory) {
        int k;
        int j;
        if (start.equals((Object)end)) {
            return missFactory.apply(context);
        }
        double d0 = Mth.m_14139_((double)-1.0E-7, (double)end.f_82479_, (double)start.f_82479_);
        double d1 = Mth.m_14139_((double)-1.0E-7, (double)end.f_82480_, (double)start.f_82480_);
        double d2 = Mth.m_14139_((double)-1.0E-7, (double)end.f_82481_, (double)start.f_82481_);
        double d3 = Mth.m_14139_((double)-1.0E-7, (double)start.f_82479_, (double)end.f_82479_);
        double d4 = Mth.m_14139_((double)-1.0E-7, (double)start.f_82480_, (double)end.f_82480_);
        double d5 = Mth.m_14139_((double)-1.0E-7, (double)start.f_82481_, (double)end.f_82481_);
        int i = Mth.m_14107_((double)d3);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(i, j = Mth.m_14107_((double)d4), k = Mth.m_14107_((double)d5));
        T t = blockHitFactory.apply(context, (BlockPos)pos);
        if (t != null) {
            return t;
        }
        double d6 = d0 - d3;
        double d7 = d1 - d4;
        double d8 = d2 - d5;
        int l = Mth.m_14205_((double)d6);
        int i1 = Mth.m_14205_((double)d7);
        int j1 = Mth.m_14205_((double)d8);
        double d9 = l == 0 ? Double.MAX_VALUE : (double)l / d6;
        double d10 = i1 == 0 ? Double.MAX_VALUE : (double)i1 / d7;
        double d11 = j1 == 0 ? Double.MAX_VALUE : (double)j1 / d8;
        double d12 = d9 * (l > 0 ? 1.0 - Mth.m_14185_((double)d3) : Mth.m_14185_((double)d3));
        double d13 = d10 * (i1 > 0 ? 1.0 - Mth.m_14185_((double)d4) : Mth.m_14185_((double)d4));
        double d14 = d11 * (j1 > 0 ? 1.0 - Mth.m_14185_((double)d5) : Mth.m_14185_((double)d5));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    i += l;
                    d12 += d9;
                } else {
                    k += j1;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                j += i1;
                d13 += d10;
            } else {
                k += j1;
                d14 += d11;
            }
            if ((t1 = blockHitFactory.apply(context, (BlockPos)pos.m_122178_(i, j, k))) == null) continue;
            return t1;
        }
        return missFactory.apply(context);
    }
}

