/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.event;

import com.dragonfight.DragonfightMod;
import com.dragonfight.fight.DragonFightManagerCustom;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class ModEventHandler {
    @SubscribeEvent
    public static void onConfigChanged(ModConfigEvent event) {
        DragonFightManagerCustom.spawnOnCrystalDeath = ModEventHandler.parseEntityTypes((List)DragonfightMod.config.getCommonConfig().spawnoncrystaldestroy.get());
        DragonFightManagerCustom.spawnOnCrystalRespawn = ModEventHandler.parseEntityTypes((List)DragonfightMod.config.getCommonConfig().spawnoncrystalrespawn.get());
        DragonFightManagerCustom.spawnOnDragonSitting = ModEventHandler.parseEntityTypes((List)DragonfightMod.config.getCommonConfig().spawnwhilelanded.get());
    }

    private static ImmutableList<EntityType> parseEntityTypes(List<? extends String> data) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String string : data) {
            String[] splitEntry;
            for (String entityString : splitEntry = string.split(",")) {
                ResourceLocation id = ResourceLocation.m_135820_((String)entityString);
                if (id == null) {
                    DragonfightMod.LOGGER.error("Config entry could not be parsed, not a valid resource location " + entityString);
                    continue;
                }
                EntityType type = (EntityType)ForgeRegistries.ENTITIES.getValue(id);
                if (type == null) {
                    DragonfightMod.LOGGER.error("Config entry could not be parsed, not a valid entity type" + entityString);
                    continue;
                }
                builder.add((Object)type);
            }
        }
        return builder.build();
    }
}

