---
navigation:
  parent: crazyae2addons_index.md
  title: 数据变量
  icon: crazyae2addons:data_processor
categories:
  - Monitoring and Automation
item_ids:
  - crazyae2addons:data_processor
  - crazyae2addons:dataflow_pattern
  - crazyae2addons:data_extractor
  - crazyae2addons:player_data_extractor
---

# 指南：数据流系统的工作原理

Crazy AE2 Addons中的**数据流系统**可将各式“节点”关联起来，从而在ME网络中建立小型逻辑程序。可以把它想成适用于数据的红石系统：值会在节点间传递，接受处理，然后用于触发操作（如给变量赋值或发出红石信号等）。

本篇指南会借助实际运用来解释这一系统的原理。

---

## 启动数据流

每个数据流图都以一个**入口（Entrypoint）节点**起始。此节点会提供初始值（通常是字符串）来启动数据流链。

值会从入口开始流入相连的其他节点。

---

## 节点的工作原理

每个节点都有：

* **输入**：等待值流入的位置。
* **输出**：将值向后传递的路径。

只有在收到**所有所需输入**后，节点才会开始运作。满足运作条件时，节点会处理并输出数据。

---

## 连接节点

节点输出的值可流入其他节点。这一流入过程有两种实现方式：

1. **自动连接**

    * 程序会查看下一个节点的输入。
    * 如果有输入设置空缺，且类型匹配（或可转换），那么值就会流入该处。

2. **显式引导**

    * 可以使用`^`符号强制让值流入特定的输入端。
    * 示例：
    - outputName^inputName
    - 表示&zwnj;*“将此值送入名为`inputName`的输入端”*。

如果节点有多个输入，或是需要精细控制，可以使用这个特性。

---

## 类型转换

各节点使用的“语言”不尽相同。为弥补这一点，系统会在可行时自动转换值：

* 字符串（string）↔ 整型（int）
* 整型（int）↔ 布尔型（bool）
* 布尔型（bool）↔ 字符串（string）

示例：

* 如果某节点输出了`"42"`（字符串，string），而下一个节点需要一个`int`（整型），那么系统就会尝试将其转换为数`42`。
* 如果转换失败（比如试图将`"apple"`变为整型），则抛弃值。

---

## 数据流示例

比如说我们需要读取变量，再用它控制红石信号：

1. **EntrypointNode**（入口节点）：提供字符串`"1"`。
2. **ReadVariableNode**（读取变量节点）：读取变量，输出数。
3. **SetRedstoneEmitterNode**（设置红石发信器节点）：接受数，将其变为布尔值（`>0 = ON`），再用它激活相连的发信器。

结果：变量非零时，发信器激活。

---

## 重要注意事项

* **单次循环内，每个节点只会执行一次。**
  节点执行后，除非再次启动数据流，否则其不会再被执行。

* **显示引导会覆盖自动连接。**
  采用`^inputName`时，程序会忽略其他所有可行的匹配。

* **转换失败会抛弃值。**
  程序本身不会终止，但值不会进入下一个节点。

---

## 简要提示

* 遇到模棱两可的情况时，应使用**显式引导**（`^input`）⸺可以避免混乱。
* 如果数据流不能正常工作，应检查值类型是否符合预期。系统会抛弃转换失败的值。
* 数据流应尽量短，且每一步都应进行测试，避免出现调试问题。
* 使用变量终端或显示监视器来查看实际变化。

---

了解了这些知识，就可在ME网络中搭建小型逻辑链路⸺从简单的红石信号触发，到高深的变量驱动自动化，这些全都能做到。
