/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.render;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import net.diebuddies.compat.Iris;
import net.diebuddies.compat.Optifine;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.opengl.VAO;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.render.MainRenderer;
import net.diebuddies.util.PerformanceTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.lwjgl.opengl.GL20;

public class LiquidRenderer {
    private MainRenderer mainRenderer;
    private int mcEntityLocation = -1;
    private Matrix4d transformation = new Matrix4d();
    private Matrix4f localT = new Matrix4f();

    public LiquidRenderer(MainRenderer mainRenderer) {
        this.mainRenderer = mainRenderer;
    }

    public void render(ClientLevel level, RenderType blockLayerIn, PoseStack viewMatrixStack, double xIn, double yIn, double zInm, Matrix4f projectionMatrix) {
        PhysicsMod mod;
        PhysicsWorld physics;
        if (level != null && ((physics = (mod = PhysicsMod.getInstance((Level)level)).getPhysicsWorld()).getLiquids().size() > 0 || physics.getOceanWorld().getOceanMeshes().size() > 0)) {
            blockLayerIn.m_110185_();
            PoseStack matrixStackIn = RenderSystem.getModelViewStack();
            Vec3 view = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_252931_(viewMatrixStack.m_85850_().m_252922_());
            Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mainRenderer.setupShader(RenderSystem.getShader());
            VAO.storePreviouslyBoundState();
            if (StarterClient.optifabric && Optifine.areShadersEnabled()) {
                this.mcEntityLocation = 11;
            } else if (StarterClient.iris) {
                this.mcEntityLocation = GL20.glGetAttribLocation((int)RenderSystem.getShader().m_108943_(), (CharSequence)"mc_Entity");
            }
            PerformanceTracker.startNoFlush("liquid_rendering");
            if (ConfigClient.cudaLiquids()) {
                this.mainRenderer.liquidDeferredRenderer.render(physics, level, matrixStackIn, view);
            } else {
                for (int i = 0; i < physics.getLiquids().size(); ++i) {
                    Liquid liquid = physics.getLiquids().get(i);
                    if (liquid.vao == null) continue;
                    this.renderLiquid(physics, level, matrixStackIn, view, liquid);
                }
            }
            PerformanceTracker.end("liquid_rendering");
            this.mainRenderer.oceanRenderer.render(physics, level, matrixStackIn, view);
            VAO.restorePreviouslyBoundState();
            BufferUploader.m_166835_();
            RenderSystem.getShader().m_173362_();
            matrixStackIn.m_85849_();
            RenderSystem.activeTexture((int)33984);
            RenderSystem.enableCull();
            blockLayerIn.m_110188_();
            RenderSystem.applyModelViewMatrix();
            if (level.m_104583_().m_108885_()) {
                Lighting.m_252995_((Matrix4f)viewMatrixStack.m_85850_().m_252922_());
            } else {
                Lighting.m_252756_((Matrix4f)viewMatrixStack.m_85850_().m_252922_());
            }
            this.setupAttribute(this.mcEntityLocation, 0.0f, 0.0f, 0.0f, 1.0f);
            if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
                Optifine.useWaterShader();
            }
        }
    }

    private void renderLiquid(PhysicsWorld physics, ClientLevel level, PoseStack matrixStackIn, Vec3 view, Liquid liquid) {
        this.setupAttribute(this.mcEntityLocation, liquid.materialID, liquid.renderType, -1.0f, -1.0f);
        RenderSystem.enableCull();
        this.transformation.set((Matrix4dc)liquid.transformation);
        this.transformation.m30(this.transformation.m30() - view.f_82479_);
        this.transformation.m31(this.transformation.m31() - view.f_82480_);
        this.transformation.m32(this.transformation.m32() - view.f_82481_);
        float scale = 1.0f / (float)liquid.gridSize;
        this.transformation.scale((double)scale);
        matrixStackIn.m_85836_();
        this.localT.set((Matrix4dc)this.transformation);
        matrixStackIn.m_252931_(this.localT);
        RenderSystem.applyModelViewMatrix();
        if (level.m_104583_().m_108885_()) {
            RenderSystem.shaderLightDirections[0] = MainRenderer.NETHER_DIFFUSE_LIGHT_0;
            RenderSystem.shaderLightDirections[1] = MainRenderer.NETHER_DIFFUSE_LIGHT_1;
        } else {
            RenderSystem.shaderLightDirections[0] = MainRenderer.DIFFUSE_LIGHT_0;
            RenderSystem.shaderLightDirections[1] = MainRenderer.DIFFUSE_LIGHT_1;
        }
        RenderSystem.setShaderTexture((int)0, (int)liquid.textureID);
        RenderSystem.activeTexture((int)33984);
        RenderSystem.bindTexture((int)liquid.textureID);
        this.mainRenderer.setupPBRTextures();
        ShaderInstance shader = RenderSystem.getShader();
        RenderSystem.setupShaderLights((ShaderInstance)shader);
        if (!StarterClient.optifabric || !Optifine.isUsingShadersNoInternal()) {
            if (shader.f_173313_ != null) {
                shader.f_173313_.m_85633_();
            }
            if (shader.f_173314_ != null) {
                shader.f_173314_.m_85633_();
            }
        }
        if (StarterClient.optifabric && Optifine.isUsingShadersNoInternal()) {
            Optifine.setModelViewMatrix(RenderSystem.getModelViewMatrix());
        } else {
            shader.f_173308_.m_5679_(RenderSystem.getModelViewMatrix());
            shader.f_173308_.m_85633_();
            if (StarterClient.iris) {
                Iris.setNormalMatrix(shader, RenderSystem.getModelViewMatrix());
            }
        }
        liquid.vao.render();
        matrixStackIn.m_85849_();
    }

    public void setupAttribute(int location, float v0, float v1, float v2, float v3) {
        if (location != -1) {
            GL20.glVertexAttrib4f((int)location, (float)v0, (float)v1, (float)v2, (float)v3);
        }
    }
}

