/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.vines;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.diebuddies.minecraft.ChunkHelper;
import net.diebuddies.physics.PhysicsEntity;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ragdoll.DynamicRagdoll;
import net.diebuddies.physics.ragdoll.HangingSignRagdoll;
import net.diebuddies.physics.vines.Adjustable;
import net.diebuddies.physics.vines.DynamicSetting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HangingSignSetting
extends DynamicSetting {
    @Adjustable(id="Hitbox scale", min=0.1, max=10.0, step=0.01, translationId="physicsmod.prop.vine.hitboxscale")
    public Vector3f hitboxScale;
    @Adjustable(id="Stiffness", min=0.1, max=5000.0, step=0.1, translationId="physicsmod.prop.vine.stiffness")
    public float stiffness;
    @Adjustable(id="Damping", min=0.1, max=100.0, step=0.1, translationId="physicsmod.prop.vine.damping")
    public float damping;

    public HangingSignSetting(Vector3f hitboxScale, float stiffness, float damping, boolean linkedPhysics) {
        this.hitboxScale = hitboxScale;
        this.stiffness = stiffness;
        this.damping = damping;
        this.linkedPhysics = linkedPhysics;
    }

    public HangingSignSetting() {
        this.hitboxScale = new Vector3f(0.9f);
        this.linkedPhysics = true;
        this.stiffness = 45.0f;
        this.damping = 45.0f;
    }

    @Override
    public DynamicRagdoll createRagdoll(PhysicsMod mod, BlockState current, BlockPos pos, Long2ObjectMap<BlockState> availableBlocks) {
        HangingSignRagdoll ragdoll = new HangingSignRagdoll();
        ragdoll.hitboxScale.set((Vector3fc)this.hitboxScale);
        ragdoll.hookedEntity = this.createPart(mod, ragdoll, current, pos.m_123342_(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        ragdoll.stiffness = this.stiffness;
        ragdoll.damping = this.damping;
        ragdoll.linkedPhysics = this.linkedPhysics;
        int count = 1;
        long indexNext = ChunkHelper.calcRelativeIndex(pos.m_123341_(), pos.m_123342_() + count, pos.m_123343_());
        BlockState state = null;
        while ((state = (BlockState)availableBlocks.get(indexNext)) != null && this.canLink(state, current)) {
            PhysicsEntity hangingSignEntity;
            ragdoll.hookedEntity = hangingSignEntity = this.createPart(mod, ragdoll, state, pos.m_123342_(), pos.m_123341_(), pos.m_123342_() + count, pos.m_123343_());
            ragdoll.addConnection(ragdoll.bodies.size() - 2, ragdoll.bodies.size() - 1);
            availableBlocks.remove(indexNext);
            indexNext = ChunkHelper.calcRelativeIndex(pos.m_123341_(), pos.m_123342_() + ++count, pos.m_123343_());
        }
        Vector3f offset = ragdoll.hookedEntity.models.get((int)0).mesh.offset;
        ragdoll.hook = new Vector3d(0.0, 1.0 - (double)offset.y % 1.0, 0.0);
        availableBlocks.remove(ChunkHelper.calcRelativeIndex(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
        return ragdoll;
    }

    public boolean canLink(BlockState first, BlockState second) {
        Block a = first.m_60734_();
        Block b = second.m_60734_();
        return a instanceof CeilingHangingSignBlock && b instanceof CeilingHangingSignBlock;
    }

    @Override
    public boolean isValid(BlockState state) {
        return state.m_60734_() instanceof CeilingHangingSignBlock;
    }

    @Override
    public Block defaultBlock() {
        return Blocks.f_244319_;
    }
}

