/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.diebuddies.compat.Optifine;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.EntityOcean;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.RenderConstraint;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Matrix4d;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public class OceanPhysicsDisplacementConstraint
extends RenderConstraint {
    private Entity entity;
    private Matrix4d gravityTransformation;
    private Vector3d gravity;

    public OceanPhysicsDisplacementConstraint(Entity entity) {
        this.entity = entity;
        this.gravityTransformation = new Matrix4d();
        this.gravity = new Vector3d();
    }

    @Override
    public void render(PoseStack matrixStack, double renderPercent, VerletSimulation simulation) {
        if (ConfigClient.areOceanPhysicsEnabled()) {
            double px = Mth.m_14139_((double)renderPercent, (double)this.entity.f_19790_, (double)this.entity.m_20185_());
            double py = Mth.m_14139_((double)renderPercent, (double)this.entity.f_19791_, (double)this.entity.m_20186_());
            double pz = Mth.m_14139_((double)renderPercent, (double)this.entity.f_19792_, (double)this.entity.m_20189_());
            OceanWorld oceanWorld = PhysicsMod.getInstance(this.entity.m_9236_()).getPhysicsWorld().getOceanWorld();
            float yRot = Mth.m_14179_((float)((float)renderPercent), (float)this.entity.f_19859_, (float)this.entity.m_146908_());
            Vector3d offset = simulation.getOffset();
            oceanWorld.computeEntityOffset(matrixStack.m_85850_().m_252922_(), matrixStack.m_85850_().m_252943_(), this.entity.m_9236_(), this.entity, px, py, pz, offset.x, offset.y, offset.z, yRot, (float)renderPercent);
            this.calculateGravityTransformation(renderPercent);
            RenderSystem.applyModelViewMatrix();
            if (StarterClient.optifabric && Optifine.areShadersEnabled()) {
                Optifine.setModelViewMatrix(RenderSystem.getModelViewMatrix());
            }
        }
        super.render(matrixStack, renderPercent, simulation);
    }

    private void calculateGravityTransformation(double renderPercent) {
        float actualYRot = 0.0f;
        Entity vehicle = this.entity.m_20202_();
        EntityOcean entityOcean = (EntityOcean)this.entity;
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            actualYRot = Mth.m_14189_((float)((float)renderPercent), (float)living.f_20884_, (float)living.f_20883_);
        } else {
            actualYRot = this.entity.m_5675_((float)renderPercent);
        }
        float currentYRot = (float)(-Math.toRadians(actualYRot - (float)Math.PI));
        double forwardZ = Math.cos(currentYRot);
        double forwardX = Math.sin(currentYRot);
        double leftX = forwardZ;
        double leftZ = -forwardX;
        double roll = entityOcean.getPhysicsRoll((float)renderPercent);
        double pitch = entityOcean.getPhysicsPitch((float)renderPercent);
        float diffRot = 0.0f;
        if (vehicle != null && vehicle instanceof Boat) {
            diffRot = vehicle.m_5675_((float)renderPercent) - actualYRot;
        }
        this.gravityTransformation.identity();
        this.gravityTransformation.rotate((Quaternionfc)Axis.f_252436_.m_252977_(-diffRot));
        this.gravityTransformation.rotate((Quaternionfc)Axis.m_253057_((Vector3f)new Vector3f((float)forwardX, 0.0f, (float)forwardZ)).m_252977_((float)(-Math.toDegrees(roll))));
        this.gravityTransformation.rotate((Quaternionfc)Axis.m_253057_((Vector3f)new Vector3f((float)leftX, 0.0f, (float)leftZ)).m_252977_((float)Math.toDegrees(pitch)));
        this.gravityTransformation.invert();
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        super.updateBefore(delta, simulation);
        this.gravity.set((Vector3dc)simulation.getGravity());
        this.gravityTransformation.transformDirection(simulation.getGravity());
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
        super.updateAfter(delta, simulation);
        simulation.setGravity(this.gravity);
    }
}

