/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.verlet.constraints;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.InvocationTargetException;
import net.diebuddies.bridge.ReflectionsForge;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.verlet.VerletLine;
import net.diebuddies.physics.verlet.VerletPoint;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.VerletStick;
import net.diebuddies.physics.verlet.constraints.VerletConstraint;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class LeashConstraint
implements VerletConstraint {
    private Vector3d leashOriginAsync = new Vector3d();
    private Vector3d leashTargetAsync = new Vector3d();
    private Vector3d leashOrigin = new Vector3d();
    private Vector3d leashTarget = new Vector3d();
    private Mob mob;
    private Entity entity;
    private EntityRenderDispatcher entityRenderDispatcher;

    public LeashConstraint(VerletSimulation simulation, Mob mob, Entity entity, EntityRenderDispatcher entityRenderDispatcher, float tickDelta) {
        int i;
        this.mob = mob;
        this.entity = entity;
        this.entityRenderDispatcher = entityRenderDispatcher;
        this.calculateLeashOriginAndTarget(tickDelta, this.leashOrigin, this.leashTarget);
        int pointCount = 20;
        double totalLength = ConfigClient.leashLength;
        for (i = 0; i < pointCount; ++i) {
            float perc = (float)(i - 1) / (float)pointCount;
            Vector3d position = new Vector3d(Math.lerp((double)this.leashOrigin.x, (double)this.leashTarget.x, (double)perc), Math.lerp((double)this.leashOrigin.y, (double)this.leashTarget.y, (double)perc), Math.lerp((double)this.leashOrigin.z, (double)this.leashTarget.z, (double)perc));
            VerletPoint point = new VerletPoint(position);
            point.uv.set(0.01f, 0.99f);
            float colMod = i % 2 == 0 ? 0.7f : 1.0f;
            float r = 0.5f * colMod;
            float g = 0.4f * colMod;
            float b = 0.3f * colMod;
            point.rgba.set(r, g, b, 1.0f);
            point.locked = i == 0 || i == pointCount - 1;
            simulation.addPoint(point);
        }
        for (i = 0; i < pointCount - 1; ++i) {
            simulation.addStick(new VerletStick(simulation.getPoints().get(i), simulation.getPoints().get(i + 1), totalLength / (double)pointCount));
            simulation.addLine(new VerletLine(simulation.getPoints().get(i), simulation.getPoints().get(i + 1)));
        }
    }

    private void calculateLeashOriginAndTarget(float tickDelta, Vector3d leashOrigin, Vector3d leashTarget) {
        Vec3 ropePosition = this.entity.m_7398_(tickDelta);
        double bodyRot = (double)(Mth.m_14179_((float)tickDelta, (float)this.mob.f_20883_, (float)this.mob.f_20884_) * ((float)java.lang.Math.PI / 180)) + 1.5707963267948966;
        Vec3 leashOffset = this.mob.m_245894_(tickDelta);
        double leashOffset1 = java.lang.Math.cos(bodyRot) * leashOffset.f_82481_ + java.lang.Math.sin(bodyRot) * leashOffset.f_82479_;
        double leashOffset2 = java.lang.Math.sin(bodyRot) * leashOffset.f_82481_ - java.lang.Math.cos(bodyRot) * leashOffset.f_82479_;
        double mobX = Mth.m_14139_((double)tickDelta, (double)this.mob.f_19854_, (double)this.mob.m_20185_()) + leashOffset1;
        double mobY = Mth.m_14139_((double)tickDelta, (double)this.mob.f_19855_, (double)this.mob.m_20186_()) + leashOffset.f_82480_;
        double mobZ = Mth.m_14139_((double)tickDelta, (double)this.mob.f_19856_, (double)this.mob.m_20189_()) + leashOffset2;
        float ropeDirX = (float)(ropePosition.f_82479_ - mobX);
        float ropeDirY = (float)(ropePosition.f_82480_ - mobY);
        float ropeDirZ = (float)(ropePosition.f_82481_ - mobZ);
        float hangingRate = Mth.m_264536_((float)(ropeDirX * ropeDirX + ropeDirZ * ropeDirZ)) * 0.025f / 2.0f;
        float hangingRateZ = ropeDirZ * hangingRate;
        float hangingRateX = ropeDirX * hangingRate;
        BlockPos mob1Pos = BlockPos.m_274446_((Position)this.mob.m_20299_(tickDelta));
        BlockPos mob2Pos = BlockPos.m_274446_((Position)this.entity.m_20299_(tickDelta));
        int mob1Brightness = 0;
        int mob2Brightness = 0;
        try {
            mob1Brightness = (Integer)ReflectionsForge.getBlockLightLevel.invoke((Object)this.entityRenderDispatcher.m_114382_((Entity)this.mob), this.mob, mob1Pos);
            mob2Brightness = (Integer)ReflectionsForge.getBlockLightLevel.invoke((Object)this.entityRenderDispatcher.m_114382_(this.entity), this.entity, mob2Pos);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
        int mob1BrightnessSky = this.mob.m_9236_().m_45517_(LightLayer.SKY, mob1Pos);
        int mob2BrightnessSky = this.mob.m_9236_().m_45517_(LightLayer.SKY, mob2Pos);
        double ropeOffset = 0.0;
        if (ConfigClient.areOceanPhysicsEnabled()) {
            OceanWorld oceanWorld = PhysicsMod.getInstance(this.mob.m_9236_()).getPhysicsWorld().getOceanWorld();
            ropeOffset += oceanWorld.computeYOffset(this.entity.m_9236_(), this.entity, 1.0f);
            mobY += oceanWorld.computeYOffset(this.mob.m_9236_(), (Entity)this.mob, 1.0f);
        }
        leashOrigin.set(ropePosition.f_82479_, ropePosition.f_82480_ + ropeOffset, ropePosition.f_82481_);
        leashTarget.set(mobX, mobY, mobZ);
    }

    @Override
    public boolean initAsyncData(PhysicsWorld world, VerletSimulation simulation) {
        this.calculateLeashOriginAndTarget(1.0f, this.leashOriginAsync, this.leashTargetAsync);
        return false;
    }

    @Override
    public void updateBefore(double delta, VerletSimulation simulation) {
        VerletPoint originPoint = simulation.getPoints().get(0);
        VerletPoint targetPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        originPoint.position.set((Vector3dc)this.leashOriginAsync).sub((Vector3dc)simulation.getOffset());
        targetPoint.position.set((Vector3dc)this.leashTargetAsync).sub((Vector3dc)simulation.getOffset());
    }

    @Override
    public void subStep(double percent, VerletSimulation simulation) {
    }

    @Override
    public void updateAfter(double delta, VerletSimulation simulation) {
    }

    @Override
    public void renderBefore(PoseStack matrixStack, double delta, VerletSimulation simulation) {
        this.calculateLeashOriginAndTarget((float)delta, this.leashOrigin, this.leashTarget);
        VerletPoint armPoint = simulation.getPoints().get(0);
        VerletPoint hookPoint = simulation.getPoints().get(simulation.getPoints().size() - 1);
        armPoint.bufferPosition.set((Vector3dc)this.leashOrigin).sub((Vector3dc)simulation.getOffset());
        armPoint.bufferPrevPosition.set((Vector3dc)armPoint.bufferPosition);
        hookPoint.bufferPosition.set((Vector3dc)this.leashTarget).sub((Vector3dc)simulation.getOffset());
        hookPoint.bufferPrevPosition.set((Vector3dc)hookPoint.bufferPosition);
    }

    @Override
    public void renderAfter(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }

    @Override
    public void render(PoseStack matrixStack, double delta, VerletSimulation simulation) {
    }
}

