/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.snow;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.snow.IChunk;
import net.diebuddies.physics.snow.SnowProperty;
import net.diebuddies.physics.snow.SnowWorld;
import net.diebuddies.physics.vines.FastBlockSearcherConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.Palette;
import org.joml.Vector3i;

public class SnowSearcher
implements FastBlockSearcherConsumer {
    private static final Map<Block, SnowProperty> snowBlocks = new Reference2ReferenceOpenHashMap(3, 0.25f);
    private Palette<BlockState> palette;
    private int xc;
    private int yc;
    private int zc;
    private SnowWorld snowWorld;
    private Map<Vector3i, BlockState> snow;
    private ShortSet lightUpdates;
    private int count;
    private BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();

    public static boolean isPhysicsSnow(BlockState blockState) {
        return SnowSearcher.getSnowProperty(blockState) != null;
    }

    public static SnowProperty getSnowProperty(BlockState state) {
        Block block = state.m_60734_();
        SnowProperty property = snowBlocks.get(block);
        if (ConfigClient.grassSnowy && property == null && block instanceof SnowyDirtBlock && ((Boolean)state.m_61143_((Property)SnowyDirtBlock.f_56637_)).booleanValue()) {
            return SnowProperty.FULL;
        }
        return property;
    }

    public SnowSearcher(SnowWorld snowWorld, Map<Vector3i, BlockState> snow, int x, int y, int z, Palette<BlockState> data) {
        this.snowWorld = snowWorld;
        this.xc = x;
        this.yc = y;
        this.zc = z;
        this.snow = snow;
        this.palette = data;
        this.lightUpdates = this.snowWorld.getLightUpdates(SectionPos.m_123209_((int)SectionPos.m_123171_((int)x), (int)SectionPos.m_123171_((int)y), (int)SectionPos.m_123171_((int)z)));
    }

    @Override
    public void accept(int value, int amount) {
        this.accept((BlockState)this.palette.m_5795_(value), amount);
    }

    @Override
    public void accept(BlockState state, int amount) {
        if (SnowSearcher.getSnowProperty(state) != null) {
            for (int i = 0; i < amount; ++i) {
                int x = this.count & 0xF;
                int y = this.count >> 8 & 0xF;
                int z = this.count >> 4 & 0xF;
                int rx = x * IChunk.CHUNK_MULTIPLE;
                int ry = y * IChunk.CHUNK_MULTIPLE;
                int rz = z * IChunk.CHUNK_MULTIPLE;
                this.pos.m_122178_(x + this.xc, y + this.yc, z + this.zc);
                this.snow.put(new Vector3i(rx, ry, rz), state);
                SnowSearcher.queueLightUpdates(this.snowWorld, this.lightUpdates, this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_());
                ++this.count;
            }
        } else {
            this.count += amount;
        }
    }

    public static void queueLightUpdates(SnowWorld snowWorld, ShortSet lightUpdates, int x, int y, int z) {
        int ax = x & 0xF;
        int ay = y & 0xF;
        int az = z & 0xF;
        for (int xo = -1; xo <= 1; ++xo) {
            for (int yo = -1; yo <= 1; ++yo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    int lx = ax + xo;
                    int ly = ay + yo;
                    int lz = az + zo;
                    if (SnowSearcher.outOfBounds(lx, ly, lz)) {
                        ShortSet updates = snowWorld.getLightUpdates(SectionPos.m_123209_((int)SectionPos.m_123171_((int)(x + xo)), (int)SectionPos.m_123171_((int)(y + yo)), (int)SectionPos.m_123171_((int)(z + zo))));
                        updates.add((short)((lx & 0xF) << 8 | (ly & 0xF) << 4 | lz & 0xF));
                        continue;
                    }
                    lightUpdates.add((short)(lx << 8 | ly << 4 | lz));
                }
            }
        }
    }

    private static boolean outOfBounds(int x, int y, int z) {
        return x >= 16 || y >= 16 || z >= 16 || x < 0 || y < 0 || z < 0;
    }

    static {
        snowBlocks.put(Blocks.f_50125_, SnowProperty.LAYER);
        snowBlocks.put(Blocks.f_50127_, SnowProperty.FULL);
        snowBlocks.put(Blocks.f_152499_, SnowProperty.FULL);
    }
}

