/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.ux;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import javax.annotation.Nullable;
import net.diebuddies.physics.settings.ux.Animatable;
import net.diebuddies.physics.settings.ux.Animator;
import net.diebuddies.physics.settings.ux.BarRenderer;
import net.diebuddies.physics.settings.ux.BaseColors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;

public class MainToolTipRenderer {
    public static void renderToolTip(TooltipAlignment alignment, @Nullable Animatable animatable, List<FormattedCharSequence> list, GuiGraphics guiGraphics, float x, float width, float y, float barSize, int backgroundColor) {
        BarRenderer bar;
        Font font = Minecraft.m_91087_().f_91062_;
        int padding = 10;
        int heightPerRow = 10;
        int height = list.size() * heightPerRow + padding * 2;
        PoseStack matrices = guiGraphics.m_280168_();
        matrices.m_85836_();
        matrices.m_252880_(0.0f, 0.0f, 200.0f);
        Matrix4f pose = matrices.m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        int color = backgroundColor;
        float depth = -120.0f;
        int yOffset = height;
        if (alignment == TooltipAlignment.TOP) {
            yOffset = 0;
        }
        Animator.drawRect(bufferBuilder, pose, x, y - (float)yOffset, width, height, depth, color);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
        color = BaseColors.HIGHLIGHT_COLOR;
        if (animatable != null && (bar = animatable.getAnimator(BarRenderer.class)) != null) {
            color = bar.getActiveColor();
        }
        BarRenderer.renderHighlightBar(BarRenderer.BarAlignment.BOTTOM, pose, x, y - (float)yOffset, width, height, depth + 1.0f, barSize, color);
        float xText = x + (float)padding;
        for (int i = 0; i < list.size(); ++i) {
            float yText = y + (float)(i * heightPerRow) + (float)padding - (float)yOffset;
            Animator.drawText(guiGraphics, font, list.get(i), xText, yText);
        }
        matrices.m_85849_();
    }

    public static void renderToolTip(@Nullable Animatable animatable, List<FormattedCharSequence> list, GuiGraphics guiGraphics, float x, float width, float y, float barSize, int color) {
        MainToolTipRenderer.renderToolTip(TooltipAlignment.BOTTOM, animatable, list, guiGraphics, x, width, y, barSize, color);
    }

    public static void renderToolTip(@Nullable Animatable animatable, List<FormattedCharSequence> list, GuiGraphics guiGraphics, float x, float width, float y, float barSize) {
        MainToolTipRenderer.renderToolTip(TooltipAlignment.BOTTOM, animatable, list, guiGraphics, x, width, y, barSize, BaseColors.BACKGROUND_COLOR);
    }

    public static void renderToolTip(TooltipAlignment alignment, @Nullable Animatable animatable, Component component, GuiGraphics guiGraphics, float x, float width, float y, float barSize, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        int padding = 10;
        List list = font.m_92923_((FormattedText)component, (int)width - padding * 2);
        MainToolTipRenderer.renderToolTip(alignment, animatable, list, guiGraphics, x, width, y, barSize, color);
    }

    public static void renderToolTip(TooltipAlignment alignment, @Nullable Animatable animatable, Component component, GuiGraphics guiGraphics, float x, float width, float y, float barSize) {
        MainToolTipRenderer.renderToolTip(alignment, animatable, component, guiGraphics, x, width, y, barSize, BaseColors.BACKGROUND_COLOR);
    }

    public static void renderToolTip(@Nullable Animatable animatable, Component component, GuiGraphics guiGraphics, float x, float width, float y, float barSize, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        int padding = 10;
        List list = font.m_92923_((FormattedText)component, (int)width - padding * 2);
        MainToolTipRenderer.renderToolTip(animatable, list, guiGraphics, x, width, y, barSize, color);
    }

    public static void renderToolTip(@Nullable Animatable animatable, Component component, GuiGraphics guiGraphics, float x, float width, float y, float barSize) {
        MainToolTipRenderer.renderToolTip(animatable, component, guiGraphics, x, width, y, barSize, BaseColors.BACKGROUND_COLOR);
    }

    public static void renderToolTip(Component component, GuiGraphics guiGraphics, float x, float width, float y, float barSize, int color) {
        MainToolTipRenderer.renderToolTip(null, component, guiGraphics, x, width, y, barSize, color);
    }

    public static void renderToolTip(Component component, GuiGraphics guiGraphics, float x, float width, float y, float barSize) {
        MainToolTipRenderer.renderToolTip(null, component, guiGraphics, x, width, y, barSize, BaseColors.BACKGROUND_COLOR);
    }

    public static void renderToolTip(List<FormattedCharSequence> list, GuiGraphics guiGraphics, float x, float width, float y, float barSize) {
        MainToolTipRenderer.renderToolTip(null, list, guiGraphics, x, width, y, barSize);
    }

    public static enum TooltipAlignment {
        TOP,
        BOTTOM;

    }
}

