/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.mobs;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.diebuddies.compat.Sodium;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.settings.cloth.LabelEntry;
import net.diebuddies.physics.settings.gui.legacy.LegacyObjectSelectionList;
import net.diebuddies.physics.settings.mobs.BoundingBoxGetter;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.LeashKnotModel;
import net.minecraft.client.model.MinecartModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.ShulkerBulletModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.TridentModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.AxolotlRenderer;
import net.minecraft.client.renderer.entity.BeeRenderer;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.ChestedHorseRenderer;
import net.minecraft.client.renderer.entity.EndCrystalRenderer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.FoxRenderer;
import net.minecraft.client.renderer.entity.FrogRenderer;
import net.minecraft.client.renderer.entity.GhastRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.LeashKnotRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.MinecartRenderer;
import net.minecraft.client.renderer.entity.MushroomCowRenderer;
import net.minecraft.client.renderer.entity.PandaRenderer;
import net.minecraft.client.renderer.entity.ParrotRenderer;
import net.minecraft.client.renderer.entity.RabbitRenderer;
import net.minecraft.client.renderer.entity.ShulkerBulletRenderer;
import net.minecraft.client.renderer.entity.ShulkerRenderer;
import net.minecraft.client.renderer.entity.StriderRenderer;
import net.minecraft.client.renderer.entity.ThrownTridentRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.UndeadHorseRenderer;
import net.minecraft.client.renderer.entity.VexRenderer;
import net.minecraft.client.renderer.entity.WitherBossRenderer;
import net.minecraft.client.renderer.entity.WitherSkullRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.vehicle.Boat;
import org.joml.Quaternionf;

public class MobEntry
extends LabelEntry {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("physicsmod:textures/gui/white.png");
    private static final Map<EntityRenderer, Model> models = new Object2ObjectOpenHashMap();
    private String text;
    private EntityType<?> entityType;

    public MobEntry(LegacyObjectSelectionList objectSelectionList, String text) {
        super(objectSelectionList, text);
        this.text = text;
        this.entityType = (EntityType)EntityType.m_20632_((String)text).get();
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void render(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        String newText;
        Font font = Minecraft.m_91087_().f_91062_;
        Object text = this.text;
        if (font.m_92852_((FormattedText)Component.m_237113_((String)text).m_130940_(ChatFormatting.BOLD)) > this.objectSelectionList.getRowWidth() - 55 && !((String)text).equalsIgnoreCase(newText = font.m_92834_((String)text, this.objectSelectionList.getRowWidth() - 58))) {
            text = newText + "...";
        }
        MutableComponent label = Component.m_237113_((String)text);
        if (hovered) {
            label = label.m_130940_(ChatFormatting.BOLD);
            guiGraphics.m_280653_(font, (Component)label, x + entryWidth / 2 - 2, y + (entryHeight - 11) / 2, 0xFFFFFF);
        } else {
            guiGraphics.m_280653_(font, (Component)label, x + entryWidth / 2 - 2, y + (entryHeight - 11) / 2, 0xC2C2C2);
        }
        PoseStack matrices = RenderSystem.getModelViewStack();
        float scale = (float)entryHeight / 2.0f * 0.9f;
        double xPosition = this.objectSelectionList.getRowLeft() + 2 + (int)scale;
        double yPosition = y + entryHeight / 2;
        matrices.m_85836_();
        matrices.m_85837_(xPosition, yPosition, 100.0);
        matrices.m_85841_(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
        Lighting.m_166384_();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        PhysicsMod.sodiumCatchBoundingBox = true;
        PhysicsMod.sodiumBoundingBox.start.set(Double.MAX_VALUE);
        PhysicsMod.sodiumBoundingBox.end.set(-1.7976931348623157E308);
        try {
            EntityRenderer<?> renderer = PhysicsMod.renderers.get(this.entityType);
            ResourceLocation textureLocation = MobEntry.getTextureLocation(renderer, this.entityType);
            Model model = MobEntry.getModel(renderer, this.entityType);
            if (model instanceof EntityModel) {
                EntityModel entityModel = (EntityModel)model;
                entityModel.f_102610_ = false;
            }
            RenderType renderType = RenderType.m_110452_((ResourceLocation)textureLocation);
            BoundingBoxGetter boundingBox = StarterClient.sodium ? Sodium.getNewBoundingBoxConsumer() : new BoundingBoxGetter();
            model.m_7695_(new PoseStack(), (VertexConsumer)boundingBox, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.0f);
            if (StarterClient.sodium) {
                boundingBox.min = PhysicsMod.sodiumBoundingBox.getMin();
                boundingBox.max = PhysicsMod.sodiumBoundingBox.getMax();
            }
            double startX = boundingBox.min.x;
            double endX = boundingBox.max.x;
            double startY = boundingBox.min.y;
            double endY = boundingBox.max.y;
            double startZ = boundingBox.min.z;
            double endZ = boundingBox.max.z;
            double mobWidth = endX - startX;
            double mobHeight = endY - startY;
            double mobDepth = endZ - startZ;
            float mobScale = 1.0f / (float)Math.max(mobWidth, Math.max(mobHeight, mobDepth)) * 2.0f;
            matrices.m_85841_(mobScale, mobScale, mobScale);
            matrices.m_85837_(-mobWidth * 0.5 - startX, -mobHeight * 0.5 - startY, -mobDepth * 0.5 - startZ);
            matrices.m_252781_(new Quaternionf().rotationXYZ((float)Math.toRadians(-25.0), (float)Math.toRadians(-130.0), 0.0f));
            RenderSystem.applyModelViewMatrix();
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
            model.m_7695_(new PoseStack(), vertexConsumer, 0xF000F0, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.0f);
            bufferSource.m_109911_();
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrices.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Lighting.m_84931_();
        PhysicsMod.sodiumCatchBoundingBox = false;
    }

    public static Model getModel(EntityRenderer renderer, EntityType<?> entityType, Entity entity) {
        if (entityType == EntityType.f_20532_) {
            if (entity != null && entity instanceof AbstractClientPlayer) {
                AbstractClientPlayer player = (AbstractClientPlayer)entity;
                if (player.m_108564_().equalsIgnoreCase("slim")) {
                    return models.computeIfAbsent(renderer, key -> new PlayerModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171166_), true));
                }
                return models.computeIfAbsent(renderer, key -> new PlayerModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171162_), false));
            }
            return models.computeIfAbsent(renderer, key -> new PlayerModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171162_), false));
        }
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
            return livingRenderer.m_7200_();
        }
        if (renderer instanceof EnderDragonRenderer) {
            return models.computeIfAbsent(renderer, key -> new EnderDragonRenderer.DragonModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171144_)));
        }
        if (renderer instanceof BoatRenderer) {
            return models.computeIfAbsent(renderer, key -> new BoatModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.m_171289_((Boat.Type)Boat.Type.OAK))));
        }
        if (renderer instanceof MinecartRenderer) {
            if (entityType == EntityType.f_20475_) {
                return models.computeIfAbsent(renderer, key -> new MinecartModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171253_)));
            }
            if (entityType == EntityType.f_20470_) {
                return models.computeIfAbsent(renderer, key -> new MinecartModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171276_)));
            }
            if (entityType == EntityType.f_20471_) {
                return models.computeIfAbsent(renderer, key -> new MinecartModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171279_)));
            }
            if (entityType == EntityType.f_20472_) {
                return models.computeIfAbsent(renderer, key -> new MinecartModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171149_)));
            }
            if (entityType == EntityType.f_20473_) {
                return models.computeIfAbsent(renderer, key -> new MinecartModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171185_)));
            }
            if (entityType == EntityType.f_20474_) {
                return models.computeIfAbsent(renderer, key -> new MinecartModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171244_)));
            }
            return models.computeIfAbsent(renderer, key -> new MinecartModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171198_)));
        }
        if (renderer instanceof ShulkerBulletRenderer) {
            return models.computeIfAbsent(renderer, key -> new ShulkerBulletModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171181_)));
        }
        if (renderer instanceof ThrownTridentRenderer) {
            return models.computeIfAbsent(renderer, key -> new TridentModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171255_)));
        }
        if (renderer instanceof WitherSkullRenderer) {
            return models.computeIfAbsent(renderer, key -> new SkullModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171220_)));
        }
        if (renderer instanceof LeashKnotRenderer) {
            return models.computeIfAbsent(renderer, key -> new LeashKnotModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171193_)));
        }
        if (renderer instanceof EndCrystalRenderer) {
            return models.computeIfAbsent(renderer, key -> new HierarchicalModel(){
                ModelPart root = Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171145_);

                public ModelPart m_142109_() {
                    return this.root;
                }

                public void m_6973_(Entity var1, float var2, float var3, float var4, float var5, float var6) {
                }
            });
        }
        return null;
    }

    public static Model getModel(EntityRenderer renderer, EntityType<?> entityType) {
        return MobEntry.getModel(renderer, entityType, null);
    }

    public static ResourceLocation getTextureLocation(EntityRenderer renderer, EntityType entityType, Entity entity) {
        if (entityType == EntityType.f_20532_) {
            AbstractClientPlayer player;
            if (entity != null && entity instanceof AbstractClientPlayer && (player = (AbstractClientPlayer)entity).m_108559_()) {
                return player.m_108560_();
            }
            return new ResourceLocation("textures/entity/player/wide/steve.png");
        }
        if (entityType == EntityType.f_20511_) {
            return new ResourceLocation("textures/entity/piglin/piglin.png");
        }
        if (entityType == EntityType.f_20531_) {
            return new ResourceLocation("textures/entity/piglin/zombified_piglin.png");
        }
        if (entityType == EntityType.f_20512_) {
            return new ResourceLocation("textures/entity/piglin/piglin_brute.png");
        }
        if (renderer instanceof RabbitRenderer) {
            return new ResourceLocation("textures/entity/rabbit/brown.png");
        }
        if (renderer instanceof AxolotlRenderer) {
            return new ResourceLocation(String.format("textures/entity/axolotl/axolotl_%s.png", Axolotl.Variant.BLUE.m_149253_()));
        }
        if (renderer instanceof BeeRenderer) {
            return new ResourceLocation("textures/entity/bee/bee.png");
        }
        if (renderer instanceof BoatRenderer) {
            return new ResourceLocation("textures/entity/boat/oak.png");
        }
        if (renderer instanceof CatRenderer) {
            return new ResourceLocation("textures/entity/cat/tabby.png");
        }
        if (renderer instanceof HorseRenderer) {
            return new ResourceLocation("textures/entity/horse/horse_white.png");
        }
        if (renderer instanceof UndeadHorseRenderer) {
            if (entityType == EntityType.f_20502_) {
                return new ResourceLocation("textures/entity/horse/horse_zombie.png");
            }
            if (entityType == EntityType.f_20525_) {
                return new ResourceLocation("textures/entity/horse/horse_skeleton.png");
            }
            return new ResourceLocation("textures/entity/horse/horse_skeleton.png");
        }
        if (renderer instanceof LlamaRenderer) {
            return new ResourceLocation("textures/entity/llama/creamy.png");
        }
        if (renderer instanceof ChestedHorseRenderer) {
            if (entityType == EntityType.f_20560_) {
                return new ResourceLocation("textures/entity/horse/donkey.png");
            }
            if (entityType == EntityType.f_20503_) {
                return new ResourceLocation("textures/entity/horse/mule.png");
            }
        } else {
            if (renderer instanceof FoxRenderer) {
                return new ResourceLocation("textures/entity/fox/fox.png");
            }
            if (renderer instanceof GhastRenderer) {
                return new ResourceLocation("textures/entity/ghast/ghast.png");
            }
            if (renderer instanceof MushroomCowRenderer) {
                return new ResourceLocation("textures/entity/cow/red_mooshroom.png");
            }
            if (renderer instanceof PandaRenderer) {
                return new ResourceLocation("textures/entity/panda/panda.png");
            }
            if (renderer instanceof ParrotRenderer) {
                return new ResourceLocation("textures/entity/parrot/parrot_red_blue.png");
            }
            if (renderer instanceof ShulkerRenderer) {
                return new ResourceLocation("textures/" + Sheets.f_110741_.m_119203_().m_135815_() + ".png");
            }
            if (renderer instanceof StriderRenderer) {
                return new ResourceLocation("textures/entity/strider/strider.png");
            }
            if (renderer instanceof TropicalFishRenderer) {
                return new ResourceLocation("textures/entity/fish/tropical_a.png");
            }
            if (renderer instanceof VexRenderer) {
                return new ResourceLocation("textures/entity/illager/vex.png");
            }
            if (renderer instanceof WitherBossRenderer) {
                return new ResourceLocation("textures/entity/wither/wither.png");
            }
            if (renderer instanceof WolfRenderer) {
                return new ResourceLocation("textures/entity/wolf/wolf.png");
            }
            if (renderer instanceof ItemFrameRenderer) {
                return new ResourceLocation("textures/entity/wolf/wolf.png");
            }
            if (renderer instanceof WitherSkullRenderer) {
                return new ResourceLocation("textures/entity/wither/wither_invulnerable.png");
            }
            if (renderer instanceof FrogRenderer) {
                return new ResourceLocation("textures/entity/frog/cold_frog.png");
            }
        }
        ResourceLocation texture = null;
        try {
            texture = renderer.m_5478_(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (texture == null) {
            texture = MobEntry.getBackupTextureLocation(renderer, entityType);
        }
        if (texture == null) {
            return DEFAULT_TEXTURE;
        }
        return texture;
    }

    public static ResourceLocation getTextureLocation(EntityRenderer renderer, EntityType entityType) {
        return MobEntry.getTextureLocation(renderer, entityType, null);
    }

    private static ResourceLocation getBackupTextureLocation(EntityRenderer renderer, EntityType entityType) {
        Field[] fields;
        for (Field field : fields = renderer.getClass().getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(ResourceLocation.class)) continue;
            try {
                String file;
                field.setAccessible(true);
                ResourceLocation resource = (ResourceLocation)field.get(null);
                if (resource == null || !(file = resource.m_135815_()).endsWith(".png") && !file.endsWith(".jpg") && !file.endsWith(".tga") && !file.endsWith(".jpeg")) continue;
                return resource;
            }
            catch (IllegalAccessException | IllegalArgumentException e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Component getNarration() {
        return Component.m_237113_((String)this.text);
    }
}

