/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.blocks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.diebuddies.config.ConfigAnimations;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.animation.Animation;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.blocks.BlockCustomizeScreen;
import net.diebuddies.physics.settings.blocks.BlockPhysicsType;
import net.diebuddies.physics.settings.gui.AnimationOption;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class BlockSettingsScreen
extends OptionsSubScreen {
    CycleOption<TypeWrapper> PHYSICS_BLOCK = CycleOption.create("physicsmod.menu.block.blockphysics", (Object[])TypeWrapper.values(), model -> Component.m_237115_((String)BlockPhysicsType.values()[TypeWrapper.unwrapMainRuleValue(((TypeWrapper)((Object)((Object)model))).ordinal())].toString()), gameOptions -> TypeWrapper.values()[TypeWrapper.wrapMainRuleValue(ConfigClient.blockSetting.type.ordinal())], (gameOptions, option, model) -> {
        TypeWrapper type = (TypeWrapper)((Object)((Object)model));
        ConfigClient.blockSetting.type = BlockPhysicsType.values()[TypeWrapper.unwrapMainRuleValue(type.ordinal())];
        ConfigClient.save();
    });
    private static final ProgressOption PHYSICS_LIFETIME_BLOCKS = new ProgressOption("physicsmod.menu.block.lifetime", 0.0, 100.0, 0.1f, gameOptions -> ConfigClient.blockSetting.lifetime, (gameOptions, value) -> {
        ConfigClient.blockSetting.lifetime = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.block.lifetime", String.format("%.2f", option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_VARIANCE_BLOCKS = new ProgressOption("physicsmod.menu.block.lifetimevariance", 0.0, 30.0, 0.1f, gameOptions -> ConfigClient.blockSetting.lifetimeVariance, (gameOptions, value) -> {
        ConfigClient.blockSetting.lifetimeVariance = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.block.lifetimevariance", String.format("%.2f", option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_BLOCKS_RANGE = new ProgressOption("physicsmod.menu.block.blockphysicsrange", 10.0, 320.0, 0.1f, gameOptions -> ConfigClient.blockPhysicsRange, (gameOptions, value) -> {
        ConfigClient.blockPhysicsRange = value;
        ConfigClient.save();
    }, (gameOptions, option) -> {
        double val = option.get((Options)gameOptions);
        return option.customFormat("physicsmod.menu.block.blockphysicsrange", val >= 319.999 ? Language.m_128107_().m_6834_("physicsmod.menu.block.blockphysicsrange.max") : String.format("%.2f", option.get((Options)gameOptions)));
    }, minecraft -> Component.m_237115_((String)"physicsmod.menu.block.blockphysicsrange.info"));
    private static final ProgressOption PHYSICS_BLOCK_SCALE = new ProgressOption("physicsmod.menu.block.scale", 0.05, 4.0, 0.01f, gameOptions -> ConfigClient.blockSetting.scale, (gameOptions, value) -> {
        ConfigClient.blockSetting.scale = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.block.scale", String.format("%.2f", option.get((Options)gameOptions))));
    private LegacyOptionsList list;

    public BlockSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)Component.m_237115_((String)"physicsmod.menu.blocks.title"));
    }

    protected void m_7856_() {
        this.list = new LegacyOptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        Animation animation = ConfigClient.blockSetting.animation;
        long id = -1L;
        for (Long2ObjectMap.Entry entry : ConfigAnimations.animations.long2ObjectEntrySet()) {
            if (!((Animation)entry.getValue()).equals(animation)) continue;
            id = entry.getLongKey();
            break;
        }
        AnimationOption option = new AnimationOption(Language.m_128107_().m_6834_("physicsmod.animation"), id, (Screen)this, particleChange -> {
            ConfigClient.blockSetting.animation = (Animation)ConfigAnimations.animations.get(Long.parseLong((String)particleChange));
            ConfigClient.save();
        }, "default", false);
        this.list.addSmall(this.PHYSICS_BLOCK, PHYSICS_BLOCKS_RANGE);
        this.list.addSmall(PHYSICS_LIFETIME_BLOCKS, PHYSICS_BLOCK_SCALE);
        this.list.addBig(PHYSICS_LIFETIME_VARIANCE_BLOCKS);
        this.list.addBig(option);
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 - 80, this.f_96544_ - 27, 75, 20, (Component)Component.m_237115_((String)"physicsmod.gui.customize"), button -> this.f_96541_.m_91152_((Screen)new BlockCustomizeScreen((Screen)this, this.f_96541_.f_91066_))));
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 + 5, this.f_96544_ - 27, 75, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.list.m_88315_(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        BaseRenderer.renderSettingsTooltip(this.list, guiGraphics, mouseX, mouseY, this.f_96543_, this.f_96544_);
    }

    public void m_7379_() {
        super.m_7379_();
        if (ConfigClient.areDynamicBlockPhysicsEnabled() && Minecraft.m_91087_().f_91060_ != null) {
            Minecraft.m_91087_().f_91060_.m_109818_();
        }
    }

    public static enum TypeWrapper {
        FRACTURED,
        BLOCKY,
        PARTICLES,
        OFF,
        FRACTURED_VOXEL;


        private static int wrapMainRuleValue(int ordinal) {
            if (ordinal > 3) {
                return ordinal - 1;
            }
            return ordinal;
        }

        private static int unwrapMainRuleValue(int ordinal) {
            if (ordinal > 3) {
                return ordinal + 1;
            }
            return ordinal;
        }
    }
}

