/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings.animation;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Map;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.animation.ParticleEngineExtension;
import net.diebuddies.physics.settings.animation.ParticleExtension;
import net.diebuddies.physics.settings.animation.TextureSheetParticleExtension;
import net.diebuddies.physics.settings.cloth.BaseEntry;
import net.diebuddies.physics.settings.gui.legacy.LegacyObjectSelectionList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ParticleEntry
extends BaseEntry {
    private final String particleID;
    private Particle particle;

    public ParticleEntry(LegacyObjectSelectionList objectSelectionList, String particleID) {
        super(objectSelectionList, particleID);
        this.particleID = particleID;
        try {
            ParticleOptions particleOptions = PhysicsMod.registeredParticles.get(particleID);
            Map<ResourceLocation, ParticleProvider<?>> provider = ((ParticleEngineExtension)Minecraft.m_91087_().f_91061_).getParticleProviders();
            ParticleProvider<?> particleProvider = provider.get(BuiltInRegistries.f_257034_.m_7981_((Object)particleOptions.m_6012_()));
            this.particle = particleProvider.m_6966_(particleOptions, null, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        Particle particle;
        String newText;
        Font font = Minecraft.m_91087_().f_91062_;
        Object text = this.particleID;
        if (font.m_92852_((FormattedText)Component.m_237113_((String)text).m_130940_(ChatFormatting.BOLD)) > this.objectSelectionList.getRowWidth() - 55 && !((String)text).equalsIgnoreCase(newText = font.m_92834_((String)text, this.objectSelectionList.getRowWidth() - 58))) {
            text = newText + "...";
        }
        MutableComponent label = Component.m_237113_((String)text);
        if (hovered) {
            label = label.m_130940_(ChatFormatting.BOLD);
            guiGraphics.m_280653_(font, (Component)label, x + entryWidth / 2 - 2, y + (entryHeight - 11) / 2, 0xFFFFFF);
        } else {
            guiGraphics.m_280653_(font, (Component)label, x + entryWidth / 2 - 2, y + (entryHeight - 11) / 2, 0xC2C2C2);
        }
        if (this.particle != null && (particle = this.particle) instanceof TextureSheetParticleExtension) {
            TextureSheetParticleExtension uvParticle = (TextureSheetParticleExtension)particle;
            PoseStack matrices = RenderSystem.getModelViewStack();
            float scale = (float)entryHeight / 2.0f * 0.9f;
            double startX = -1.0;
            double endX = 1.0;
            double startY = -1.0;
            double endY = 1.0;
            double startZ = -1.0;
            double endZ = 1.0;
            double particleWidth = endX - startX;
            double particleHeight = endY - startY;
            double particleDepth = endZ - startZ;
            double xPosition = this.objectSelectionList.getRowLeft() + 2 + (int)scale;
            double yPosition = y + entryHeight / 2;
            matrices.m_85836_();
            matrices.m_85837_(xPosition, yPosition, 100.0);
            matrices.m_85841_(scale, -scale, scale);
            matrices.m_85837_(-particleWidth * 0.5 - startX, -particleHeight * 0.5 - startY, -particleDepth * 0.5 - startZ);
            RenderSystem.applyModelViewMatrix();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            Minecraft.m_91087_().f_91063_.m_109154_().m_109896_();
            Lighting.m_166384_();
            RenderSystem.enableBlend();
            RenderSystem.disableCull();
            try {
                TextureAtlasSprite sprite = uvParticle.getSprite();
                if (sprite != null) {
                    Tesselator tesselator = Tesselator.m_85913_();
                    BufferBuilder bufferbuilder = tesselator.m_85915_();
                    ParticleRenderType renderType = this.particle.m_7556_();
                    renderType.m_6505_(bufferbuilder, Minecraft.m_91087_().m_91097_());
                    float uvXStart = sprite.m_118409_();
                    float uvXEnd = sprite.m_118410_();
                    float uvYStart = sprite.m_118411_();
                    float uvYEnd = sprite.m_118412_();
                    float rCol = ((ParticleExtension)this.particle).getRed();
                    float gCol = ((ParticleExtension)this.particle).getGreen();
                    float bCol = ((ParticleExtension)this.particle).getBlue();
                    float alpha = ((ParticleExtension)this.particle).getAlpha();
                    int lightColor = 0xF00000;
                    bufferbuilder.m_5483_(-1.0, -1.0, 0.0).m_7421_(uvXEnd, uvYEnd).m_85950_(rCol, gCol, bCol, alpha).m_85969_(lightColor).m_5752_();
                    bufferbuilder.m_5483_(-1.0, 1.0, 0.0).m_7421_(uvXEnd, uvYStart).m_85950_(rCol, gCol, bCol, alpha).m_85969_(lightColor).m_5752_();
                    bufferbuilder.m_5483_(1.0, 1.0, 0.0).m_7421_(uvXStart, uvYStart).m_85950_(rCol, gCol, bCol, alpha).m_85969_(lightColor).m_5752_();
                    bufferbuilder.m_5483_(1.0, -1.0, 0.0).m_7421_(uvXStart, uvYEnd).m_85950_(rCol, gCol, bCol, alpha).m_85969_(lightColor).m_5752_();
                    renderType.m_6294_(tesselator);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            matrices.m_85849_();
            RenderSystem.applyModelViewMatrix();
            Lighting.m_84931_();
        }
    }

    public String getText() {
        return this.particleID;
    }

    @Override
    public Component getNarration() {
        return Component.m_237113_((String)this.particleID);
    }
}

