/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.physics.settings;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.liquid.Liquid;
import net.diebuddies.physics.settings.ButtonSettings;
import net.diebuddies.physics.settings.gui.legacy.CycleOption;
import net.diebuddies.physics.settings.gui.legacy.LegacyOptionsList;
import net.diebuddies.physics.settings.gui.legacy.ProgressOption;
import net.diebuddies.physics.settings.ux.BaseRenderer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class LiquidSettingsScreen
extends OptionsSubScreen {
    private LegacyOptionsList list;
    private static final CycleOption<Boolean> PHYSICS_LIQUIDS = CycleOption.createOnOff("physicsmod.menu.liquid.liquidphysics", gameOptions -> ConfigClient.liquidPhysics, (gameOptions, option, value) -> {
        ConfigClient.liquidPhysics = value;
        ConfigClient.save();
        if (!ConfigClient.liquidPhysics) {
            for (PhysicsMod mod : PhysicsMod.getInstances().values()) {
                ObjectArrayList liquids = new ObjectArrayList(mod.getPhysicsWorld().getLiquids());
                for (Liquid liquid : liquids) {
                    mod.getPhysicsWorld().removeLiquid(liquid);
                }
            }
        }
    });
    private final CycleOption<Boolean> PHYSICS_CUDA_LIQUIDS = CycleOption.createOnOff("physicsmod.menu.liquid.cudaliquids", gameOptions -> ConfigClient.cudaLiquids, (gameOptions, option, value) -> {
        if (((CycleOption)option).active) {
            ConfigClient.cudaLiquids = value;
            ConfigClient.save();
            StarterClient.createPhysicsCooking(ConfigClient.cudaLiquids());
            this.list.m_6702_().clear();
            Minecraft.m_91087_().m_91152_((Screen)new LiquidSettingsScreen(this.f_96281_, this.f_96282_));
        }
    }).setTooltip(minecraft -> graphicsStatus -> {
        if (Minecraft.m_91087_().f_91073_ != null || !StarterClient.cudaAvailable) {
            return Component.m_237115_((String)"physicsmod.menu.liquid.cudaliquids.error");
        }
        return Component.m_237115_((String)"physicsmod.menu.liquid.cudaliquids.info");
    });
    private static final ProgressOption PHYSICS_CUDA_LIQUIDS_PARTICLE_SIZE = new ProgressOption("physicsmod.menu.liquid.cudaliquids.size", 0.05, 0.5, 0.01f, gameOptions -> ConfigClient.cudaLiquidsParticleSize, (gameOptions, value) -> {
        ConfigClient.cudaLiquidsParticleSize = value.floatValue();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.cudaliquids.size", String.format("%.2f", option.get((Options)gameOptions))), minecraft -> {
        if (Minecraft.m_91087_().f_91073_ != null || !StarterClient.cudaAvailable) {
            return Component.m_237115_((String)"physicsmod.menu.liquid.cudaliquids.size.error");
        }
        return Component.m_237115_((String)"physicsmod.menu.liquid.cudaliquids.size.info");
    });
    private static final ProgressOption PHYSICS_CUDA_LIQUIDS_BLUR_PASSES = new ProgressOption("physicsmod.menu.liquid.cudaliquids.blur", 1.0, 10.0, 1.0f, gameOptions -> ConfigClient.cudaLiquidsBlurPasses, (gameOptions, value) -> {
        ConfigClient.cudaLiquidsBlurPasses = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.cudaliquids.blur", Integer.toString((int)option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.liquid.cudaliquids.blur.info"));
    private static final ProgressOption PHYSICS_LIQUID_CPU_THREADS = new ProgressOption("physicsmod.menu.liquid.liquidthreads", 1.0, Runtime.getRuntime().availableProcessors(), 1.0f, gameOptions -> ConfigClient.liquidThreads, (gameOptions, value) -> {
        ConfigClient.liquidThreads = Math.max(value.intValue(), 1);
        ConfigClient.save();
        if (Liquid.threads != null) {
            for (int i = 0; i < Liquid.threads.length; ++i) {
                Liquid.threads[i].cancel();
            }
        }
        Liquid.threads = null;
        Liquid.initThreads();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.liquidthreads", Integer.toString((int)option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.liquid.liquidthreads.info"));
    private static final ProgressOption PHYSICS_LIQUID_DENSITY = new ProgressOption("physicsmod.menu.liquid.waterdensity", 3.0, 8.0, 1.0f, gameOptions -> ConfigClient.waterDensity, (gameOptions, value) -> {
        ConfigClient.waterDensity = Math.max(value.intValue(), 1);
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.waterdensity", Integer.toString((int)option.get((Options)gameOptions))), minecraft -> Component.m_237115_((String)"physicsmod.menu.liquid.waterdensity.info"));
    private static final ProgressOption PHYSICS_LIQUID_SOURCE_DISTANCE = new ProgressOption("physicsmod.menu.liquid.liquidsourcedistance", 1.0, 40.0, 0.1f, gameOptions -> ConfigClient.liquidSourceDistance, (gameOptions, value) -> {
        ConfigClient.liquidSourceDistance = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.liquidsourcedistance", String.format("%.0f", option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimeliquids", 0.0, 100.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeLiquids, (gameOptions, value) -> {
        ConfigClient.particleLifetimeLiquids = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimeliquids", String.format("%.2f", option.get((Options)gameOptions))));
    private static final ProgressOption PHYSICS_LIFETIME_VARIANCE_LIQUID = new ProgressOption("physicsmod.menu.liquid.particlelifetimevarianceliquids", 0.0, 30.0, 0.1f, gameOptions -> ConfigClient.particleLifetimeVarianceLiquids, (gameOptions, value) -> {
        ConfigClient.particleLifetimeVarianceLiquids = value;
        ConfigClient.save();
    }, (gameOptions, option) -> option.customFormat("physicsmod.menu.liquid.particlelifetimevarianceliquids", String.format("%.2f", option.get((Options)gameOptions))));
    private static final int MAX_INFO_WIDTH = 300;
    private List<FormattedCharSequence> info;

    public LiquidSettingsScreen(Screen parent, Options options) {
        super(parent, options, (Component)Component.m_237115_((String)"physicsmod.menu.liquid.title.pro"));
        this.info = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"physicsmod.menu.liquid.warning"), 300);
    }

    protected void m_7856_() {
        this.list = new LegacyOptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        if (Minecraft.m_91087_().f_91073_ != null || !StarterClient.cudaAvailable) {
            this.PHYSICS_CUDA_LIQUIDS.active = false;
            LiquidSettingsScreen.PHYSICS_CUDA_LIQUIDS_PARTICLE_SIZE.active = false;
            this.list.renderBackgroundWhenIngame = false;
        } else {
            this.PHYSICS_CUDA_LIQUIDS.active = true;
            LiquidSettingsScreen.PHYSICS_CUDA_LIQUIDS_PARTICLE_SIZE.active = true;
        }
        if (ConfigClient.cudaLiquids()) {
            this.list.addBig(this.PHYSICS_CUDA_LIQUIDS);
            this.list.addBig(PHYSICS_CUDA_LIQUIDS_PARTICLE_SIZE);
            this.list.addBig(PHYSICS_CUDA_LIQUIDS_BLUR_PASSES);
            this.info = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"physicsmod.menu.liquid.cudaliquids.commands"), 300);
        } else {
            this.list.addSmall(PHYSICS_LIQUIDS, this.PHYSICS_CUDA_LIQUIDS);
            this.list.addSmall(PHYSICS_LIQUID_DENSITY, PHYSICS_LIQUID_CPU_THREADS);
            this.list.addBig(PHYSICS_LIQUID_SOURCE_DISTANCE);
            this.list.addSmall(PHYSICS_LIFETIME_LIQUID, PHYSICS_LIFETIME_VARIANCE_LIQUID);
            this.info = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)Component.m_237115_((String)"physicsmod.menu.liquid.warning"), 300);
        }
        this.f_96540_.add(this.list);
        this.m_142416_((GuiEventListener)ButtonSettings.builder(this.f_96543_ / 2 - 50, this.f_96544_ - 27, 100, 20, CommonComponents.f_130655_, button -> this.f_96541_.m_91152_(this.f_96281_)));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.list.m_88315_(guiGraphics, mouseX, mouseY, delta);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 15, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        int yOffset = 137;
        if (ConfigClient.cudaLiquids()) {
            yOffset = 112;
        }
        int lineY = 0;
        for (FormattedCharSequence sequence : this.info) {
            guiGraphics.m_280648_(this.f_96547_, sequence, (this.f_96543_ - 300) / 2, yOffset + lineY, 0xFFFF55);
            lineY += 10;
        }
        BaseRenderer.renderSettingsTooltip(this.list, guiGraphics, mouseX, mouseY, this.f_96543_, this.f_96544_);
    }

    public void m_7379_() {
        ConfigClient.save();
        super.m_7379_();
    }

    private /* synthetic */ void lambda$init$32(Button button) {
        this.f_96541_.m_91152_(this.f_96281_);
    }

    private static /* synthetic */ void lambda$init$31(Button button) {
        Util.m_137581_().m_137646_("https://minecraftphysicsmod.com/pro");
    }
}

