/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.mixins.ocean.MixinParticle;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ocean.OceanWorld;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.WaterDropParticle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WaterDropParticle.class})
public class MixinWaterDropParticle
extends MixinParticle {
    @Unique
    private double physicsOffset;
    @Unique
    private BlockPos.MutableBlockPos mutable;

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    protected void constructor(ClientLevel clientLevel, double x, double y, double z, CallbackInfo info) {
        if (ConfigClient.areOceanPhysicsEnabled() && this.f_107208_ != null) {
            OceanWorld oceanWorld = PhysicsMod.getInstance((Level)this.f_107208_).getPhysicsWorld().getOceanWorld();
            this.physicsOffset = oceanWorld.calculateYOffset(x, y, z);
            this.f_107210_ = y + this.physicsOffset;
            Particle particle = (Particle)this;
            particle.m_107264_(x, y + this.physicsOffset, z);
        }
    }

    @Override
    protected void getLightColor(float renderPercent, CallbackInfoReturnable<Integer> info) {
        if (ConfigClient.areOceanPhysicsEnabled() && this.f_107208_ != null) {
            if (this.mutable == null) {
                this.mutable = new BlockPos.MutableBlockPos();
            }
            this.mutable.m_122169_(this.f_107212_, this.f_107213_ - this.physicsOffset, this.f_107214_);
            if (this.f_107208_.m_46805_((BlockPos)this.mutable)) {
                info.setReturnValue((Object)LevelRenderer.m_109541_((BlockAndTintGetter)this.f_107208_, (BlockPos)this.mutable));
            } else {
                info.setReturnValue((Object)0);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"}, cancellable=true)
    public void tick(CallbackInfo info) {
        if (ConfigClient.areOceanPhysicsEnabled()) {
            double d;
            Particle particle = (Particle)this;
            this.f_107209_ = this.f_107212_;
            this.f_107210_ = this.f_107213_;
            this.f_107211_ = this.f_107214_;
            if (this.f_107225_-- <= 0) {
                particle.m_107274_();
                return;
            }
            this.f_107216_ -= (double)this.f_107226_;
            particle.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            this.f_107215_ *= (double)0.98f;
            this.f_107216_ *= (double)0.98f;
            this.f_107217_ *= (double)0.98f;
            if (this.f_107218_) {
                if (Math.random() < 0.5) {
                    particle.m_107274_();
                }
                this.f_107215_ *= (double)0.7f;
                this.f_107217_ *= (double)0.7f;
            }
            BlockPos blockPos = BlockPos.m_274561_((double)this.f_107212_, (double)(this.f_107213_ - this.physicsOffset), (double)this.f_107214_);
            double d2 = Math.max(this.f_107208_.m_8055_(blockPos).m_60812_((BlockGetter)this.f_107208_, blockPos).m_83290_(Direction.Axis.Y, this.f_107212_ - (double)blockPos.m_123341_(), this.f_107214_ - (double)blockPos.m_123343_()), (double)this.f_107208_.m_6425_(blockPos).m_76155_((BlockGetter)this.f_107208_, blockPos));
            if (d > 0.0 && this.f_107213_ < (double)blockPos.m_123342_() + d2) {
                particle.m_107274_();
            }
            info.cancel();
        }
    }
}

