/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.ocean;

import java.util.Map;
import net.diebuddies.bridge.WeatherParticlesRegistry;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.ocean.EntityOcean;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.settings.animation.ParticleEngineExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Boat.class})
public class MixinBoat {
    @Shadow
    private Boat.Status f_38279_;

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void tick(CallbackInfo info) {
        Level level;
        Boat boat = (Boat)this;
        if (ConfigClient.areOceanPhysicsEnabled() && (level = boat.m_9236_()) instanceof ClientLevel) {
            ClientLevel level2 = (ClientLevel)level;
            if (this.f_38279_ == Boat.Status.IN_WATER && ConfigClient.oceanParticles) {
                int i;
                double diffX = boat.m_20185_() - boat.f_19854_;
                double diffZ = boat.m_20189_() - boat.f_19856_;
                double velocity = java.lang.Math.sqrt(diffX * diffX + diffZ * diffZ);
                double speed = boat.m_20184_().m_165924_();
                if (velocity < 0.1 || ((EntityOcean)boat).isInPhysicsAir()) {
                    return;
                }
                OceanWorld oceanWorld = PhysicsMod.getInstance(boat.m_9236_()).getPhysicsWorld().getOceanWorld();
                Vec3 forward = boat.m_20156_();
                double yOffset = oceanWorld.calculateYOffset(boat.m_20185_() + forward.f_82479_, boat.m_20186_() + forward.f_82480_, boat.m_20189_() + forward.f_82481_);
                double dirfirst = 1.0;
                double dirsecond = -1.0;
                double angle = java.lang.Math.toRadians(boat.m_146908_());
                double vx1 = dirfirst * java.lang.Math.cos(angle);
                double vz1 = dirfirst * java.lang.Math.sin(angle);
                double vx2 = dirsecond * java.lang.Math.cos(angle);
                double vz2 = dirsecond * java.lang.Math.sin(angle);
                double x1 = 0.6;
                double z1 = 0.5;
                angle = java.lang.Math.toRadians(boat.m_146908_());
                double rotatedX1 = x1 * java.lang.Math.cos(angle) - z1 * java.lang.Math.sin(angle);
                double rotatedZ1 = x1 * java.lang.Math.sin(angle) + z1 * java.lang.Math.cos(angle);
                ParticleEngine particleEngine = Minecraft.m_91087_().f_91061_;
                Map<ResourceLocation, ParticleProvider<?>> provider = ((ParticleEngineExtension)particleEngine).getParticleProviders();
                ParticleProvider<?> smallProvider = provider.get(WeatherParticlesRegistry.SPLASH_SMALL_RESOURCE);
                for (int i2 = 0; i2 < 5; ++i2) {
                    if (!(velocity * 1.0 > (double)Math.random())) continue;
                    particleEngine.m_107344_(smallProvider.m_6966_((ParticleOptions)WeatherEffects.PHYSICS_SPLASH_SMALL, level2, boat.m_20185_() + rotatedX1 + ((double)Math.random() - 0.5) * 0.3, boat.m_20186_() + yOffset + 0.35 + (double)Math.random() * 0.2, boat.m_20189_() + rotatedZ1 + ((double)Math.random() - 0.5) * 0.3, vx1 * 0.04 + ((double)Math.random() - 0.5) * 0.1, 0.1 + ((double)Math.random() - 0.5) * 0.1, vz1 * 0.04 + ((double)Math.random() - 0.5) * 0.1));
                }
                double x2 = -0.6;
                double z2 = 0.5;
                angle = java.lang.Math.toRadians(boat.m_146908_());
                double rotatedX2 = x2 * java.lang.Math.cos(angle) - z2 * java.lang.Math.sin(angle);
                double rotatedZ2 = x2 * java.lang.Math.sin(angle) + z2 * java.lang.Math.cos(angle);
                for (i = 0; i < 5; ++i) {
                    if (!(velocity * 1.0 > (double)Math.random())) continue;
                    particleEngine.m_107344_(smallProvider.m_6966_((ParticleOptions)WeatherEffects.PHYSICS_SPLASH_SMALL, level2, boat.m_20185_() + rotatedX2 + ((double)Math.random() - 0.5) * 0.3, boat.m_20186_() + yOffset + 0.35 + (double)Math.random() * 0.2, boat.m_20189_() + rotatedZ2 + ((double)Math.random() - 0.5) * 0.3, vx2 * 0.04 * speed + ((double)Math.random() - 0.5) * 0.1, 0.1 + ((double)Math.random() - 0.5) * 0.1, vz2 * 0.04 * speed + ((double)Math.random() - 0.5) * 0.1));
                }
                for (i = 0; i < 8; ++i) {
                    if (!(velocity * 1.0 > (double)Math.random())) continue;
                    double perc = Math.random();
                    double nx = Mth.m_14139_((double)perc, (double)rotatedX1, (double)rotatedX2);
                    double nz = Mth.m_14139_((double)perc, (double)rotatedZ1, (double)rotatedZ2);
                    particleEngine.m_107344_(smallProvider.m_6966_((ParticleOptions)WeatherEffects.PHYSICS_SPLASH_SMALL, level2, boat.m_20185_() + nx + ((double)Math.random() - 0.5) * 0.3, boat.m_20186_() + yOffset + 0.35 + (double)Math.random() * 0.2, boat.m_20189_() + nz + ((double)Math.random() - 0.5) * 0.3, forward.f_82479_ * speed * 1.15 + ((double)Math.random() - 0.5) * 0.3, 0.1 + ((double)Math.random() - 0.5) * 0.1, forward.f_82481_ * speed * 1.15 + ((double)Math.random() - 0.5) * 0.3));
                }
            }
        }
    }
}

