/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.ocean.OceanWorld;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.LeashConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.diebuddies.util.ObjectPacked;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import org.joml.Vector3d;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MobRenderer.class}, priority=900)
public abstract class MixinMobRenderer
extends EntityRenderer {
    @Unique
    private Map<ObjectPacked, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    @Unique
    private ObjectPacked tmp = new ObjectPacked(null, null);
    @Unique
    private static double oceanOffset;

    protected MixinMobRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    @Inject(at={@At(value="HEAD")}, method={"renderLeash"}, cancellable=true)
    private void renderLeash(Mob mob, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, Entity entity, CallbackInfo info) {
        if (ConfigClient.areOceanPhysicsEnabled() && !ConfigClient.leashPhysics && entity != null && entity.m_9236_() instanceof ClientLevel) {
            OceanWorld oceanWorld = PhysicsMod.getInstance(entity.m_9236_()).getPhysicsWorld().getOceanWorld();
            oceanOffset = oceanWorld.computeYOffset(entity.m_9236_(), entity, tickDelta) - oceanWorld.computeYOffset(mob.m_9236_(), (Entity)mob, 1.0f);
        }
        if (ConfigClient.leashPhysics && mob.m_20193_() instanceof ClientLevel) {
            Iterator<Map.Entry<ObjectPacked, VerletSimulation>> it = this.simulations.entrySet().iterator();
            while (it.hasNext()) {
                if (!it.next().getValue().destroyed) continue;
                it.remove();
            }
            this.tmp.e1 = mob;
            this.tmp.e2 = entity;
            VerletSimulation simulation = this.simulations.get(this.tmp);
            BlockPos mob1Pos = BlockPos.m_274446_((Position)mob.m_20299_(tickDelta));
            int mob1Brightness = this.m_6086_((Entity)mob, mob1Pos);
            int mob1BrightnessSky = mob.m_9236_().m_45517_(LightLayer.SKY, mob1Pos);
            int brightness = LightTexture.m_109885_((int)mob1Brightness, (int)mob1BrightnessSky);
            if (simulation == null) {
                simulation = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(mob.m_20193_().m_46472_().m_135782_())), 20, 0.855);
                simulation.addConstraint(new WorldConstraint((Entity)mob, 0.25f));
                simulation.addConstraint(new LeashConstraint(simulation, mob, entity, this.f_114476_, tickDelta));
                simulation.brightness = brightness;
                simulation.textureID = PhysicsMod.whiteTexture.getID();
                simulation.alwaysFetchInstantly = false;
                this.simulations.put(new ObjectPacked(mob, entity), simulation);
                PhysicsMod.getInstance((Level)mob.m_20193_()).physicsWorld.addVerletSimulation(simulation);
            } else if (!simulation.destroyed) {
                simulation.active = true;
                simulation.brightness = brightness;
            }
            if (StarterClient.optifabric) {
                PhysicsMod.optifineClothCompat.add(simulation);
            } else {
                simulation.renderSlow(mob.m_20193_());
            }
            info.cancel();
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"addVertexPair"}, ordinal=1)
    private static float addVertexPair(float y) {
        return y + (float)oceanOffset;
    }
}

