/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigCloth;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.PhysicsWorld;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.Cloth;
import net.diebuddies.physics.verlet.ClothRenderCommand;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.ModelPartConstraint;
import net.diebuddies.physics.verlet.constraints.OceanPhysicsDisplacementConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.diebuddies.util.PlayerLevelPacked;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.joml.Matrix4d;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public class MixinCapeFeatureRenderer {
    @Unique
    private Map<PlayerLevelPacked, VerletSimulation> simulations = new Object2ObjectOpenHashMap();
    @Unique
    private Matrix4f localT = new Matrix4f();
    @Unique
    private AbstractClientPlayer player;
    @Unique
    private boolean renderedCape;
    @Unique
    private MultiBufferSource multiBufferSource;
    @Unique
    private PlayerLevelPacked tmp = new PlayerLevelPacked(null, null);

    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void physicsmod$renderHead(PoseStack matrixStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
        this.player = player;
        this.renderedCape = false;
        this.multiBufferSource = multiBufferSource;
    }

    @Inject(at={@At(value="RETURN")}, method={"render"})
    private void physicsmod$renderTail(PoseStack matrixStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, CallbackInfo info) {
        this.physicsmod$removeOldSimulations();
        boolean renderCloth = true;
        if (!renderCloth || !this.physicsmod$shouldRenderPhysicsCape(player) || this.renderedCape || !this.physicsmod$hasPhysicsCape(player)) {
            // empty if block
        }
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/model/PlayerModel;renderCloak(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V"))
    private void physicsmod$renderCloak(PlayerModel playerModel, PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay) {
        this.physicsmod$removeOldSimulations();
        boolean renderCloth = true;
        if (renderCloth && this.physicsmod$shouldRenderPhysicsCape(this.player)) {
            if (!this.physicsmod$hasPhysicsCape(this.player)) {
                this.physicsmod$renderPhysicsCape(this.player, light);
            }
        } else {
            ((PlayerModel)((CapeLayer)this).m_117386_()).m_103411_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_);
        }
        this.renderedCape = true;
    }

    @Unique
    private boolean physicsmod$shouldRenderPhysicsCape(AbstractClientPlayer player) {
        return !PhysicsMod.hudRendering && ConfigClient.capePhysics && player != null && player.m_108555_() && !player.m_20145_() && this.physicsmod$hasMojangCape(player);
    }

    @Unique
    private boolean physicsmod$hasMojangCape(AbstractClientPlayer player) {
        return player.m_108561_() != null;
    }

    @Unique
    private boolean physicsmod$hasPhysicsCape(AbstractClientPlayer player) {
        return ConfigCloth.hasCategory((Entity)player, "Back");
    }

    @Unique
    private void physicsmod$removeOldSimulations() {
        Iterator<Map.Entry<PlayerLevelPacked, VerletSimulation>> it = this.simulations.entrySet().iterator();
        while (it.hasNext()) {
            if (!it.next().getValue().destroyed) continue;
            it.remove();
        }
    }

    @Unique
    private void physicsmod$renderPhysicsCape(AbstractClientPlayer player, int light) {
        ItemStack itemStack = player.m_6844_(EquipmentSlot.CHEST);
        Level level = player.m_20193_();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        this.tmp.e1 = player.m_36316_().getName();
        this.tmp.e2 = level;
        VerletSimulation simulation = this.simulations.get(this.tmp);
        if (!itemStack.m_150930_(Items.f_42741_)) {
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            boolean renderFast = false;
            if (camera.m_90588_().m_123331_((Vec3i)player.m_20183_()) > (double)(ConfigClient.clothEntityRange * ConfigClient.clothEntityRange)) {
                renderFast = true;
            }
            Cloth cloth = PhysicsMod.defaultCape;
            LivingEntityRenderer renderer = (LivingEntityRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
            EntityModel model = renderer.m_7200_();
            if (renderFast || !cloth.rules.isDynamic()) {
                ModelPart modelPart = ModelPartConstraint.getPart((Model)model, "body");
                int textureID = Minecraft.m_91087_().m_91097_().m_118506_(player.m_108561_()).m_117963_();
                if (cloth != null && modelPart != null) {
                    PhysicsMod.clothRenderFast.add(new ClothRenderCommand(cloth, textureID, (LivingEntity)player, modelPart, light));
                }
            } else {
                if (simulation == null) {
                    boolean alwaysInstantlyUpdate;
                    EntityModel entityModel;
                    if (model instanceof EntityModel && !ModelPartConstraint.exists((EntityModel<LivingEntity>)(entityModel = model), "body")) {
                        return;
                    }
                    int quality = player == Minecraft.m_91087_().f_91074_ ? 90 : 45;
                    simulation = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(level.m_46472_().m_135782_())), quality, 0.855);
                    ModelPartConstraint modelPartConstraint = new ModelPartConstraint(simulation, cloth.rules.getIgnoreParts(), (LivingEntity)player, "body", (Model)model);
                    PoseStack modelMatrix = new PoseStack();
                    ModelPartConstraint.entityTransformation(modelMatrix, simulation, (LivingEntity)player, (Model)model, 1.0f);
                    modelPartConstraint.modelPartTransformation(modelMatrix);
                    Matrix4d partTransformation = new Matrix4d();
                    partTransformation.set((Matrix4fc)modelMatrix.m_85850_().m_252922_());
                    simulation.getConstraints().clear();
                    simulation.addConstraint(new OceanPhysicsDisplacementConstraint((Entity)player));
                    simulation.addConstraint(modelPartConstraint);
                    simulation.addConstraint(new WorldConstraint((Entity)player));
                    simulation.brightness = light;
                    int textureID = Minecraft.m_91087_().m_91097_().m_118506_(player.m_108561_()).m_117963_();
                    simulation.addCloth(PhysicsMod.defaultCape, textureID, partTransformation, false);
                    simulation.setOffset(new Vector3d(player.m_20185_(), player.m_20186_(), player.m_20189_()).add((Vector3dc)simulation.getOffset()), false);
                    simulation.setTransformation(partTransformation);
                    simulation.setBufferTransformation(partTransformation);
                    simulation.updateOffsets();
                    PhysicsWorld physicsWorld = PhysicsMod.getInstance((Level)level).physicsWorld;
                    modelPartConstraint.initAsyncData(physicsWorld, simulation);
                    modelPartConstraint.changeInstantly = true;
                    modelPartConstraint.updateAfter(0.0, simulation);
                    simulation.downloadData();
                    simulation.alwaysFetchInstantly = alwaysInstantlyUpdate = player == Minecraft.m_91087_().f_91074_;
                    this.simulations.put(new PlayerLevelPacked(player.m_36316_().getName(), player.m_20193_()), simulation);
                    if (alwaysInstantlyUpdate) {
                        physicsWorld.addVerletSimulation(0, simulation);
                    } else {
                        physicsWorld.addVerletSimulation(simulation);
                    }
                } else if (!simulation.destroyed) {
                    simulation.active = true;
                    simulation.brightness = light;
                }
                if (cloth != simulation.cloth) {
                    simulation.destroyed = true;
                }
                if (StarterClient.optifabric) {
                    PhysicsMod.optifineClothCompat.add(simulation);
                } else {
                    simulation.renderSlow(player.m_20193_());
                }
            }
        }
    }
}

