/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins.cloth;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.physics.verlet.VerletSimulation;
import net.diebuddies.physics.verlet.constraints.BannerConstraint;
import net.diebuddies.physics.verlet.constraints.ClosestPlayerConstraint;
import net.diebuddies.physics.verlet.constraints.WindConstraint;
import net.diebuddies.physics.verlet.constraints.WorldConstraint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Vector3d;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BannerRenderer.class})
public abstract class MixinBannerRenderer {
    @Shadow
    @Final
    private ModelPart f_112045_;
    @Shadow
    @Final
    private ModelPart f_112046_;
    @Shadow
    @Final
    private ModelPart f_112047_;
    @Unique
    private Map<BannerBlockEntity, VerletSimulation> simulations = new Object2ObjectOpenHashMap();

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    public void render(BannerBlockEntity bannerBlockEntity, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int brightness, int j, CallbackInfo info) {
        if (ConfigClient.bannerPhysics) {
            boolean guiRendering;
            List list = bannerBlockEntity.m_58508_();
            boolean bl = guiRendering = bannerBlockEntity.m_58904_() == null;
            if (list != null && !guiRendering && bannerBlockEntity.m_58904_() instanceof ClientLevel) {
                BlockPos blockPos = bannerBlockEntity.m_58899_();
                boolean isPlayerInSight = false;
                if (Minecraft.m_91087_().f_91074_ != null) {
                    boolean bl2 = isPlayerInSight = Minecraft.m_91087_().f_91074_.m_20183_().m_123331_((Vec3i)blockPos) < ConfigClient.bannerPhysicsRange * ConfigClient.bannerPhysicsRange;
                }
                if (isPlayerInSight) {
                    long gameTime;
                    poseStack.m_85836_();
                    if (guiRendering) {
                        gameTime = 0L;
                        poseStack.m_85837_(0.5, 0.5, 0.5);
                        this.f_112046_.f_104207_ = true;
                    } else {
                        gameTime = bannerBlockEntity.m_58904_().m_46467_();
                        BlockState blockState = bannerBlockEntity.m_58900_();
                        if (blockState.m_60734_() instanceof BannerBlock) {
                            poseStack.m_85837_(0.5, 0.5, 0.5);
                            blockRotation = (float)(-((Integer)blockState.m_61143_((Property)BannerBlock.f_49007_)).intValue() * 360) / 16.0f;
                            poseStack.m_252781_(Axis.f_252436_.m_252977_(blockRotation));
                            this.f_112046_.f_104207_ = true;
                        } else {
                            poseStack.m_85837_(0.5, -0.1666666716337204, 0.5);
                            blockRotation = -((Direction)blockState.m_61143_((Property)WallBannerBlock.f_57916_)).m_122435_();
                            poseStack.m_252781_(Axis.f_252436_.m_252977_(blockRotation));
                            poseStack.m_85837_(0.0, -0.3125, -0.4375);
                            this.f_112046_.f_104207_ = false;
                        }
                    }
                    poseStack.m_85836_();
                    poseStack.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
                    VertexConsumer vertexConsumer = ModelBakery.f_119224_.m_119194_(multiBufferSource, RenderType::m_110446_);
                    this.f_112046_.m_104301_(poseStack, vertexConsumer, brightness, j);
                    this.f_112047_.m_104301_(poseStack, vertexConsumer, brightness, j);
                    float n = ((float)Math.floorMod((long)(blockPos.m_123341_() * 7 + blockPos.m_123342_() * 9 + blockPos.m_123343_() * 13) + gameTime, 100L) + tickDelta) / 100.0f;
                    this.f_112045_.f_104203_ = (-0.0125f + 0.01f * Mth.m_14089_((float)((float)Math.PI * 2 * n))) * (float)Math.PI;
                    this.f_112045_.f_104201_ = -32.0f;
                    Level level = bannerBlockEntity.m_58904_();
                    Iterator<Map.Entry<BannerBlockEntity, VerletSimulation>> it = this.simulations.entrySet().iterator();
                    while (it.hasNext()) {
                        if (!it.next().getValue().destroyed) continue;
                        it.remove();
                    }
                    VerletSimulation simulation = this.simulations.get(bannerBlockEntity);
                    PhysicsMod mod = PhysicsMod.getInstance(level);
                    if (simulation == null) {
                        simulation = new VerletSimulation(new Vector3d((Vector3fc)ConfigClient.getGravity(bannerBlockEntity.m_58904_().m_46472_().m_135782_())), 25, 0.93);
                        simulation.addConstraint(new WorldConstraint(bannerBlockEntity.m_58904_(), 1.0f));
                        simulation.addConstraint(new ClosestPlayerConstraint(bannerBlockEntity.m_58904_()));
                        simulation.addConstraint(new BannerConstraint(simulation, bannerBlockEntity, this.f_112046_, this.f_112047_, tickDelta));
                        simulation.addConstraint(new WindConstraint());
                        simulation.brightness = brightness;
                        simulation.textureID = PhysicsMod.whiteTexture.getID();
                        simulation.alwaysFetchInstantly = false;
                        this.simulations.put(bannerBlockEntity, simulation);
                        mod.physicsWorld.addVerletSimulation(simulation);
                    } else if (!simulation.destroyed) {
                        simulation.active = true;
                        simulation.brightness = brightness;
                    }
                    if (StarterClient.optifabric) {
                        PhysicsMod.optifineClothCompat.add(simulation);
                    } else {
                        simulation.renderSlow(level);
                    }
                    poseStack.m_85849_();
                    poseStack.m_85849_();
                    info.cancel();
                }
            }
        }
    }
}

