/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.config.ConfigMobs;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.ParticleSpawner;
import net.diebuddies.physics.PhysicsMod;
import net.diebuddies.physics.settings.mobs.MobPhysicsType;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class MixinLivingEntity {
    @Shadow
    @Final
    protected boolean f_20890_;

    @Inject(at={@At(value="HEAD")}, method={"die"})
    public void onDeath(DamageSource source, CallbackInfo info) {
        LivingEntity entity = (LivingEntity)this;
        if (RenderSystem.isOnRenderThread() && ConfigMobs.getMobSetting((Entity)entity).getType() != MobPhysicsType.OFF) {
            PhysicsMod.blockifyEntity(entity.m_20193_(), entity);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnItemParticles"}, cancellable=true)
    private void spawnItemParticles(ItemStack itemStack, int amount, CallbackInfo info) {
        Camera camera;
        LivingEntity ths = (LivingEntity)this;
        if (ConfigClient.eatingPhysicsParticles && ths.m_9236_() instanceof ClientLevel && (camera = Minecraft.m_91087_().f_91063_.m_109153_()).m_90593_() && camera.m_90583_().m_82531_(ths.m_20185_(), ths.m_20188_(), ths.m_20189_()) < ConfigClient.blockPhysicsRange * ConfigClient.blockPhysicsRange) {
            for (int j = 0; j < amount * 2; ++j) {
                Vec3 vel = new Vec3(((double)Math.random() - 0.5) * 0.1, (double)Math.random() * 0.1 + 0.1, 0.0);
                vel = vel.m_82496_(-ths.m_146909_() * ((float)java.lang.Math.PI / 180));
                vel = vel.m_82524_(-ths.m_146908_() * ((float)java.lang.Math.PI / 180));
                double d = (double)(-Math.random()) * 0.6 - 0.3;
                Vec3 pos = new Vec3(((double)Math.random() - 0.5) * 0.3, d, 0.6);
                pos = pos.m_82496_(-ths.m_146909_() * ((float)java.lang.Math.PI / 180));
                pos = pos.m_82524_(-ths.m_146908_() * ((float)java.lang.Math.PI / 180));
                pos = pos.m_82520_(ths.m_20185_(), ths.m_20188_(), ths.m_20189_());
                ParticleSpawner.spawnEatingPhysicsParticle(itemStack, ths.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, vel.f_82479_ * 15.0, vel.f_82480_ * 15.0, vel.f_82481_ * 15.0);
            }
            info.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleEntityEvent"}, cancellable=true)
    private void handleEntityEvent(byte event, CallbackInfo info) {
        ItemStack stack;
        LivingEntity ths = (LivingEntity)this;
        if (ths != Minecraft.m_91087_().f_91074_) {
            return;
        }
        if (event == 47) {
            ItemStack stack2 = ths.m_6844_(EquipmentSlot.MAINHAND);
            if (!stack2.m_41619_()) {
                this.spawnItemBreakPhysics(stack2, true);
            }
        } else if (event == 48 && !(stack = ths.m_6844_(EquipmentSlot.OFFHAND)).m_41619_()) {
            this.spawnItemBreakPhysics(stack, false);
        }
    }

    @Unique
    private void spawnItemBreakPhysics(ItemStack stack, boolean mainHand) {
        if (ConfigClient.itemBreakPhysics && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
            LivingEntity ths = (LivingEntity)this;
            PhysicsMod.blockifyItemStack(ths.m_9236_(), stack, mainHand);
        }
    }
}

