/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import com.mojang.blaze3d.systems.RenderSystem;
import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.ParticleSpawner;
import net.diebuddies.physics.Explosion;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public class MixinClientPacketListener {
    @Shadow
    @Final
    private RandomSource f_104898_;
    @Shadow
    @Final
    private ClientLevel f_104889_;

    @Inject(at={@At(value="HEAD")}, method={"handleExplosion"})
    public void handleExplosion(ClientboundExplodePacket explosionPacket, CallbackInfo info) {
        if (RenderSystem.isOnRenderThread()) {
            Explosion explosion = new Explosion();
            explosion.strength = explosionPacket.m_132135_();
            explosion.position = new Vector3d(explosionPacket.m_132132_(), explosionPacket.m_132133_(), explosionPacket.m_132134_());
            PhysicsMod mod = PhysicsMod.getInstance((Level)this.f_104889_);
            mod.explosions.add(explosion);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleRemoveEntities"})
    public void handleRemoveEntities(ClientboundRemoveEntitiesPacket packetIn, CallbackInfo info) {
        if (RenderSystem.isOnRenderThread()) {
            for (int i = 0; i < packetIn.m_182730_().size(); ++i) {
                int j = packetIn.m_182730_().getInt(i);
                Entity entity = Minecraft.m_91087_().f_91074_.f_108545_.m_6815_(j);
                if (entity == null || !ConfigClient.pvpServerCompatibility && !(entity instanceof EnderDragon) && !(entity instanceof Creeper) || !(entity.m_20182_().m_82554_(Minecraft.m_91087_().f_91074_.m_20182_()) < 40.0) || !(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                PhysicsMod.blockifyEntity(entity.m_20193_(), livingEntity);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"handleParticleEvent"}, cancellable=true)
    public void handleParticleEvent(ClientboundLevelParticlesPacket clientboundLevelParticlesPacket, CallbackInfo info) {
        PacketUtils.m_131363_((Packet)clientboundLevelParticlesPacket, (PacketListener)((ClientPacketListener)this), (BlockableEventLoop)Minecraft.m_91087_());
        try {
            ParticleOptions particleOptions;
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            if (ConfigClient.serverBlockPhysicsParticles && (particleOptions = clientboundLevelParticlesPacket.m_132322_()) instanceof BlockParticleOption) {
                BlockParticleOption blockParticles = (BlockParticleOption)particleOptions;
                if (camera.m_90593_() && camera.m_90583_().m_82531_(clientboundLevelParticlesPacket.m_132314_(), clientboundLevelParticlesPacket.m_132315_(), clientboundLevelParticlesPacket.m_132316_()) < ConfigClient.blockPhysicsRange * ConfigClient.blockPhysicsRange) {
                    BlockState state = blockParticles.m_123642_();
                    if (clientboundLevelParticlesPacket.m_132321_() == 0) {
                        double vx = clientboundLevelParticlesPacket.m_132320_() * clientboundLevelParticlesPacket.m_132317_();
                        double vy = clientboundLevelParticlesPacket.m_132320_() * clientboundLevelParticlesPacket.m_132318_();
                        double vz = clientboundLevelParticlesPacket.m_132320_() * clientboundLevelParticlesPacket.m_132319_();
                        ParticleSpawner.spawnServerBlockPhysicsParticle(state, (Level)this.f_104889_, clientboundLevelParticlesPacket.m_132314_() + (double)(Math.random() * 0.1f) - (double)0.05f, clientboundLevelParticlesPacket.m_132315_() + (double)(Math.random() * 0.1f) - (double)0.05f, clientboundLevelParticlesPacket.m_132316_() + (double)(Math.random() * 0.1f) - (double)0.05f, vx, vy, vz);
                    } else {
                        for (int i = 0; i < java.lang.Math.max(clientboundLevelParticlesPacket.m_132321_() / 3, 1); ++i) {
                            double x = this.f_104898_.m_188583_() * (double)clientboundLevelParticlesPacket.m_132317_() + (double)(Math.random() * 0.1f) - (double)0.05f;
                            double y = this.f_104898_.m_188583_() * (double)clientboundLevelParticlesPacket.m_132318_() + (double)(Math.random() * 0.1f) - (double)0.05f;
                            double z = this.f_104898_.m_188583_() * (double)clientboundLevelParticlesPacket.m_132319_() + (double)(Math.random() * 0.1f) - (double)0.05f;
                            double vx = this.f_104898_.m_188583_() * (double)clientboundLevelParticlesPacket.m_132320_();
                            double vy = this.f_104898_.m_188583_() * (double)clientboundLevelParticlesPacket.m_132320_();
                            double vz = this.f_104898_.m_188583_() * (double)clientboundLevelParticlesPacket.m_132320_();
                            ParticleSpawner.spawnServerBlockPhysicsParticle(state, (Level)this.f_104889_, clientboundLevelParticlesPacket.m_132314_() + x, clientboundLevelParticlesPacket.m_132315_() + y, clientboundLevelParticlesPacket.m_132316_() + z, vx, vy, vz);
                        }
                    }
                    info.cancel();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"handleBlockEntityData"})
    public void handleBlockEntityData(ClientboundBlockEntityDataPacket packet, CallbackInfo info) {
        PacketUtils.m_131363_((Packet)packet, (PacketListener)((ClientPacketListener)this), (BlockableEventLoop)Minecraft.m_91087_());
        BlockPos blockPos = packet.m_131704_();
        PhysicsMod.getInstance((Level)this.f_104889_).blockUpdates.add(blockPos);
    }

    @Inject(at={@At(value="HEAD")}, method={"handleLogin"})
    public void handleLogin(ClientboundLoginPacket packet, CallbackInfo info) {
        boolean changed = false;
        for (ResourceKey entry : packet.f_132365_()) {
            changed |= ConfigClient.addGravityBuoyancyEntry(entry.m_135782_());
        }
        if (changed) {
            ConfigClient.save();
        }
    }
}

