/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.mixins;

import net.diebuddies.config.ConfigClient;
import net.diebuddies.math.Math;
import net.diebuddies.minecraft.ParticleSpawner;
import net.diebuddies.physics.PhysicsMod;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public class MixinClientLevel {
    @Inject(at={@At(value="HEAD")}, method={"addParticle(Lnet/minecraft/core/particles/ParticleOptions;DDDDDD)V"}, cancellable=true)
    private void addParticle(ParticleOptions particleOptions, double x, double y, double z, double vx, double vy, double vz, CallbackInfo info) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        if (ConfigClient.serverBlockPhysicsParticles && particleOptions instanceof BlockParticleOption) {
            BlockParticleOption blockParticle = (BlockParticleOption)particleOptions;
            if (camera.m_90593_() && camera.m_90583_().m_82531_(x, y, z) < ConfigClient.blockPhysicsRange * ConfigClient.blockPhysicsRange) {
                boolean isLeaf;
                BlockState block = blockParticle.m_123642_();
                boolean isBarrier = block.m_60734_() == Blocks.f_50375_;
                boolean bl = isLeaf = block.m_60734_() instanceof LeavesBlock || block.m_204336_(BlockTags.f_13035_);
                if (isBarrier || isLeaf) {
                    return;
                }
                ParticleSpawner.spawnServerBlockPhysicsParticle(blockParticle.m_123642_(), (Level)((ClientLevel)this), x + (double)(Math.random() * 0.1f) - (double)0.05f, y + (double)(Math.random() * 0.1f) - (double)0.05f, z + (double)(Math.random() * 0.1f) - (double)0.05f, vx, vy, vz);
                info.cancel();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addEntity"})
    private void addEntity(int i, Entity entity, CallbackInfo info) {
        if (entity instanceof FallingBlockEntity) {
            FallingBlockEntity fallingBlock = (FallingBlockEntity)entity;
            PhysicsMod mod = PhysicsMod.getInstance((Level)((ClientLevel)this));
            mod.fallingBlocks.add(fallingBlock.m_31978_());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tickEntities"})
    public void tickEntities(CallbackInfo info) {
        PhysicsMod mod = PhysicsMod.getInstance((Level)((ClientLevel)this));
        mod.fallingBlocks.clear();
    }
}

