/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.compat;

import com.mojang.blaze3d.shaders.Uniform;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.diebuddies.mixins.iris.MixinExtendedShaderAccessor;
import net.diebuddies.mixins.iris.MixinHandRendererAccessor;
import net.diebuddies.physics.StarterClient;
import net.diebuddies.util.ShaderType;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.pathways.HandRenderer;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.materialmap.WorldRenderingSettings;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class Iris {
    public static ShaderInstance oceanShader;
    public static ShaderInstance oceanShadowShader;
    public static ShaderInstance liquidShader;
    public static ShaderInstance liquidShadowShader;
    public static boolean renderOceanShadow;
    public static boolean renderLiquidShadow;
    public static boolean compilingLiquidShadowShader;
    public static String oceanError;
    public static String liquidsError;
    public static boolean vertexShaderSupportsOcean;
    public static boolean fragmentShaderSupportsOcean;
    public static boolean geometryShaderSupportsOcean;
    public static ShaderType preprocessOceanStage;
    public static boolean injectIntoEntityOrShadowShader;
    private static Matrix4f tmp1;
    private static Matrix3f tmp2;

    public static short getMaterialID(BlockState block) {
        if (StarterClient.iris) {
            try {
                Object2IntMap idMap = WorldRenderingSettings.INSTANCE.getBlockStateIds();
                if (idMap != null) {
                    return (short)idMap.getOrDefault((Object)block, -1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    public static void enableHandRendering() {
        if (StarterClient.iris) {
            ((MixinHandRendererAccessor)HandRenderer.INSTANCE).setRenderingSolid(true);
        }
    }

    public static void disableHandRendering() {
        if (StarterClient.iris) {
            ((MixinHandRendererAccessor)HandRenderer.INSTANCE).setRenderingSolid(false);
        }
    }

    public static boolean isExtending() {
        if (StarterClient.iris) {
            return IrisApi.getInstance().isShaderPackInUse();
        }
        return false;
    }

    public static boolean isShadowPass() {
        if (StarterClient.iris) {
            return IrisApi.getInstance().isRenderingShadowPass();
        }
        return false;
    }

    public static int getSpecularTextureID() {
        if (StarterClient.iris) {
            WorldRenderingPipeline pipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable();
            return pipeline.getCurrentSpecularTexture();
        }
        return 0;
    }

    public static int getNormalTextureID() {
        if (StarterClient.iris) {
            WorldRenderingPipeline pipeline = net.irisshaders.iris.Iris.getPipelineManager().getPipelineNullable();
            return pipeline.getCurrentNormalTexture();
        }
        return 0;
    }

    public static void setNormalMatrix(ShaderInstance shader, Matrix4f modelViewMatrix) {
        if (shader instanceof MixinExtendedShaderAccessor) {
            MixinExtendedShaderAccessor extended = (MixinExtendedShaderAccessor)shader;
            Uniform mvi = extended.getModelViewInverse();
            Uniform normal = extended.getNormalMatrix();
            if (mvi != null) {
                mvi.m_5679_(modelViewMatrix.invert(tmp1));
                mvi.m_85633_();
            }
            if (normal != null) {
                if (mvi != null) {
                    normal.m_200759_(tmp1.transpose3x3(tmp2));
                } else {
                    normal.m_200759_(modelViewMatrix.normal(tmp2));
                }
                normal.m_85633_();
            }
        }
    }

    public static void setNormalMatrix(ShaderInstance shader, Matrix4f modelViewMatrix, Matrix3f normalMatrix) {
        if (shader instanceof MixinExtendedShaderAccessor) {
            MixinExtendedShaderAccessor extended = (MixinExtendedShaderAccessor)shader;
            Uniform mvi = extended.getModelViewInverse();
            Uniform normal = extended.getNormalMatrix();
            if (mvi != null) {
                mvi.m_5679_(modelViewMatrix.invert(tmp1));
                mvi.m_85633_();
            }
            if (normal != null) {
                normal.m_200759_(normalMatrix);
                normal.m_85633_();
            }
        }
    }

    public static void setNormalMatrixS(ShaderInstance shader, Matrix4f modelViewMatrix, Matrix3f normalMatrix) {
        if (shader instanceof MixinExtendedShaderAccessor) {
            MixinExtendedShaderAccessor extended = (MixinExtendedShaderAccessor)shader;
            Uniform mvi = extended.getModelViewInverse();
            Uniform normal = extended.getNormalMatrix();
            if (mvi != null) {
                mvi.m_5679_(modelViewMatrix.invert(tmp1));
                mvi.m_85633_();
            }
            if (normal != null) {
                System.out.println("upload matrix " + Iris.isShadowPass());
                normal.m_200759_(normalMatrix);
                normal.m_85633_();
            }
        }
    }

    static {
        oceanError = "";
        liquidsError = "";
        tmp1 = new Matrix4f();
        tmp2 = new Matrix3f();
    }
}

