/*
 * Decompiled with CFR 0.152.
 */
package net.diebuddies.bridge;

import net.diebuddies.minecraft.weather.DustParticle;
import net.diebuddies.minecraft.weather.RainParticle;
import net.diebuddies.minecraft.weather.SnowParticle;
import net.diebuddies.minecraft.weather.WeatherEffects;
import net.diebuddies.physics.ocean.ExplosionOceanSplashParticle;
import net.diebuddies.physics.ocean.OceanSplashParticle;
import net.diebuddies.physics.ocean.SmallOceanSplashParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public class WeatherParticlesRegistry {
    public static final ResourceLocation RAIN_RESOURCE = new ResourceLocation("physicsmod", "rain");
    public static final ResourceLocation SNOW_RESOURCE = new ResourceLocation("physicsmod", "snow");
    public static final ResourceLocation DUST_RESOURCE = new ResourceLocation("physicsmod", "dust");
    public static final ResourceLocation SPLASH_RESOURCE = new ResourceLocation("physicsmod", "splash");
    public static final ResourceLocation SPLASH_SMALL_RESOURCE = new ResourceLocation("physicsmod", "splash_small");
    public static final ResourceLocation SPLASH_EXPLOSION_RESOURCE = new ResourceLocation("physicsmod", "splash_explosion");

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register(WeatherParticlesRegistry.class);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)WeatherEffects.PHYSICS_RAIN, sprite -> new RainParticle.Provider(sprite));
        event.registerSpriteSet((ParticleType)WeatherEffects.PHYSICS_SNOW, sprite -> new SnowParticle.Provider(sprite));
        event.registerSpriteSet((ParticleType)WeatherEffects.PHYSICS_DUST, sprite -> new DustParticle.Provider(sprite));
        event.registerSpriteSet((ParticleType)WeatherEffects.PHYSICS_SPLASH, sprite -> new OceanSplashParticle.Provider(sprite));
        event.registerSpriteSet((ParticleType)WeatherEffects.PHYSICS_SPLASH_SMALL, sprite -> new SmallOceanSplashParticle.Provider(sprite));
        event.registerSpriteSet((ParticleType)WeatherEffects.PHYSICS_SPLASH_EXPLOSION, sprite -> new ExplosionOceanSplashParticle.Provider(sprite));
    }

    @SubscribeEvent
    public static void registerSounds(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.SOUND_EVENTS, helper -> {
            helper.register(WeatherEffects.WIND_SOUND_ID, (Object)WeatherEffects.WIND_SOUND_EVENT);
            helper.register(WeatherEffects.SPLASH_SOUND_ID, (Object)WeatherEffects.SPLASH_SOUND_EVENT);
        });
        event.register(ForgeRegistries.Keys.PARTICLE_TYPES, helper -> {
            helper.register(RAIN_RESOURCE, (Object)WeatherEffects.PHYSICS_RAIN);
            helper.register(SNOW_RESOURCE, (Object)WeatherEffects.PHYSICS_SNOW);
            helper.register(DUST_RESOURCE, (Object)WeatherEffects.PHYSICS_DUST);
            helper.register(SPLASH_RESOURCE, (Object)WeatherEffects.PHYSICS_SPLASH);
            helper.register(SPLASH_SMALL_RESOURCE, (Object)WeatherEffects.PHYSICS_SPLASH_SMALL);
            helper.register(SPLASH_EXPLOSION_RESOURCE, (Object)WeatherEffects.PHYSICS_SPLASH_EXPLOSION);
        });
    }
}

