/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.member_canceller;

import com.bawnorton.mixinsquared.adjuster.tools.AdjustableAnnotationNode;
import com.bawnorton.mixinsquared.reflection.FieldReference;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.member_canceller.MixinMemberCanceller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.WeakHashMap;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.throwables.MixinError;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public final class ExtensionMemberCancelApplication
implements IExtension {
    static final ILogger LOGGER = MixinService.getService().getLogger("mixinsquared-member-canceller");
    static final Set<MixinMemberCanceller> CANCELLERS = new HashSet<MixinMemberCanceller>();
    private final Set<ClassNode> preparedMixins = Collections.newSetFromMap(new WeakHashMap());
    private final FieldReference<Object> field_MixinInfo$state;
    private final FieldReference<ClassNode> field_MixinInfo$State$classNode;
    private final FieldReference<SortedSet<IMixinInfo>> field_TargetClassContext$mixins;

    public ExtensionMemberCancelApplication() {
        try {
            Class<?> infoClass = Class.forName("org.spongepowered.asm.mixin.transformer.MixinInfo");
            this.field_MixinInfo$state = new FieldReference(infoClass, "state");
            Class<?> stateClass = Class.forName("org.spongepowered.asm.mixin.transformer.MixinInfo$State");
            this.field_MixinInfo$State$classNode = new FieldReference(stateClass, "classNode");
            Class<?> contextClass = Class.forName("org.spongepowered.asm.mixin.transformer.TargetClassContext");
            this.field_TargetClassContext$mixins = new FieldReference(contextClass, "mixins");
        }
        catch (ClassNotFoundException e) {
            throw new MixinError((Throwable)e);
        }
    }

    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    public void preApply(ITargetClassContext context) {
        if (CANCELLERS.isEmpty()) {
            return;
        }
        SortedSet mixins = (SortedSet)this.field_TargetClassContext$mixins.get((Object)context);
        for (IMixinInfo mixin : mixins) {
            Object s2;
            ClassNode cNode = (ClassNode)this.field_MixinInfo$State$classNode.get(this.field_MixinInfo$state.get((Object)mixin));
            if (this.preparedMixins.contains(cNode)) continue;
            String mixinClassName = mixin.getClassName();
            List l = mixin.getTargetClasses();
            ArrayList<String> targetClassNames = new ArrayList<String>(l.size());
            for (Object s2 : l) {
                String string = ((String)s2).replaceAll("/", ".");
                targetClassNames.add(string);
            }
            ArrayList<MixinMemberCanceller> cancellers = null;
            s2 = CANCELLERS.iterator();
            while (s2.hasNext()) {
                MixinMemberCanceller canceller = (MixinMemberCanceller)s2.next();
                if (!canceller.preCancel(targetClassNames, mixinClassName)) continue;
                if (cancellers == null) {
                    cancellers = new ArrayList<MixinMemberCanceller>(2);
                }
                cancellers.add(canceller);
            }
            if (cancellers != null) {
                List fields;
                List methods = cNode.methods;
                if (methods != null && !methods.isEmpty()) {
                    this.cancelMethod(targetClassNames, mixinClassName, cancellers, methods);
                }
                if ((fields = cNode.fields) != null && !fields.isEmpty()) {
                    this.cancelField(targetClassNames, mixinClassName, cancellers, fields, cNode);
                }
            }
            this.preparedMixins.add(cNode);
        }
    }

    private void cancelMethod(List<String> targetClassNames, String mixinClassName, List<MixinMemberCanceller> cancellers, List<MethodNode> methods) {
        Iterator<MethodNode> iterator = methods.iterator();
        block0: while (iterator.hasNext()) {
            ArrayList<String> targetMethodDescs;
            MethodNode mNode;
            block5: {
                mNode = iterator.next();
                if (mNode.visibleAnnotations == null || mNode.visibleAnnotations.isEmpty()) {
                    targetMethodDescs = new ArrayList<String>();
                } else {
                    for (AnnotationNode aNode : mNode.visibleAnnotations) {
                        AdjustableAnnotationNode aaNode = AdjustableAnnotationNode.fromNode((AnnotationNode)aNode);
                        Optional opt = aaNode.get("method");
                        if (opt.isEmpty()) continue;
                        List methodValue = (List)opt.get();
                        targetMethodDescs = new ArrayList(methodValue);
                        break block5;
                    }
                    targetMethodDescs = new ArrayList();
                }
            }
            for (MixinMemberCanceller canceller : cancellers) {
                boolean b = canceller.shouldCancelMethod(targetClassNames, mixinClassName, targetMethodDescs, mNode.name, mNode.desc);
                if (!b) continue;
                iterator.remove();
                LOGGER.warn("Cancelled mixin method {};{};{} by {}", new Object[]{mixinClassName, mNode.name, mNode.desc, canceller.getClass().getName()});
                continue block0;
            }
        }
    }

    private void cancelField(List<String> targetClassNames, String mixinClassName, List<MixinMemberCanceller> cancellers, List<FieldNode> fields, ClassNode classNode) {
        Iterator<FieldNode> iterator = fields.iterator();
        HashSet<String> removed = null;
        block0: while (iterator.hasNext()) {
            FieldNode field = iterator.next();
            if (Annotations.getVisible((FieldNode)field, Shadow.class) != null) continue;
            for (MixinMemberCanceller canceller : cancellers) {
                boolean b = canceller.shouldCancelField(targetClassNames, mixinClassName, field.name, field.desc);
                if (!b) continue;
                iterator.remove();
                if (removed == null) {
                    removed = new HashSet<String>();
                }
                removed.add(field.name);
                LOGGER.warn("Cancelled mixin field {};{};{} by {}", new Object[]{mixinClassName, field.name, field.desc, canceller.getClass().getName()});
                continue block0;
            }
        }
        if (removed == null) {
            return;
        }
        for (MethodNode mNode : classNode.methods) {
            if (!"<clinit>".equals(mNode.name) && !"<init>".equals(mNode.name)) continue;
            ListIterator iterator1 = mNode.instructions.iterator();
            while (iterator1.hasNext()) {
                AbstractInsnNode iNode = (AbstractInsnNode)iterator1.next();
                if (!(iNode instanceof FieldInsnNode)) continue;
                FieldInsnNode fieldInsnNode = (FieldInsnNode)iNode;
                if (!removed.contains(fieldInsnNode.name)) continue;
                while (iterator1.hasPrevious() && !(iterator1.previous() instanceof LineNumberNode)) {
                    iterator1.remove();
                }
                iterator1.next();
                while (iterator1.hasNext() && !(iterator1.next() instanceof LineNumberNode)) {
                    iterator1.remove();
                }
            }
        }
    }

    public void postApply(ITargetClassContext context) {
    }

    public void export(MixinEnvironment env, String name, boolean force, ClassNode classNode) {
    }
}

