/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.coremod;

import com.bawnorton.mixinsquared.api.MixinCanceller;
import com.bawnorton.mixinsquared.canceller.MixinCancellerRegistrar;
import com.bawnorton.mixinsquared.ext.ExtensionRegistrar;
import forge.fun.qu_an.minecraft.asyncparticles.client.AsyncParticlesClient;
import forge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.adjusters.AdjusterParticlesLockProvider;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.adjusters.AdjusterParticlesLockRequired;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.adjusters.AdjusterParticlesNoCulling;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.adjusters.AdjusterParticlesNoLightCache;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.cancellers.AsyncParticlesMixinCanceller;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.cancellers.AsyncParticlesMixinMemberCanceller;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.member_canceller.ExtensionMemberCancelApplication;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.member_canceller.MixinMemberCancellerRegistrar;
import forge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.target_modifier.MixinClassAdjusterRegistrar;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.service.MixinService;

public class AsyncParticlesMixinPlugin
implements IMixinConfigPlugin {
    static final ILogger LOGGER = MixinService.getService().getLogger("asyncparticles:plugin");
    private static final int PACKAGE_LENGTH = AsyncParticlesClient.class.getPackage().getName().length() + ".mixin.".length();

    public void onLoad(String mixinPackage) {
        if (!ModListHelper.IS_CLIENT) {
            return;
        }
        ExtensionRegistrar.register((IExtension)new ExtensionMemberCancelApplication());
        MixinClassAdjusterRegistrar.register(new AdjusterParticlesNoCulling());
        MixinClassAdjusterRegistrar.register(new AdjusterParticlesNoLightCache());
        MixinClassAdjusterRegistrar.register(new AdjusterParticlesLockProvider());
        MixinClassAdjusterRegistrar.register(new AdjusterParticlesLockRequired());
        MixinMemberCancellerRegistrar.register(new AsyncParticlesMixinMemberCanceller());
        MixinCancellerRegistrar.register((MixinCanceller)new AsyncParticlesMixinCanceller());
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!ModListHelper.IS_CLIENT) {
            return false;
        }
        String mixinPackageName = mixinClassName.substring(PACKAGE_LENGTH);
        String[] split = mixinPackageName.split("\\.");
        if (split.length == 1) {
            return true;
        }
        return switch (split[0]) {
            case "fabric" -> {
                if (split.length == 2) {
                    if (!ModListHelper.IS_FORGE) {
                        yield true;
                    }
                    yield false;
                }
                switch (split[1]) {
                    case "particlerain_vs": {
                        if (ModListHelper.FABRIC_PARTICLERAIN_LOADED && ModListHelper.VS_LOADED) {
                            yield true;
                        }
                        yield false;
                    }
                    case "particlerain_create": {
                        if (ModListHelper.FABRIC_PARTICLERAIN_LOADED && ModListHelper.CREATE_LOADED) {
                            yield true;
                        }
                        yield false;
                    }
                    case "particlerain": {
                        yield ModListHelper.FABRIC_PARTICLERAIN_LOADED;
                    }
                    case "create_5": {
                        if (ModListHelper.FABRIC_CREATE_LOADED && ModListHelper.IS_LEGACY_CREATE) {
                            yield true;
                        }
                        yield false;
                    }
                    case "create_6": {
                        if (ModListHelper.FABRIC_CREATE_LOADED && !ModListHelper.IS_LEGACY_CREATE) {
                            yield true;
                        }
                        yield false;
                    }
                    case "sodium": {
                        yield ModListHelper.FABRIC_SODIUM_LOADED;
                    }
                    case "effective": {
                        yield ModListHelper.FABRIC_EFFECTIVE_LOADED;
                    }
                    case "effectual": {
                        yield ModListHelper.FABRIC_EFFECTUAL_LOADED;
                    }
                    case "particular": {
                        yield ModListHelper.FABRIC_PARTICULAR_LOADED;
                    }
                    case "vulkanmod": {
                        yield ModListHelper.FABRIC_VULKAN_MOD_LOADED;
                    }
                    case "iris": {
                        yield ModListHelper.FABRIC_IRIS_LOADED;
                    }
                    case "iris_else": {
                        if (!ModListHelper.IS_FORGE && !ModListHelper.FABRIC_IRIS_LOADED) {
                            yield true;
                        }
                        yield false;
                    }
                    case "porting_lib_base": {
                        yield ModListHelper.FABRIC_PORTING_LIB_BASE_LOADED;
                    }
                    case "loot_beams_up": {
                        yield ModListHelper.FABRIC_LOOT_BEAMS_UP_LOADED;
                    }
                }
                throw new IllegalArgumentException("Unknown fabric mixin: " + mixinClassName);
            }
            case "legacy" -> {
                if (split.length == 2) {
                    throw new IllegalArgumentException("Unknown legacy mixin: " + mixinClassName);
                }
                switch (split[1]) {
                    case "flywheel": {
                        if (ModListHelper.FLYWHEEL_LOADED && ModListHelper.versionCheck("flywheel", "0.6", "1.0")) {
                            yield true;
                        }
                        yield false;
                    }
                }
                throw new IllegalArgumentException("Unknown legacy mod mixin: " + mixinClassName);
            }
            case "fake_renders", "off_thread_access", "tick", "render" -> true;
            case "modernui" -> ModListHelper.MODERN_UI_LOADED;
            case "vs2" -> ModListHelper.VS_LOADED;
            case "vs2_create" -> {
                if (ModListHelper.VS_LOADED && ModListHelper.CREATE_LOADED) {
                    yield true;
                }
                yield false;
            }
            case "create" -> ModListHelper.CREATE_LOADED;
            case "iris_like" -> ModListHelper.IRIS_LIKE_LOADED;
            case "flywheel" -> {
                if (ModListHelper.FLYWHEEL_LOADED && ModListHelper.versionCheck("flywheel", "1.0", "2.0")) {
                    yield true;
                }
                yield false;
            }
            case "particle_core" -> ModListHelper.PARTICLE_CORE_LOADED;
            case "physicsmod" -> ModListHelper.PHYSICSMOD_LOADED;
            case "physicsmod_create" -> {
                if (ModListHelper.PHYSICSMOD_LOADED && ModListHelper.CREATE_LOADED) {
                    yield true;
                }
                yield false;
            }
            case "physicsmod_vs" -> {
                if (ModListHelper.PHYSICSMOD_LOADED && ModListHelper.VS_LOADED) {
                    yield true;
                }
                yield false;
            }
            case "a_good_place" -> ModListHelper.A_GOOD_PLACE_LOADED;
            case "subtle_effects" -> {
                if (split.length == 2) {
                    yield ModListHelper.SUBTLE_EFFECTS_LOADED;
                }
                switch (split[1]) {
                    case "fabric": {
                        if (!ModListHelper.IS_FORGE && ModListHelper.FABRIC_SUBTLE_EFFECTS_LOADED) {
                            yield true;
                        }
                        yield false;
                    }
                }
                yield ModListHelper.SUBTLE_EFFECTS_LOADED;
            }
            case "watut" -> ModListHelper.WATUT_LOADED;
            case "lodestone" -> ModListHelper.LODESTONE_LOADED;
            case "fabric_api" -> ModListHelper.FABRIC_API_LOADED;
            case "cloth_config" -> ModListHelper.CLOTH_CONFIG_LOADED;
            case "photon_editor" -> ModListHelper.PHOTON_EDITOR_LOADED;
            case "shimmer" -> ModListHelper.SHIMMER_LOADED;
            default -> throw new IllegalArgumentException("Unknown mixin: " + mixinClassName);
        };
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

