/*
 * Decompiled with CFR 0.152.
 */
package forge.fun.qu_an.minecraft.asyncparticles.client.compat.forge;

import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.Restriction;

public class ModListHelperImpl {
    public static boolean isForge() {
        return true;
    }

    public static boolean isModLoaded(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId) != null;
    }

    public static boolean isDevelopmentEnvironment() {
        return !FMLLoader.isProduction();
    }

    public static boolean isClient() {
        return FMLLoader.getDist().isClient();
    }

    public static boolean versionCheck(String modId, String minInclusive, String maxExclusive) {
        DefaultArtifactVersion max;
        DefaultArtifactVersion min;
        String version;
        ModFileInfo info = LoadingModList.get().getModFileById(modId);
        String string = version = info == null || info.getMods().isEmpty() ? null : info.versionString();
        if (version == null) {
            throw new IllegalArgumentException("Mod " + modId + " is not loaded.");
        }
        DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(version);
        try {
            min = minInclusive == null ? null : new DefaultArtifactVersion(minInclusive);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid version minInclusive", e);
        }
        try {
            max = maxExclusive == null ? null : new DefaultArtifactVersion(maxExclusive);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid version maxExclusive", e);
        }
        if (min != null && max != null && min.compareTo((Object)max) >= 0) {
            throw new IllegalArgumentException("Invalid version range: minInclusive > maxExclusive");
        }
        return new Restriction((ArtifactVersion)min, true, (ArtifactVersion)max, false).containsVersion((ArtifactVersion)currentVersion);
    }

    public static String versionToString(String modId) {
        ModFileInfo info = LoadingModList.get().getModFileById(modId);
        if (info == null || info.getMods().isEmpty()) {
            throw new IllegalArgumentException("Mod " + modId + " is not loaded.");
        }
        return info.versionString();
    }
}

