/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.coremod;

import fabric.fun.qu_an.minecraft.asyncparticles.client.coremod.AsyncParticlesMixinConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.jetbrains.annotations.Contract;
import org.spongepowered.asm.mixin.throwables.MixinError;

public class AsyncParticlesMixinConfig {
    public static final Path MIXIN_CONFIG_FILE = Path.of("config", "asyncparticles", "asyncparticles-mixin.properties");
    public static final int VERSION = 1;
    static String COMMENTS = "particle$noCulling: comma-separated list of particle classes that should not be culled.\nparticle$noLightCache: comma-separated list of particle classes that should not use the light cache.\nparticle$lockRequired: comma-separated list of particle classes that require a spin lock.\nparticle$lockProvider: comma-separated list of particle classes that provide a spin lock.";
    static final Mixin.Particle CONFIG;
    private static Mixin.Particle toSaveConfig;

    static void load() throws IOException {
        if (!Files.exists(MIXIN_CONFIG_FILE, new LinkOption[0])) {
            Files.createDirectories(MIXIN_CONFIG_FILE.getParent(), new FileAttribute[0]);
            Files.createFile(MIXIN_CONFIG_FILE, new FileAttribute[0]);
            AsyncParticlesMixinConfig.reset();
            return;
        }
        Properties properties = new Properties();
        try (InputStream is = Files.newInputStream(MIXIN_CONFIG_FILE, new OpenOption[0]);){
            properties.load(is);
        }
        Mixin.Particle configObj = new Mixin.Particle();
        configObj.read(properties);
        toSaveConfig = configObj = AsyncParticlesMixinConfig.upgrade(configObj.version, configObj);
        AsyncParticlesMixinConfig.save(configObj);
    }

    @Contract
    private static Mixin.Particle upgrade(int ver, Mixin.Particle configObj) {
        return switch (ver) {
            case 1 -> configObj;
            default -> new Mixin.Particle();
        };
    }

    static void save() throws IOException {
        Mixin.Particle configObj = new Mixin.Particle();
        configObj.fold();
        AsyncParticlesMixinConfig.save(configObj);
    }

    static void reset() throws IOException {
        Mixin.Particle configObj = new Mixin.Particle();
        configObj.flat();
        AsyncParticlesMixinConfig.save(configObj);
    }

    private static void save(Mixin.Particle configObj) throws IOException {
        configObj.version = 1;
        Properties properties = new Properties();
        configObj.write(properties);
        try (OutputStream os = Files.newOutputStream(MIXIN_CONFIG_FILE, new OpenOption[0]);){
            properties.store(os, COMMENTS);
        }
    }

    static void setAndSave(Mixin.Particle newConfig) throws IOException {
        toSaveConfig = newConfig;
        AsyncParticlesMixinConfig.save(newConfig);
    }

    static Mixin.Particle getToSaveConfig() {
        return toSaveConfig;
    }

    static {
        try {
            AsyncParticlesMixinConfig.load();
        }
        catch (IOException e) {
            throw new MixinError((Throwable)e);
        }
        CONFIG = toSaveConfig;
    }
}

