/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.world.portal;

import com.eeeab.eeeabsmobs.sever.init.BlockInit;
import com.eeeab.eeeabsmobs.sever.world.portal.EMTeleporter;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CuboidPortalShape {
    private static final int MIN_WIDTH = 2;
    public static final int MAX_WIDTH = 21;
    private static final int MIN_HEIGHT = 3;
    public static final int MAX_HEIGHT = 21;
    private static final BlockBehaviour.StatePredicate FRAME = (blockState, getter, blockPos) -> blockState.m_60734_() == BlockInit.EROSION_DEEPSLATE_BRICKS.get();
    private static final float SAFE_TRAVEL_MAX_ENTITY_XY = 4.0f;
    private static final double SAFE_TRAVEL_MAX_VERTICAL_DELTA = 1.0;
    private final LevelAccessor level;
    private final Direction.Axis axis;
    private final Direction rightDir;
    private int numPortalBlocks;
    @Nullable
    private BlockPos bottomLeft;
    private int height;
    private final int width;

    public static Optional<CuboidPortalShape> findEmptyPortalShape(LevelAccessor levelAccessor, BlockPos blockPos, Direction.Axis axis) {
        return CuboidPortalShape.findPortalShape(levelAccessor, blockPos, cuboidPortalShape -> cuboidPortalShape.isValid() && cuboidPortalShape.numPortalBlocks == 0, axis);
    }

    public static Optional<CuboidPortalShape> findPortalShape(LevelAccessor levelAccessor, BlockPos blockPos, Predicate<CuboidPortalShape> predicate, Direction.Axis axis) {
        Optional<CuboidPortalShape> optional = Optional.of(new CuboidPortalShape(levelAccessor, blockPos, axis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        Direction.Axis direction$axis = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        return Optional.of(new CuboidPortalShape(levelAccessor, blockPos, direction$axis)).filter(predicate);
    }

    public CuboidPortalShape(LevelAccessor levelAccessor, BlockPos blockPos, Direction.Axis axis) {
        this.level = levelAccessor;
        this.axis = axis;
        this.rightDir = axis == Direction.Axis.X ? Direction.WEST : Direction.SOUTH;
        this.bottomLeft = this.calculateBottomLeft(blockPos);
        if (this.bottomLeft == null) {
            this.bottomLeft = blockPos;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.calculateWidth();
            if (this.width > 0) {
                this.height = this.calculateHeight();
            }
        }
    }

    @Nullable
    private BlockPos calculateBottomLeft(BlockPos blockPos) {
        int i = Math.max(this.level.m_141937_(), blockPos.m_123342_() - 21);
        while (blockPos.m_123342_() > i && CuboidPortalShape.isEmpty(this.level.m_8055_(blockPos.m_7495_()))) {
            blockPos = blockPos.m_7495_();
        }
        Direction direction = this.rightDir.m_122424_();
        int j = this.getDistanceUntilEdgeAboveFrame(blockPos, direction) - 1;
        return j < 0 ? null : blockPos.m_5484_(direction, j);
    }

    private int calculateWidth() {
        int i = this.getDistanceUntilEdgeAboveFrame(this.bottomLeft, this.rightDir);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int getDistanceUntilEdgeAboveFrame(BlockPos blockPos, Direction direction) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= 21; ++i) {
            blockpos$mutableblockpos.m_122190_((Vec3i)blockPos).m_122175_(direction, i);
            BlockState blockstate = this.level.m_8055_((BlockPos)blockpos$mutableblockpos);
            if (!CuboidPortalShape.isEmpty(blockstate)) {
                if (!FRAME.m_61035_(blockstate, (BlockGetter)this.level, (BlockPos)blockpos$mutableblockpos)) break;
                return i;
            }
            BlockState blockstate1 = this.level.m_8055_((BlockPos)blockpos$mutableblockpos.m_122173_(Direction.DOWN));
            if (!FRAME.m_61035_(blockstate1, (BlockGetter)this.level, (BlockPos)blockpos$mutableblockpos)) break;
        }
        return 0;
    }

    private int calculateHeight() {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        int i = this.getDistanceUntilTop(blockpos$mutableblockpos);
        return i >= 3 && i <= 21 && this.hasTopFrame(blockpos$mutableblockpos, i) ? i : 0;
    }

    private boolean hasTopFrame(BlockPos.MutableBlockPos p_77731_, int p_77732_) {
        for (int i = 0; i < this.width; ++i) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = p_77731_.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, p_77732_).m_122175_(this.rightDir, i);
            if (FRAME.m_61035_(this.level.m_8055_((BlockPos)blockpos$mutableblockpos), (BlockGetter)this.level, (BlockPos)blockpos$mutableblockpos)) continue;
            return false;
        }
        return true;
    }

    private int getDistanceUntilTop(BlockPos.MutableBlockPos mutableBlockPos) {
        for (int i = 0; i < 21; ++i) {
            mutableBlockPos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, -1);
            if (!FRAME.m_61035_(this.level.m_8055_((BlockPos)mutableBlockPos), (BlockGetter)this.level, (BlockPos)mutableBlockPos)) {
                return i;
            }
            mutableBlockPos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, this.width);
            if (!FRAME.m_61035_(this.level.m_8055_((BlockPos)mutableBlockPos), (BlockGetter)this.level, (BlockPos)mutableBlockPos)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                mutableBlockPos.m_122190_((Vec3i)this.bottomLeft).m_122175_(Direction.UP, i).m_122175_(this.rightDir, j);
                BlockState blockstate = this.level.m_8055_((BlockPos)mutableBlockPos);
                if (!CuboidPortalShape.isEmpty(blockstate)) {
                    return i;
                }
                if (blockstate.m_60734_() != BlockInit.EROSION_PORTAL.get()) continue;
                ++this.numPortalBlocks;
            }
        }
        return 21;
    }

    private static boolean isEmpty(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_60734_() == BlockInit.EROSION_PORTAL.get();
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortalBlocks() {
        BlockState blockstate = (BlockState)((Block)BlockInit.EROSION_PORTAL.get()).m_49966_().m_61124_((Property)NetherPortalBlock.f_54904_, (Comparable)this.axis);
        BlockPos.m_121940_((BlockPos)this.bottomLeft, (BlockPos)this.bottomLeft.m_5484_(Direction.UP, this.height - 1).m_5484_(this.rightDir, this.width - 1)).forEach(p_77725_ -> {
            this.level.m_7731_(p_77725_, blockstate, 18);
            if (this.level instanceof ServerLevel) {
                ((ServerLevel)this.level).m_8904_().m_217919_(p_77725_, EMTeleporter.poi);
            }
        });
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }

    public static Vec3 getRelativePosition(BlockUtil.FoundRectangle rectangle, Direction.Axis axis, Vec3 vec3, EntityDimensions dimensions) {
        double d4;
        double d2;
        double d0 = (double)rectangle.f_124349_ - (double)dimensions.f_20377_;
        double d1 = (double)rectangle.f_124350_ - (double)dimensions.f_20378_;
        BlockPos blockpos = rectangle.f_124348_;
        if (d0 > 0.0) {
            float f = (float)blockpos.m_123304_(axis) + dimensions.f_20377_ / 2.0f;
            d2 = Mth.m_14008_((double)Mth.m_14112_((double)(vec3.m_82507_(axis) - (double)f), (double)0.0, (double)d0), (double)0.0, (double)1.0);
        } else {
            d2 = 0.5;
        }
        if (d1 > 0.0) {
            Direction.Axis direction$axis = Direction.Axis.Y;
            d4 = Mth.m_14008_((double)Mth.m_14112_((double)(vec3.m_82507_(direction$axis) - (double)blockpos.m_123304_(direction$axis)), (double)0.0, (double)d1), (double)0.0, (double)1.0);
        } else {
            d4 = 0.0;
        }
        Direction.Axis direction$axis1 = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        double d3 = vec3.m_82507_(direction$axis1) - ((double)blockpos.m_123304_(direction$axis1) + 0.5);
        return new Vec3(d2, d4, d3);
    }

    public static PortalInfo createPortalInfo(ServerLevel level, BlockUtil.FoundRectangle rectangle, Direction.Axis axis, Vec3 pos1, Entity entity, Vec3 pos2, float yRot, float xRot) {
        BlockPos blockpos = rectangle.f_124348_;
        BlockState blockstate = level.m_8055_(blockpos);
        Direction.Axis direction$axis = blockstate.m_61145_((Property)BlockStateProperties.f_61364_).orElse(Direction.Axis.X);
        double d0 = rectangle.f_124349_;
        double d1 = rectangle.f_124350_;
        EntityDimensions entitydimensions = entity.m_6972_(entity.m_20089_());
        int i = axis == direction$axis ? 0 : 90;
        Vec3 vec3 = axis == direction$axis ? pos2 : new Vec3(pos2.f_82481_, pos2.f_82480_, -pos2.f_82479_);
        double d2 = (double)entitydimensions.f_20377_ / 2.0 + (d0 - (double)entitydimensions.f_20377_) * pos1.m_7096_();
        double d3 = (d1 - (double)entitydimensions.f_20378_) * pos1.m_7098_();
        double d4 = 0.5 + pos1.m_7094_();
        boolean flag = direction$axis == Direction.Axis.X;
        Vec3 vec31 = new Vec3((double)blockpos.m_123341_() + (flag ? d2 : d4), (double)blockpos.m_123342_() + d3, (double)blockpos.m_123343_() + (flag ? d4 : d2));
        Vec3 vec32 = CuboidPortalShape.findCollisionFreePosition(vec31, level, entity, entitydimensions);
        return new PortalInfo(vec32, vec3, yRot + (float)i, xRot);
    }

    private static Vec3 findCollisionFreePosition(Vec3 pos, ServerLevel level, Entity entity, EntityDimensions dimensions) {
        if (!(dimensions.f_20377_ > 4.0f) && !(dimensions.f_20378_ > 4.0f)) {
            double d0 = (double)dimensions.f_20378_ / 2.0;
            Vec3 vec3 = pos.m_82520_(0.0, d0, 0.0);
            VoxelShape voxelshape = Shapes.m_83064_((AABB)AABB.m_165882_((Vec3)vec3, (double)dimensions.f_20377_, (double)0.0, (double)dimensions.f_20377_).m_82363_(0.0, 1.0, 0.0).m_82400_(1.0E-6));
            Optional optional = level.m_151418_(entity, voxelshape, vec3, (double)dimensions.f_20377_, (double)dimensions.f_20378_, (double)dimensions.f_20377_);
            Optional<Vec3> optional1 = optional.map(p_259019_ -> p_259019_.m_82492_(0.0, d0, 0.0));
            return optional1.orElse(pos);
        }
        return pos;
    }
}

