/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class EMTUtils {
    public static final Style STYLE_GRAY = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY));
    public static final Style STYLE_GREEN = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
    public static final Style STYLE_RED = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED));
    public static final String TIP_SUFFIX = ".tip";
    public static final String OTHER_PREFIX = "other.";
    public static final String MOD_ID = "eeeabsmobs.";
    public static final Component UNABLE_BREAKS = EMTUtils.simpleText("other.", "unable_breaks", STYLE_GRAY);
    public static final String ITEM_PREFIX = "item.";
    public static final String TOOLTIP_PREFIX = "tooltip.";
    public static final String ARMOR_PREFIX = "tooltip.armor.";
    public static final String WEAPON_PREFIX = "tooltip.weapon.";
    public static final String TOOLTIP_OTHER_PREFIX = "tooltip.other.";
    public static final String KEY_PREFIX = "keyboard.";
    public static final String SHIFT_DOWN = "keyboard.shift_down.";
    public static final String RIGHT_CLICK = "keyboard.right_click.";
    public static final String LEFT_CLICK = "keyboard.left_click.";
    public static final String STRUCTURE_PREFIX = "structure.";

    private EMTUtils() {
    }

    public static Component simpleText(String prefix, String key, Style style) {
        MutableComponent component;
        String finalPrefix = prefix + MOD_ID;
        if (style == null) {
            style = Style.f_131099_;
        }
        if (key == null) {
            component = Component.m_237115_((String)(finalPrefix + TIP_SUFFIX.substring(1))).m_6270_(style);
        } else {
            key = EMTUtils.subDescriptionId(key);
            component = Component.m_237115_((String)(finalPrefix + key + TIP_SUFFIX)).m_6270_(style);
        }
        return component;
    }

    public static Component simpleItemText(String key, Style style) {
        return EMTUtils.simpleText(ITEM_PREFIX, key, style);
    }

    public static Component simpleArmorText(String key, Style style) {
        return EMTUtils.simpleText(ARMOR_PREFIX, key, style);
    }

    public static Component simpleWeaponText(String key, Style style) {
        return EMTUtils.simpleText(WEAPON_PREFIX, key, style);
    }

    public static Component simpleOtherText(String key, Style style) {
        return EMTUtils.simpleText(TOOLTIP_OTHER_PREFIX, key, style);
    }

    public static Component simpleShiftDownText(String key, Style style) {
        return EMTUtils.simpleText(SHIFT_DOWN, key, style);
    }

    public static Component simpleRightClickText(String key, Style style) {
        return EMTUtils.simpleText(RIGHT_CLICK, key, style);
    }

    public static Component simpleLeftClickText(String key, Style style) {
        return EMTUtils.simpleText(LEFT_CLICK, key, style);
    }

    public static List<Component> complexText(String prefix, int count, Style style, String key) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (style == null) {
            style = Style.f_131099_;
        }
        for (int i = 1; i <= count; ++i) {
            StringBuilder sb = new StringBuilder();
            components.add((Component)Component.m_237115_((String)sb.append(prefix).append(MOD_ID).append(EMTUtils.subDescriptionId(key)).append(TIP_SUFFIX).append("_").append(i).toString()).m_6270_(style));
        }
        return components;
    }

    public static List<Component> complexText(String prefix, boolean hasIndex, Style style, String ... keys) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (style == null) {
            style = Style.f_131099_;
        }
        for (int i = 0; i < keys.length; ++i) {
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(MOD_ID).append(EMTUtils.subDescriptionId(keys[i])).append(TIP_SUFFIX);
            if (hasIndex) {
                sb.append("_").append(i + 1);
            }
            components.add((Component)Component.m_237115_((String)sb.toString()).m_6270_(style));
        }
        return components;
    }

    public static String subDescriptionId(String descriptionId) {
        int i = descriptionId.lastIndexOf(".");
        if (i == -1) {
            return descriptionId;
        }
        return descriptionId.substring(i + 1);
    }
}

