/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.item;

import com.eeeab.eeeabsmobs.sever.ability.Ability;
import com.eeeab.eeeabsmobs.sever.ability.AbilityHandler;
import com.eeeab.eeeabsmobs.sever.block.BlockErosionPortal;
import com.eeeab.eeeabsmobs.sever.capability.AbilityCapability;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.EMTUtils;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemGuardianCore
extends Item {
    public ItemGuardianCore() {
        super(new Item.Properties().m_41497_(Rarity.EPIC).m_41499_(100).m_41486_());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        AbilityCapability.IAbilityCapability capability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
        ItemStack itemStack = player.m_21120_(hand);
        if (capability != null) {
            player.m_6672_(hand);
            if (itemStack.m_41773_() + 1 < itemStack.m_41776_()) {
                if (!level.f_46443_) {
                    AbilityHandler.INSTANCE.sendAbilityMessage(player, AbilityHandler.GUARDIAN_LASER_ABILITY_TYPE);
                }
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                player.m_6672_(hand);
                player.m_5496_((SoundEvent)SoundInit.NAMELESS_GUARDIAN_ACCUMULATING.get(), 1.5f, (player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.2f + 3.5f);
                return InteractionResultHolder.m_19096_((Object)itemStack);
            }
            try {
                Optional.ofNullable(capability.getAbilitiesMap().get(AbilityHandler.GUARDIAN_LASER_ABILITY_TYPE)).orElseThrow().end();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int timeCharged) {
        Player player;
        Ability<?> guardianLaserAbility;
        if (livingEntity instanceof Player && (guardianLaserAbility = AbilityHandler.INSTANCE.getAbility(player = (Player)livingEntity, AbilityHandler.GUARDIAN_LASER_ABILITY_TYPE)) != null && guardianLaserAbility.isUsing()) {
            guardianLaserAbility.end();
        }
        super.m_5551_(stack, level, livingEntity, timeCharged);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player entity = context.m_43723_();
        BlockPos pos = context.m_8083_().m_121945_(context.m_43719_());
        ItemStack itemstack = context.m_43722_();
        Level world = context.m_43725_();
        if (entity == null || !entity.m_36204_(pos, context.m_43719_(), itemstack) || itemstack.m_41773_() != 0) {
            return InteractionResult.FAIL;
        }
        boolean success = false;
        if (world.m_46859_(pos)) {
            BlockErosionPortal.portalSpawn(world, pos);
            success = true;
        }
        return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public boolean m_41465_() {
        return true;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CUSTOM;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, level, tooltip, flagIn);
        tooltip.add(EMTUtils.UNABLE_BREAKS);
        if (!InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
            tooltip.add(EMTUtils.simpleShiftDownText(null, EMTUtils.STYLE_GREEN));
        } else {
            tooltip.addAll(EMTUtils.complexText("item.", 2, EMTUtils.STYLE_GRAY, this.m_5524_()));
        }
    }
}

