/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.handler;

import com.eeeab.eeeabsmobs.EEEABMobs;
import com.eeeab.eeeabsmobs.sever.ability.Ability;
import com.eeeab.eeeabsmobs.sever.ability.AbilityHandler;
import com.eeeab.eeeabsmobs.sever.capability.AbilityCapability;
import com.eeeab.eeeabsmobs.sever.capability.FrenzyCapability;
import com.eeeab.eeeabsmobs.sever.capability.VertigoCapability;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityAbsCorpse;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.namelessguardian.EntityNamelessGuardian;
import com.eeeab.eeeabsmobs.sever.entity.projectile.EntityShamanBomb;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.eeeab.eeeabsmobs.sever.item.util.EMArmorMaterial;
import com.eeeab.eeeabsmobs.sever.item.util.EMArmorUtil;
import com.eeeab.eeeabsmobs.sever.message.MessageFrenzyEffect;
import com.eeeab.eeeabsmobs.sever.message.MessageVertigoEffect;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public final class HandlerServerEvent {
    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("eeeabsmobs", "vertigo_processor"), (ICapabilityProvider)new VertigoCapability.VertigoCapabilityProvider());
            event.addCapability(new ResourceLocation("eeeabsmobs", "frenzy_processor"), (ICapabilityProvider)new FrenzyCapability.FrenzyCapabilityProvider());
        }
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("eeeabsmobs", "ability_processor"), (ICapabilityProvider)new AbilityCapability.AbilityCapabilityProvider());
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinLevelEvent event) {
        Raider raider;
        Zombie zombie;
        AbstractGolem abstractGolem;
        AbilityCapability.IAbilityCapability capability;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (capability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)entity)) != null) {
            capability.onInit((LivingEntity)entity);
        }
        if (event.getLevel().f_46443_) {
            return;
        }
        if (entity instanceof AbstractGolem && !((abstractGolem = (AbstractGolem)entity) instanceof Shulker)) {
            abstractGolem.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)abstractGolem, EntityAbsImmortal.class, 5, false, false, null));
            abstractGolem.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)abstractGolem, EntityAbsCorpse.class, 5, false, false, null));
        }
        if (entity instanceof AbstractSkeleton) {
            AbstractSkeleton abstractSkeleton = (AbstractSkeleton)entity;
            abstractSkeleton.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)abstractSkeleton, EntityAbsImmortal.class, 0, true, false, null));
        }
        if (entity instanceof Zombie && !((zombie = (Zombie)entity) instanceof ZombifiedPiglin)) {
            zombie.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)zombie, EntityAbsImmortal.class, 0, true, false, null));
            zombie.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)zombie, EntityAbsCorpse.class, 0, true, false, null));
        }
        if (entity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity;
            villager.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)villager, EntityAbsImmortal.class, 6.0f, 1.0, 1.2));
            villager.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)villager, EntityAbsCorpse.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof Raider && !((raider = (Raider)entity) instanceof SpellcasterIllager)) {
            raider.f_21345_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)raider, EntityAbsImmortal.class, 5, true, false, null));
        }
    }

    @SubscribeEvent
    public void onLivingEntityTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity() != null) {
            FrenzyCapability.IFrenzyCapability frenzyCapability;
            AbilityCapability.IAbilityCapability abilityCapability;
            LivingEntity entity = event.getEntity();
            VertigoCapability.IVertigoCapability vertigoCapability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
            if (vertigoCapability != null) {
                vertigoCapability.tick(entity);
            }
            if ((abilityCapability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.CUSTOM_ABILITY_CAPABILITY)) != null) {
                abilityCapability.tick(entity);
            }
            if ((frenzyCapability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.FRENZY_CAPABILITY_CAPABILITY)) != null) {
                frenzyCapability.tick(entity);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.player == null) {
            return;
        }
        this.useGuardianCoreStack(event);
    }

    private void useGuardianCoreStack(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Ability<?> ability = AbilityHandler.INSTANCE.getAbility(player, AbilityHandler.GUARDIAN_LASER_ABILITY_TYPE);
        ItemStack itemStack = player.m_21211_();
        if (ability != null) {
            if (!ability.isUsing()) {
                for (ItemStack stack : player.m_150109_().f_35974_) {
                    if (!stack.m_150930_((Item)ItemInit.GUARDIAN_CORE.get())) continue;
                    stack.m_41721_(Math.max(stack.m_41773_() - 1, 0));
                }
                for (ItemStack stack : player.m_150109_().f_35976_) {
                    if (!stack.m_150930_((Item)ItemInit.GUARDIAN_CORE.get())) continue;
                    stack.m_41721_(Math.max(stack.m_41773_() - 1, 0));
                }
            } else if (itemStack.m_150930_((Item)ItemInit.GUARDIAN_CORE.get())) {
                if (itemStack.m_41773_() + 1 < itemStack.m_41776_()) {
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                } else {
                    ability.end();
                }
            }
        }
    }

    @SubscribeEvent
    public void onAddPointEffect(MobEffectEvent.Added event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (!event.getEntity().m_9236_().m_5776_()) {
            this.doCRCapabilityWithEffect(effectInstance, event.getEntity(), true);
        }
    }

    @SubscribeEvent
    public void onRemovePotionEffect(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (!event.getEntity().m_9236_().m_5776_() && effectInstance != null) {
            this.doCRCapabilityWithEffect(effectInstance, event.getEntity(), false);
        }
    }

    @SubscribeEvent
    public void onExpirePotionEffect(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (!event.getEntity().m_9236_().m_5776_() && effectInstance != null) {
            this.doCRCapabilityWithEffect(effectInstance, event.getEntity(), false);
        }
    }

    private void doCRCapabilityWithEffect(MobEffectInstance effectInstance, LivingEntity entity, boolean flag) {
        Object capability;
        if (effectInstance.m_19544_() == EffectInit.VERTIGO_EFFECT.get()) {
            EEEABMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MessageVertigoEffect(entity, flag));
            capability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
            if (capability != null) {
                if (flag) {
                    capability.onStart(entity);
                } else {
                    capability.onEnd(entity);
                }
            }
        }
        if (effectInstance.m_19544_() == EffectInit.FRENZY_EFFECT.get()) {
            EEEABMobs.NETWORK.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity), (Object)new MessageFrenzyEffect(entity, flag));
            capability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.FRENZY_CAPABILITY_CAPABILITY);
            if (capability != null) {
                capability.setLevel(effectInstance.m_19564_());
                if (flag) {
                    capability.onStart(entity);
                } else {
                    capability.onEnd(entity);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        LivingEntity entity;
        if (event.getEntity() != null && (entity = event.getEntity()).m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get()) && entity.m_20096_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.isCancelable() && event.getEntity().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickEmpty event) {
        Player entity = event.getEntity();
        if (event.isCancelable() && entity.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.isCancelable() && event.getPlayer().m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (event.isCancelable() && living.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onUseItem(LivingEntityUseItemEvent event) {
        LivingEntity living = event.getEntity();
        if (event.isCancelable() && living.m_21023_((MobEffect)EffectInit.VERTIGO_EFFECT.get())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingEntityKnockBack(LivingKnockBackEvent event) {
        LivingEntity living = event.getEntity();
        if (event.isCancelable() && living instanceof EntityNamelessGuardian) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingEntityHurt(LivingHurtEvent event) {
        FrenzyCapability.IFrenzyCapability frenzyCapability;
        float damage;
        Entity directEntity = event.getSource().m_7640_();
        Entity attacker = event.getSource().m_7639_();
        LivingEntity hurtEntity = event.getEntity();
        if (directEntity instanceof EntityShamanBomb) {
            EntityShamanBomb shamanBomb = (EntityShamanBomb)directEntity;
            if (shamanBomb.reboundFlag && !shamanBomb.isPlayer()) {
                hurtEntity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.VERTIGO_EFFECT.get(), 100, 0, false, false));
            }
        }
        if (hurtEntity instanceof Player) {
            Player player = (Player)hurtEntity;
            if (attacker instanceof EntityAbsImmortal && EMArmorUtil.checkFullSuitOfArmor(EMArmorMaterial.IMMORTAL_MATERIAL, player)) {
                damage = event.getAmount();
                damage -= damage * 0.1f;
                event.setAmount(damage);
            }
        }
        if ((frenzyCapability = HandlerCapability.getCapability((Entity)hurtEntity, HandlerCapability.FRENZY_CAPABILITY_CAPABILITY)) != null && frenzyCapability.isFrenzy() && !event.getSource().m_269533_(EMTagKey.GENERAL_UNRESISTANT_TO)) {
            damage = event.getAmount();
            damage -= damage * Math.min((float)frenzyCapability.getLevel() + 1.0f, 5.0f) * 0.1f;
            event.setAmount(damage);
        }
    }

    @SubscribeEvent
    public void onLivingEntityChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity entity = event.getEntity();
        VertigoCapability.IVertigoCapability capability = HandlerCapability.getCapability((Entity)entity, HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
        if (capability != null && event.isCancelable() && entity instanceof Mob && capability.isVertigo() && (event.getOriginalTarget() != null || entity.m_6274_().m_21874_(MemoryModuleType.f_26372_))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onCriticalHit(CriticalHitEvent event) {
    }
}

