/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.test;

import com.eeeab.eeeabsmobs.sever.entity.EEEABMobLibrary;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationActivateGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationDeactivateGoal;
import com.eeeab.eeeabsmobs.sever.util.EMTUtils;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EntityTester
extends EEEABMobLibrary
implements IEntity {
    public static final Animation YES = Animation.create((int)5);
    public static final Animation NO = Animation.create((int)5);
    public static final Animation[] ANIMATIONS = new Animation[]{YES, NO};
    private static final EntityDataAccessor<Boolean> ACTIVE = SynchedEntityData.m_135353_(EntityTester.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<Component>> DAMAGE = SynchedEntityData.m_135353_(EntityTester.class, (EntityDataSerializer)EntityDataSerializers.f_135032_);

    public EntityTester(EntityType<? extends EEEABMobLibrary> type, Level level) {
        super(type, level);
        this.active = true;
    }

    @Override
    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_NONE;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 6.0f, true));
        this.f_21345_.m_25352_(8, (Goal)new EMLookAtGoal(this, Mob.class, 8.0f));
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(0, (Goal)new AnimationActivateGoal<EntityTester>(this, YES){

            @Override
            public void m_8056_() {
                super.m_8056_();
                ((EntityTester)this.entity).m_216990_(SoundEvents.f_12509_);
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new AnimationDeactivateGoal<EntityTester>(this, NO){

            @Override
            public void m_8056_() {
                super.m_8056_();
                ((EntityTester)this.entity).m_216990_(SoundEvents.f_12507_);
            }
        });
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22280_, 0.0);
    }

    @Override
    public void m_8119_() {
        if (!this.isActive()) {
            this.m_20334_(0.0, this.m_20096_() ? 0.0 : this.m_20184_().f_82480_, 0.0);
        }
        super.m_8119_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @Override
    public Animation getDeathAnimation() {
        return null;
    }

    @Override
    public Animation getHurtAnimation() {
        return null;
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (!source.m_269533_(DamageTypeTags.f_268738_)) {
            this.setDamage(damage);
            damage = 0.0f;
        }
        return super.m_6469_(source, damage);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12503_;
    }

    public void m_8032_() {
        if (this.isActive()) {
            super.m_8032_();
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12506_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    public boolean m_6052_() {
        return true;
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            this.setDamage(0.0);
            this.m_216990_(SoundEvents.f_11871_);
            player.m_5661_((Component)Component.m_237117_((String)"reset success").m_6270_(EMTUtils.STYLE_GREEN), true);
            return InteractionResult.SUCCESS;
        }
        if (this.getAnimation() == NO_ANIMATION) {
            this.setActive(!this.isActive());
            this.playAnimation(this.isActive() ? NO : YES);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("isActive", this.isActive());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setActive(compound.m_128471_("isActive"));
        this.active = this.isActive();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTIVE, (Object)true);
        this.f_19804_.m_135372_(DAMAGE, Optional.of(Component.m_237117_((String)"0.0")));
    }

    public void setActive(boolean isActive) {
        this.f_19804_.m_135381_(ACTIVE, (Object)isActive);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(ACTIVE);
    }

    public Component getDamage() {
        return (Component)((Optional)this.f_19804_.m_135370_(DAMAGE)).orElse(Component.m_237117_((String)"0.0"));
    }

    public void setDamage(double damage) {
        this.f_19804_.m_135381_(DAMAGE, Optional.of(Component.m_237117_((String)String.format("%.1f", damage))));
    }
}

