/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.immortal;

import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.IBoss;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.base.AnimationCommonGoal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortalSkeleton;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class EntityTheImmortal
extends EntityAbsImmortal
implements IBoss {
    public static final Animation SUMMONER_MOB_ANIMATION = Animation.create((int)40);
    private static final Animation[] ANIMATIONS = new Animation[]{SUMMONER_MOB_ANIMATION};
    private boolean circleDirection;
    private int circleTick;
    private static final EntityDataAccessor<Integer> DATA_MOVING_TYPE = SynchedEntityData.m_135353_(EntityTheImmortal.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityTheImmortal(EntityType<? extends EntityAbsImmortal> type, Level level) {
        super(type, level);
        this.active = true;
        this.circleTick += this.f_19796_.m_188503_(200);
        this.setMovingType(MoveType.CIRCLE);
    }

    @Override
    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_BOSS;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, false, false, null));
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new EMLookAtGoal(this, Mob.class, 8.0f));
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(1, (Goal)new AnimationCommonGoal<EntityTheImmortal>(this, SUMMONER_MOB_ANIMATION){

            public void m_8037_() {
                int tick = ((EntityTheImmortal)this.entity).getAnimationTick();
                LivingEntity target = ((EntityTheImmortal)this.entity).m_5448_();
                RandomSource random = ((EntityTheImmortal)this.entity).f_19796_;
                if (target != null) {
                    ((EntityTheImmortal)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                    if (tick == 20) {
                        double minY = Math.min(target.m_20186_(), ((EntityTheImmortal)this.entity).m_20186_());
                        double maxY = Math.max(target.m_20186_(), ((EntityTheImmortal)this.entity).m_20186_()) + 1.0;
                        for (int i = 0; i < 3; ++i) {
                            Vec3 vec3 = ((EntityTheImmortal)this.entity).m_20182_().m_82549_(new Vec3((double)(random.m_188503_(10) + 2), 0.0, (double)(random.m_188503_(10) + 2)));
                            Vec3 entityPoint = ModEntityUtils.checkSummonEntityPoint((LivingEntity)this.entity, vec3.m_7096_(), vec3.m_7094_(), minY, maxY);
                            this.summonEntity(entityPoint);
                        }
                    }
                }
            }

            private void summonEntity(Vec3 vec3) {
                EntityImmortalSkeleton entity = (EntityImmortalSkeleton)((EntityType)EntityInit.IMMORTAL_SKELETON.get()).m_20615_(((EntityTheImmortal)this.entity).m_9236_());
                if (!((EntityTheImmortal)this.entity).m_9236_().f_46443_ && entity != null && vec3 != null) {
                    entity.setInitSpawn();
                    entity.m_6518_((ServerLevelAccessor)((ServerLevel)((EntityTheImmortal)this.entity).m_9236_()), ((EntityTheImmortal)this.entity).m_9236_().m_6436_(BlockPos.m_274561_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_)), MobSpawnType.MOB_SUMMONED, null, null);
                    entity.setOwner((EntityAbsImmortal)this.entity);
                    entity.setSummonAliveTime(20 * (30 + ((EntityTheImmortal)this.entity).f_19796_.m_188503_(90)));
                    entity.m_146884_(vec3);
                    ((EntityTheImmortal)this.entity).m_9236_().m_7967_((Entity)entity);
                }
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new ImmortalMoveGoal(this, 6.5f));
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.IMMORTAL.THE_IMMORTAL.combatConfig;
    }

    @Override
    protected boolean showBossBloodBars() {
        return (Boolean)EMConfigHandler.COMMON.OTHER.enableShowBloodBars.get();
    }

    @Override
    protected BossEvent.BossBarColor bossBloodBarsColor() {
        return BossEvent.BossBarColor.BLUE;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_MOVING_TYPE, (Object)MoveType.KEEP_DISTANCE.getId());
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public Animation getDeathAnimation() {
        return null;
    }

    @Override
    public Animation getHurtAnimation() {
        return null;
    }

    public MoveType getMoveType() {
        return MoveType.byId((Integer)this.f_19804_.m_135370_(DATA_MOVING_TYPE));
    }

    public void setMovingType(MoveType movingType) {
        this.f_19804_.m_135381_(DATA_MOVING_TYPE, (Object)movingType.getId());
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.setMovingType(MoveType.byId(compound.m_128451_("moveId")));
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        compound.m_128405_("moveId", this.getMoveType().getId());
    }

    private Vec3 updateCirclingPosition(float radius, float speed) {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            if (this.f_19796_.m_188503_(200) == 0) {
                boolean bl = this.circleDirection = !this.circleDirection;
            }
            this.circleTick = this.circleDirection ? ++this.circleTick : --this.circleTick;
            return this.circlePosition(target.m_20182_(), radius, speed, true, this.circleTick, 0.0f);
        }
        return null;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.7).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22280_, 0.5).m_22268_(Attributes.f_22278_, 1.0);
    }

    public static enum MoveType {
        NONE(-1),
        KEEP_DISTANCE(0),
        CIRCLE(1);

        private final int id;

        private MoveType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static MoveType byId(int id) {
            for (MoveType value : MoveType.values()) {
                if (id != value.getId()) continue;
                return value;
            }
            return NONE;
        }
    }

    public static class ImmortalMoveGoal
    extends Goal {
        private final EntityTheImmortal immortal;
        private boolean inside;
        private final float safeRange;
        private int cooling;

        public ImmortalMoveGoal(EntityTheImmortal immortal, float safeRange) {
            this.immortal = immortal;
            this.safeRange = safeRange;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.immortal.m_5448_() != null;
        }

        public boolean m_8045_() {
            return this.m_8036_() || !this.immortal.m_21573_().m_26571_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            this.immortal.m_21566_().m_24988_(0.0f, 0.0f);
        }

        public void m_8037_() {
            LivingEntity target = this.immortal.m_5448_();
            if (target != null) {
                float distanceToTarget = this.immortal.m_20270_((Entity)target);
                if (this.inside && distanceToTarget >= this.safeRange + 2.0f) {
                    this.inside = false;
                }
                if (!this.inside && distanceToTarget <= this.safeRange) {
                    this.inside = true;
                }
                if (this.immortal.getMoveType() == MoveType.CIRCLE) {
                    if (!this.inside) {
                        this.immortal.m_21566_().m_24988_(0.0f, 0.0f);
                        this.immortal.m_21573_().m_5624_((Entity)target, (double)0.6f);
                        this.immortal.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    } else {
                        this.immortal.m_21573_().m_26573_();
                        Vec3 circlingPosition = this.immortal.updateCirclingPosition(this.safeRange, 0.3f);
                        double distanceTo = this.immortal.m_20182_().m_82554_(circlingPosition);
                        if (distanceTo <= 1.5) {
                            int strafingFrontBackMul = (double)distanceToTarget > (double)this.safeRange + 0.5 ? 1 : ((double)distanceToTarget < (double)this.safeRange - 0.5 ? -1 : 0);
                            Vec3 toTarget = target.m_20182_().m_82546_(this.immortal.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_();
                            Vec3 toCirclePos = circlingPosition.m_82546_(this.immortal.m_20182_()).m_82542_(1.0, 0.0, 1.0).m_82541_();
                            Vec3 cross = toTarget.m_82537_(toCirclePos);
                            int strafingLeftRightMul = cross.f_82480_ > 0.0 ? 1 : (cross.f_82480_ < 0.0 ? -1 : 0);
                            float distScale = (float)Math.min(Math.pow(distanceTo * 1.0 / 1.5, 0.7), 1.0);
                            this.immortal.m_21566_().m_24988_((float)strafingFrontBackMul * 0.5f, (float)strafingLeftRightMul * 0.5f * distScale);
                            this.immortal.m_21391_((Entity)target, 30.0f, 30.0f);
                        } else {
                            this.immortal.m_21566_().m_24988_(0.0f, 0.0f);
                            this.immortal.m_21573_().m_26519_(circlingPosition.m_7096_(), circlingPosition.m_7098_(), circlingPosition.m_7094_(), (double)0.53f);
                            this.immortal.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                        }
                    }
                } else if (this.immortal.getMoveType() == MoveType.KEEP_DISTANCE) {
                    this.immortal.m_21573_().m_26573_();
                    this.immortal.m_21566_().m_24988_(0.0f, 0.0f);
                    this.immortal.m_21391_((Entity)target, 30.0f, 30.0f);
                    this.immortal.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    double angle = this.immortal.getAngleBetweenEntities((Entity)this.immortal, (Entity)target);
                    float radian = (float)Math.toRadians(angle + 90.0);
                    float distanceMultiple = 1.5f;
                    if (this.cooling <= 0) {
                        if (!this.inside) {
                            if (distanceToTarget > this.safeRange + 4.0f) {
                                this.keepDistanceMoving(false, distanceMultiple, radian);
                            }
                        } else if (distanceToTarget < this.safeRange / 2.0f) {
                            distanceMultiple = 2.0f;
                            this.keepDistanceMoving(true, distanceMultiple, radian);
                        }
                    }
                }
            }
            if (this.cooling > 0) {
                --this.cooling;
            }
        }

        private void keepDistanceMoving(boolean direction, float distanceMultiple, double radian) {
            int t = direction ? 1 : -1;
            Vec3 movement = this.immortal.m_20184_().m_82520_((double)distanceMultiple * Math.cos(radian), 0.0, (double)distanceMultiple * Math.sin(radian));
            this.immortal.m_20334_(movement.f_82479_ * (double)t, 0.3, movement.f_82481_ * (double)t);
            this.cooling = 40;
        }
    }
}

