/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.immortal;

import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleComponent;
import com.eeeab.eeeabsmobs.client.particle.util.anim.AnimData;
import com.eeeab.eeeabsmobs.client.util.ModParticleUtils;
import com.eeeab.eeeabsmobs.sever.capability.VertigoCapability;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.NeedStopAiEntity;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.KeepDistanceGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationDieGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationFullRangeAttackGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationHurtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.base.AnimationCommonGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.base.AnimationSpellAIGoal;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityCameraShake;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortalGolem;
import com.eeeab.eeeabsmobs.sever.entity.projectile.EntityShamanBomb;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntityImmortalShaman
extends EntityAbsImmortal
implements IEntity,
RangedAttackMob,
NeedStopAiEntity {
    public static final Animation DIE_ANIMATION = Animation.create((int)80);
    public static final Animation HURT_ANIMATION = Animation.create((int)0);
    public static final Animation SPELL_CASTING_FR_ATTACK_ANIMATION = Animation.create((int)30);
    public static final Animation SPELL_CASTING_SUMMON_ANIMATION = Animation.create((int)44);
    public static final Animation SPELL_CASTING_BOMB_ANIMATION = Animation.create((int)30);
    public static final Animation SPELL_CASTING_HEAL_ANIMATION = Animation.create((int)60);
    public static final Animation SPELL_CASTING_WOLOLO_ANIMATION = Animation.create((int)40);
    public static final Animation AVOID_ANIMATION = Animation.create((int)15);
    public static final Animation[] ANIMATIONS = new Animation[]{DIE_ANIMATION, HURT_ANIMATION, SPELL_CASTING_FR_ATTACK_ANIMATION, SPELL_CASTING_SUMMON_ANIMATION, SPELL_CASTING_BOMB_ANIMATION, SPELL_CASTING_HEAL_ANIMATION, SPELL_CASTING_WOLOLO_ANIMATION, AVOID_ANIMATION};
    private final VertigoCapability.IVertigoCapability capability = HandlerCapability.getCapability((Entity)this, HandlerCapability.MOVING_CONTROLLER_CAPABILITY);
    private int hurtCountBeforeHeal = 0;
    private static final int CAN_STOP_HEAL_COUNT = 2;
    private int nextHealTick = 0;
    @Nullable
    private Sheep wololoTarget;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] heartPos;

    public EntityImmortalShaman(EntityType<? extends EntityImmortalShaman> type, Level level) {
        super((EntityType<? extends EntityAbsImmortal>)type, level);
        this.active = true;
        if (this.m_9236_().f_46443_) {
            this.heartPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0)};
        }
    }

    @Override
    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_ELITE;
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.IMMORTAL.IMMORTAL_SHAMAN.combatConfig;
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21345_.m_25352_(8, (Goal)new EMLookAtGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new EMLookAtGoal(this, EntityImmortalGolem.class, 6.0f));
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(1, new AnimationDieGoal<EntityImmortalShaman>(this));
        this.f_21345_.m_25352_(1, new AnimationHurtGoal<EntityImmortalShaman>(this, false));
        this.f_21345_.m_25352_(1, (Goal)new ShamanAnimationCommonGoal(this, SPELL_CASTING_BOMB_ANIMATION));
        this.f_21345_.m_25352_(1, (Goal)new ShamanAnimationCommonGoal(this, SPELL_CASTING_SUMMON_ANIMATION));
        this.f_21345_.m_25352_(1, (Goal)new ShamanAnimationCommonGoal(this, SPELL_CASTING_HEAL_ANIMATION));
        this.f_21345_.m_25352_(1, (Goal)new ShamanAnimationCommonGoal(this, SPELL_CASTING_WOLOLO_ANIMATION));
        this.f_21345_.m_25352_(1, (Goal)new ShamanAnimationCommonGoal(this, AVOID_ANIMATION));
        this.f_21345_.m_25352_(1, (Goal)new AnimationFullRangeAttackGoal<EntityImmortalShaman>(this, SPELL_CASTING_FR_ATTACK_ANIMATION, 4.5f, 14, 2.0f, 5.0f, true){

            @Override
            public void onHit(LivingEntity entity) {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.m_21254_()) {
                        player.m_36384_(true);
                    } else {
                        player.m_7292_(new MobEffectInstance((MobEffect)EffectInit.VERTIGO_EFFECT.get(), 40, 0, false, false, true));
                    }
                    return;
                }
                entity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.VERTIGO_EFFECT.get(), 40, 0, false, false, true));
            }

            @Override
            protected boolean preHit(LivingEntity entity) {
                return entity instanceof EntityAbsImmortal && (Boolean)EMConfigHandler.COMMON.OTHER.enableSameMobsTypeInjury.get() != false;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new ShamanSummonGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new ShamanAvoid(this));
        this.f_21345_.m_25352_(4, (Goal)new ShamanBombing(this));
        this.f_21345_.m_25352_(5, (Goal)new ShamanWololo(this));
        this.f_21345_.m_25352_(6, new KeepDistanceGoal<EntityImmortalShaman>(this, 1.0, 16.0f, 1.5f));
    }

    @Override
    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        return (effectInstance.m_19544_() == MobEffects.f_19605_ || effectInstance.m_19544_() == EffectInit.VERTIGO_EFFECT.get()) && super.m_147207_(effectInstance, entity);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    public boolean isGlow() {
        return !this.isWeakness() && super.isGlow();
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.8f;
    }

    public boolean isWeakness() {
        if (this.capability != null) {
            return this.capability.isVertigo();
        }
        return false;
    }

    @Override
    protected void onAnimationFinish(Animation animation) {
        if (!this.m_9236_().f_46443_) {
            if (animation == SPELL_CASTING_FR_ATTACK_ANIMATION) {
                this.attackTick = 200;
            } else if (animation == SPELL_CASTING_HEAL_ANIMATION) {
                int timer;
                if (this.hurtCountBeforeHeal < 2 && !this.isWeakness()) {
                    this.m_5634_((float)((double)this.m_21233_() * (Double)EMConfigHandler.COMMON.MOB.IMMORTAL.IMMORTAL_SHAMAN.healPercentage.get()));
                    this.m_9236_().m_7605_((Entity)this, (byte)12);
                    timer = 15;
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)13);
                    timer = 20;
                }
                this.nextHealTick = 20 * timer;
                this.hurtCountBeforeHeal = 0;
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (!this.m_9236_().f_46443_ && this.m_5448_() != null && !this.m_5448_().m_6084_()) {
            this.m_6710_(null);
        }
        if (this.isWeakness()) {
            this.f_20885_ = this.f_20883_ = this.m_146908_();
        }
        if (this.m_5448_() != null) {
            LivingEntity target = this.m_5448_();
            if (!this.m_9236_().f_46443_ && this.noConflictingTasks() && !this.m_21525_() && this.attackTick <= 0 && (this.targetDistance <= 5.0f && ModEntityUtils.checkTargetComingCloser((LivingEntity)this, target) || this.targetDistance < 4.0f)) {
                this.playAnimation(SPELL_CASTING_FR_ATTACK_ANIMATION);
            }
        }
        if (!this.m_9236_().f_46443_ && this.noConflictingTasks() && !this.m_21525_() && this.getHealthPercentage() != 100.0f && this.nextHealTick <= 0 && (this.m_5448_() != null && this.targetDistance > 8.0f || this.m_5448_() == null)) {
            this.playAnimation(SPELL_CASTING_HEAL_ANIMATION);
        }
        if (this.getAnimation() == SPELL_CASTING_WOLOLO_ANIMATION) {
            if (this.m_9236_().f_46443_) {
                this.addParticlesAroundHeart(30);
            }
        } else if (this.getAnimation() == SPELL_CASTING_HEAL_ANIMATION) {
            if (!this.m_9236_().f_46443_) {
                if (this.getAnimationTick() == 1) {
                    this.m_216990_((SoundEvent)SoundInit.IMMORTAL_SHAMAN_PREPARE_SPELL_CASTING.get());
                }
                if (this.isWeakness()) {
                    this.playAnimation(NO_ANIMATION);
                    this.m_9236_().m_7605_((Entity)this, (byte)13);
                } else if (this.getAnimationTick() > 5 && this.getAnimationTick() < 40 && this.f_19797_ % 5 == 0) {
                    this.m_9236_().m_7605_((Entity)this, (byte)14);
                }
            } else {
                this.addParticlesAroundHeart(55);
            }
        } else if (this.getAnimation() == SPELL_CASTING_SUMMON_ANIMATION) {
            if (this.m_9236_().f_46443_) {
                float speed = 0.08f;
                float yaw = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                float ym = this.f_19796_.m_188501_() * 0.01f;
                float xm = speed * Mth.m_14089_((float)yaw);
                float zm = speed * Mth.m_14031_((float)yaw);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_(), (double)ym, (double)xm, (double)zm);
                this.addParticlesAroundHeart(40);
            }
        } else if (this.getAnimation() == SPELL_CASTING_BOMB_ANIMATION) {
            if (this.m_5448_() != null) {
                this.m_21391_((Entity)this.m_5448_(), 30.0f, 30.0f);
            }
            if (this.m_9236_().f_46443_ && this.getAnimationTick() >= 10 && this.getAnimationTick() <= 12) {
                this.spawnExplosionParticles(5, new ParticleOptions[]{ParticleTypes.f_123745_, ParticleTypes.f_123755_}, 0.15f);
            }
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
            }
        } else if (this.getAnimation() == SPELL_CASTING_FR_ATTACK_ANIMATION) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
            if (this.m_9236_().f_46443_ && this.getAnimationTick() == 12) {
                this.spawnExplosionParticles(50, new ParticleOptions[]{ParticleTypes.f_123745_}, 0.4f);
            }
            if (this.getAnimationTick() == 18) {
                EntityCameraShake.cameraShake(this.m_9236_(), this.m_20182_(), 20.0f, 0.02f, 10, 15);
            }
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.nextHealTick > 0 && !this.isWeakness()) {
            --this.nextHealTick;
        }
        if (this.attackTick > 0) {
            --this.attackTick;
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        Entity entity = source.m_7639_();
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (entity != null) {
            float maximumDamageCap = (float)((Double)EMConfigHandler.COMMON.MOB.IMMORTAL.IMMORTAL_SHAMAN.maximumDamageCap.damageCap.get() * 1.0);
            float maxHurtDamage = this.m_21233_() * maximumDamageCap;
            if (this.getAnimation() == SPELL_CASTING_HEAL_ANIMATION && this.f_20916_ <= 0) {
                ++this.hurtCountBeforeHeal;
            }
            if (!this.isWeakness()) {
                damage = Math.min(damage, maxHurtDamage);
            }
            return super.m_6469_(source, damage);
        }
        if (source.m_269533_(EMTagKey.GENERAL_UNRESISTANT_TO)) {
            return super.m_6469_(source, damage);
        }
        return false;
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 12) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123750_);
        } else if (id == 13) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123792_);
        } else if (id == 14) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123748_);
        }
        super.m_7822_(id);
    }

    @Override
    protected void m_147246_() {
        for (int i = 0; i < 10; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.012;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.2), this.m_20187_() - 0.5, this.m_20262_(0.2), d0, d1, d2);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        RandomSource randomsource = worldIn.m_213780_();
        this.m_213945_(randomsource, difficultyIn);
        return spawnDataIn;
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyInstance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.IMMORTAL_STAFF.get()));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    private void setWololoTarget(@Nullable Sheep pWololoTarget) {
        this.wololoTarget = pWololoTarget;
    }

    @Nullable
    private Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    @Override
    public boolean noConflictingTasks() {
        return !this.isWeakness() && this.getAnimation() == IAnimatedEntity.NO_ANIMATION;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    private void spawnExplosionParticles(int amount, ParticleOptions[] particles, float velocity) {
        ModParticleUtils.randomAnnularParticleOutburst(this.m_9236_(), amount, particles, this.m_20185_(), this.m_20186_(), this.m_20189_(), velocity);
    }

    private void addParticlesAroundHeart(int duration) {
        if (this.heartPos != null && this.heartPos.length > 0 && this.heartPos[0] != null && this.getAnimationTick() < duration) {
            ModParticleUtils.advAttractorParticle((ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.SPELL_CASTING.get()), (Entity)this, 8, 0.0f, 2.0f, 12.0f, new ParticleComponent[]{new ParticleComponent.Attractor(this.heartPos, 1.2f, 0.0f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.0f, 1.0f), false)}, true);
        }
    }

    private void addParticlesAroundSelf(ParticleOptions options) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(options, this.m_20208_(1.0), this.m_20187_() + 0.35, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void m_6504_(LivingEntity entity, float velocity) {
        this.performRangedAttack(entity, false);
    }

    private void performRangedAttack(LivingEntity entity, boolean dangerous) {
        double d1 = 1.0;
        Vec3 vec3 = this.m_20252_(0.0f);
        double d2 = entity.m_20185_() - (this.m_20185_() + vec3.f_82479_ * d1);
        double d3 = entity.m_20227_(0.5) - (0.5 + this.m_20227_(0.5));
        double d4 = entity.m_20189_() - (this.m_20189_() + vec3.f_82481_ * d1);
        EntityShamanBomb shamanBomb = new EntityShamanBomb(this.m_9236_(), (LivingEntity)this, d2, d3, d4);
        shamanBomb.m_5602_((Entity)this);
        shamanBomb.setDangerous(dangerous);
        shamanBomb.m_6034_(this.m_20185_() + vec3.f_82479_ * d1, this.m_20227_(0.74), shamanBomb.m_20189_() + vec3.f_82481_ * d1);
        this.m_9236_().m_7967_((Entity)shamanBomb);
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundInit.IMMORTAL_SHAMAN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.IMMORTAL_SHAMAN_DEATH.get();
    }

    private class ShamanAnimationCommonGoal
    extends AnimationCommonGoal<EntityImmortalShaman> {
        public ShamanAnimationCommonGoal(EntityImmortalShaman entity, Animation animation) {
            super(entity, animation);
        }

        public ShamanAnimationCommonGoal(EntityImmortalShaman entity, Animation animation, EnumSet<Goal.Flag> interruptFlagTypes) {
            super(entity, animation, interruptFlagTypes);
        }

        public void m_8037_() {
            if (EntityImmortalShaman.this.m_5448_() != null) {
                EntityImmortalShaman.this.m_21563_().m_24960_((Entity)EntityImmortalShaman.this.m_5448_(), 30.0f, 30.0f);
            } else if (EntityImmortalShaman.this.getWololoTarget() != null) {
                EntityImmortalShaman.this.m_21563_().m_24960_((Entity)EntityImmortalShaman.this.getWololoTarget(), 30.0f, 30.0f);
            }
        }
    }

    private class ShamanSummonGoal
    extends AnimationSpellAIGoal<EntityImmortalShaman> {
        private final TargetingConditions CountTargeting;

        public ShamanSummonGoal(EntityImmortalShaman spellCaster) {
            super(spellCaster);
            this.CountTargeting = TargetingConditions.m_148353_().m_26883_(30.0).m_148355_().m_26893_();
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            int size = ((EntityImmortalShaman)this.spellCaster).m_9236_().m_45971_(EntityImmortalGolem.class, this.CountTargeting, (LivingEntity)this.spellCaster, ((EntityImmortalShaman)this.spellCaster).m_20191_().m_82400_(30.0)).size();
            return size < ((EntityImmortalShaman)this.spellCaster).f_19796_.m_188503_(6) + 1 && ((EntityImmortalShaman)this.spellCaster).m_5448_() != null && (double)((EntityImmortalShaman)this.spellCaster).targetDistance > 8.0;
        }

        @Override
        protected int getSpellCastingCooling() {
            return 360;
        }

        @Override
        protected void inSpellCasting() {
            if (((EntityImmortalShaman)this.spellCaster).m_5448_() != null) {
                LivingEntity livingEntity = ((EntityImmortalShaman)this.spellCaster).m_5448_();
                double minY = Math.min(livingEntity.m_20186_(), ((EntityImmortalShaman)this.spellCaster).m_20186_());
                double maxY = Math.max(livingEntity.m_20186_(), ((EntityImmortalShaman)this.spellCaster).m_20186_()) + 1.0;
                Vec3 point1 = ModEntityUtils.checkSummonEntityPoint((LivingEntity)this.spellCaster, ((EntityImmortalShaman)this.spellCaster).m_20185_() - 1.0, ((EntityImmortalShaman)this.spellCaster).m_20189_(), minY, maxY);
                this.summonEntity(point1);
                Vec3 point2 = ModEntityUtils.checkSummonEntityPoint((LivingEntity)this.spellCaster, ((EntityImmortalShaman)this.spellCaster).m_20185_() + 1.0, ((EntityImmortalShaman)this.spellCaster).m_20189_(), minY, maxY);
                this.summonEntity(point2);
            }
        }

        private void summonEntity(Vec3 vec3) {
            EntityImmortalGolem entity = (EntityImmortalGolem)((EntityType)EntityInit.IMMORTAL_GOLEM.get()).m_20615_(((EntityImmortalShaman)this.spellCaster).m_9236_());
            if (!((EntityImmortalShaman)this.spellCaster).m_9236_().f_46443_ && entity != null && vec3 != null) {
                entity.setInitSpawn();
                entity.m_6518_((ServerLevelAccessor)((ServerLevel)((EntityImmortalShaman)this.spellCaster).m_9236_()), ((EntityImmortalShaman)this.spellCaster).m_9236_().m_6436_(BlockPos.m_274561_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_)), MobSpawnType.MOB_SUMMONED, null, null);
                entity.setOwner((EntityAbsImmortal)this.spellCaster);
                entity.setSummonAliveTime(20 * (30 + ((EntityImmortalShaman)this.spellCaster).f_19796_.m_188503_(90)));
                Difficulty difficulty = ((EntityImmortalShaman)this.spellCaster).m_9236_().m_46791_();
                entity.setDangerous(((EntityImmortalShaman)this.spellCaster).f_19796_.m_188503_(10 - difficulty.m_19028_()) == 0);
                entity.m_146884_(vec3);
                EntityImmortalShaman.this.m_9236_().m_7967_((Entity)entity);
            }
        }

        @Override
        protected SoundEvent getSpellCastingSound() {
            return (SoundEvent)SoundInit.IMMORTAL_SHAMAN_PREPARE_SPELL_CASTING.get();
        }

        @Override
        protected Animation getAnimation() {
            return SPELL_CASTING_SUMMON_ANIMATION;
        }
    }

    private class ShamanAvoid
    extends AnimationSpellAIGoal<EntityImmortalShaman> {
        private float avoidYaw;

        public ShamanAvoid(EntityImmortalShaman spellCaster) {
            super(spellCaster);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            double angle = ((EntityImmortalShaman)this.spellCaster).m_5448_() != null ? ((EntityImmortalShaman)this.spellCaster).getAngleBetweenEntities((Entity)this.spellCaster, (Entity)((EntityImmortalShaman)this.spellCaster).m_5448_()) : (double)EntityImmortalShaman.this.f_20883_;
            this.avoidYaw = (float)Math.toRadians(angle + 90.0);
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target;
            if (super.m_8036_() && (target = ((EntityImmortalShaman)this.spellCaster).m_5448_()) != null) {
                float distance = EntityImmortalShaman.this.m_20270_((Entity)target) - target.m_20205_() / 2.0f;
                return distance < 5.0f && ModEntityUtils.checkTargetComingCloser((LivingEntity)EntityImmortalShaman.this, target) || distance < 3.0f;
            }
            return false;
        }

        @Override
        protected int getKeyFrames() {
            return 5;
        }

        @Override
        protected void inSpellCasting() {
            if (((EntityImmortalShaman)this.spellCaster).m_20096_() || ((EntityImmortalShaman)this.spellCaster).m_20077_() || ((EntityImmortalShaman)this.spellCaster).m_20069_()) {
                float speed = 1.5f;
                Vec3 move = ((EntityImmortalShaman)this.spellCaster).m_20184_().m_82520_((double)speed * Math.cos(this.avoidYaw), 0.0, (double)speed * Math.sin(this.avoidYaw));
                ((EntityImmortalShaman)this.spellCaster).m_20334_(move.f_82479_, 0.4, move.f_82481_);
            }
        }

        @Override
        protected int getSpellCastingCooling() {
            return 100;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return SoundEvents.f_12317_;
        }

        @Override
        protected Animation getAnimation() {
            return AVOID_ANIMATION;
        }
    }

    private class ShamanBombing
    extends AnimationSpellAIGoal<EntityImmortalShaman> {
        public ShamanBombing(EntityImmortalShaman spellCaster) {
            super(spellCaster);
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            return ((EntityImmortalShaman)this.spellCaster).m_5448_() != null && ((EntityImmortalShaman)this.spellCaster).m_21574_().m_148306_((Entity)((EntityImmortalShaman)this.spellCaster).m_5448_()) && (double)((EntityImmortalShaman)this.spellCaster).targetDistance > 6.0;
        }

        @Override
        protected void inSpellCasting() {
            LivingEntity target = ((EntityImmortalShaman)this.spellCaster).m_5448_();
            RandomSource random = ((EntityImmortalShaman)this.spellCaster).m_217043_();
            if (target != null) {
                ((EntityImmortalShaman)this.spellCaster).performRangedAttack(target, random.m_188503_(5) == 0);
            }
        }

        @Override
        protected int getKeyFrames() {
            return 15;
        }

        @Override
        protected int getSpellCastingCooling() {
            return 80;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return (SoundEvent)SoundInit.IMMORTAL_SHAMAN_PREPARE_SHOOT.get();
        }

        @Override
        protected Animation getAnimation() {
            return SPELL_CASTING_BOMB_ANIMATION;
        }
    }

    private class ShamanWololo
    extends AnimationSpellAIGoal<EntityImmortalShaman> {
        private final TargetingConditions wololoTargeting;

        public ShamanWololo(EntityImmortalShaman spellCaster) {
            super(spellCaster);
            this.wololoTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_26888_(entity -> ((Sheep)entity).m_29874_() == DyeColor.RED);
        }

        @Override
        public boolean m_8036_() {
            if (((EntityImmortalShaman)this.spellCaster).m_5448_() != null) {
                return false;
            }
            if (!((EntityImmortalShaman)this.spellCaster).noConflictingTasks()) {
                return false;
            }
            if (!ModEntityUtils.canMobDestroy((Entity)this.spellCaster)) {
                return false;
            }
            if (((EntityImmortalShaman)this.spellCaster).f_19797_ >= this.nextAttackTickCount) {
                List sheepList = ((EntityImmortalShaman)this.spellCaster).m_9236_().m_45971_(Sheep.class, this.wololoTargeting, (LivingEntity)this.spellCaster, ((EntityImmortalShaman)this.spellCaster).m_20191_().m_82377_(16.0, 4.0, 16.0));
                if (sheepList.isEmpty()) {
                    return false;
                }
                ((EntityImmortalShaman)this.spellCaster).setWololoTarget((Sheep)sheepList.get(((EntityImmortalShaman)this.spellCaster).f_19796_.m_188503_(sheepList.size())));
                return true;
            }
            return false;
        }

        @Override
        public boolean m_8045_() {
            return ((EntityImmortalShaman)this.spellCaster).getWololoTarget() != null && this.attackDelay > 0;
        }

        @Override
        protected void inSpellCasting() {
            Sheep sheep = ((EntityImmortalShaman)this.spellCaster).getWololoTarget();
            if (sheep != null && sheep.m_6084_()) {
                sheep.m_29855_(DyeColor.BLUE);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            ((EntityImmortalShaman)this.spellCaster).setWololoTarget(null);
        }

        @Override
        protected int getSpellCastingCooling() {
            return 120;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return (SoundEvent)SoundInit.IMMORTAL_SHAMAN_PREPARE_SPELL_CASTING.get();
        }

        @Override
        protected Animation getAnimation() {
            return SPELL_CASTING_WOLOLO_ANIMATION;
        }
    }
}

