/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.immortal;

import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationActivateGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationAttackGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationBlockGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationDieGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationHurtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationProjectileAttackGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.base.AnimationMeleeAIGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.base.AnimationRangeAIGoal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public abstract class EntityAbsImmortalSkeleton
extends EntityAbsImmortal
implements RangedAttackMob {
    public static final Animation DIE_ANIMATION = Animation.create((int)60);
    public static final Animation HURT_ANIMATION = Animation.create((int)8);
    public static final Animation MELEE_ATTACK_1_ANIMATION = Animation.create((int)14);
    public static final Animation MELEE_ATTACK_2_ANIMATION = Animation.create((int)16);
    public static final Animation MELEE_ATTACK_3_ANIMATION = Animation.create((int)20);
    public static final Animation RANGED_ATTACK_ANIMATION = Animation.create((int)30);
    public static final Animation BLOCK_ANIMATION = Animation.create((int)10);
    public static final Animation SPAWN_ANIMATION = Animation.create((int)40);
    public static final Animation ROAR_ANIMATION = Animation.create((int)45);
    private static final Animation[] ANIMATIONS = new Animation[]{DIE_ANIMATION, HURT_ANIMATION, MELEE_ATTACK_1_ANIMATION, MELEE_ATTACK_2_ANIMATION, MELEE_ATTACK_3_ANIMATION, RANGED_ATTACK_ANIMATION, BLOCK_ANIMATION, SPAWN_ANIMATION, ROAR_ANIMATION};
    private static final EntityDataAccessor<Integer> DATA_HANDED_STATE = SynchedEntityData.m_135353_(EntityAbsImmortalSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityAbsImmortalSkeleton(EntityType<? extends EntityAbsImmortal> type, Level level) {
        super(type, level);
        this.reassessAttackModeGoal();
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        Entity entity = source.m_7639_();
        boolean hitFlag = true;
        float attackArc = 220.0f;
        if (entity != null) {
            float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this, entity.m_20182_());
            boolean bl = hitFlag = entityRelativeAngle <= attackArc / 2.0f && entityRelativeAngle >= -attackArc / 2.0f || entityRelativeAngle >= 360.0f - attackArc / 2.0f || entityRelativeAngle <= -attackArc + 45.0f;
        }
        if (hitFlag && this.getWeaponType().canBlock() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!(source.m_269533_(DamageTypeTags.f_268490_) || this.getAnimation() != NO_ANIMATION && this.getAnimation() != HURT_ANIMATION && this.getAnimation() != BLOCK_ANIMATION)) {
                this.blockEntity = livingEntity;
                this.m_216990_(SoundEvents.f_12346_);
                if (this.getAnimation() != BLOCK_ANIMATION) {
                    this.playAnimation(BLOCK_ANIMATION);
                }
                return false;
            }
        }
        return super.m_6469_(source, damage);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, false, null));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new EMLookAtGoal(this, Player.class, 8.0f));
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(1, new AnimationDieGoal<EntityAbsImmortalSkeleton>(this));
        this.f_21345_.m_25352_(1, new AnimationHurtGoal<EntityAbsImmortalSkeleton>(this, false));
        this.f_21345_.m_25352_(1, new AnimationActivateGoal<EntityAbsImmortalSkeleton>(this, SPAWN_ANIMATION));
        this.f_21345_.m_25352_(1, new AnimationProjectileAttackGoal<EntityAbsImmortalSkeleton>(this, RANGED_ATTACK_ANIMATION, 19, null));
        this.f_21345_.m_25352_(1, new AnimationAttackGoal<EntityAbsImmortalSkeleton>(this, MELEE_ATTACK_1_ANIMATION, 6, 3.0f, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, new AnimationAttackGoal<EntityAbsImmortalSkeleton>(this, MELEE_ATTACK_2_ANIMATION, 8, 3.0f, 1.0f, 15.0f));
        this.f_21345_.m_25352_(1, new AnimationAttackGoal<EntityAbsImmortalSkeleton>(this, MELEE_ATTACK_3_ANIMATION, 12, 2.5f, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, new AnimationBlockGoal<EntityAbsImmortalSkeleton>(this, BLOCK_ANIMATION));
        this.f_21345_.m_25352_(2, new AnimationMeleeAIGoal<EntityAbsImmortalSkeleton>(this, 1.0, e -> e.getWeaponType() == AttackType.MAIN_HANDED || e.getWeaponType() == AttackType.MAIN_HANDED_SHIELD, MELEE_ATTACK_1_ANIMATION, MELEE_ATTACK_2_ANIMATION));
        this.f_21345_.m_25352_(2, new AnimationMeleeAIGoal<EntityAbsImmortalSkeleton>(this, 1.0, 5, e -> e.getWeaponType() == AttackType.NONE || e.getWeaponType() == AttackType.NONE_SHIELD, MELEE_ATTACK_3_ANIMATION));
        this.f_21345_.m_25352_(2, new AnimationRangeAIGoal<EntityAbsImmortalSkeleton>(this, 1.0, 20, 12.0f, Items.f_42411_, e -> this.getWeaponType() == AttackType.BOW || this.getWeaponType() == AttackType.BOW_SHIELD, RANGED_ATTACK_ANIMATION));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.getWeaponType() == AttackType.BOW || this.getWeaponType() == AttackType.BOW_SHIELD) {
            if (this.m_5448_() != null && !this.m_21525_() && this.isActive()) {
                LivingEntity target = this.m_5448_();
                if (this.attackTick == 0 && this.m_21574_().m_148306_((Entity)target)) {
                    this.attacking = true;
                }
                if (this.attacking && this.m_21574_().m_148306_((Entity)target) && ((double)this.targetDistance < 1.5 || (double)this.targetDistance < 2.5 && ModEntityUtils.checkTargetComingCloser((LivingEntity)this, target))) {
                    this.m_5810_();
                    this.playAnimation(MELEE_ATTACK_2_ANIMATION);
                    this.attackTick = 20;
                    this.attacking = false;
                }
            } else {
                this.attacking = false;
            }
        }
        if (this.getAnimation() != NO_ANIMATION) {
            this.m_21573_().m_26573_();
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.attackTick > 0) {
            --this.attackTick;
        }
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, BowItem.m_40661_((int)20));
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double d0 = Math.sqrt(x * x + z * z) * (double)0.2f;
        abstractarrow.m_36781_(abstractarrow.m_36789_() + 1.0 * (double)this.m_9236_().m_46791_().m_19028_());
        abstractarrow.m_6686_(x, y + d0, z, 1.6f, 2.0f);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack arrowStack, float distanceFactor) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_HANDED_STATE, (Object)AttackType.NONE.getState());
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.reassessAttackModeGoal();
        this.m_21553_(true);
        return spawnDataIn;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return HURT_ANIMATION;
    }

    @Override
    protected Animation getSpawnAnimation() {
        return SPAWN_ANIMATION;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundInit.IMMORTAL_SKELETON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.IMMORTAL_SKELETON_DEATH.get();
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.reassessAttackModeGoal();
        this.m_21553_(true);
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack itemStack) {
        super.m_8061_(equipmentSlot, itemStack);
        if (!this.m_9236_().f_46443_) {
            this.reassessAttackModeGoal();
        }
    }

    public AttackType getWeaponType() {
        return AttackType.byState((Integer)this.f_19804_.m_135370_(DATA_HANDED_STATE));
    }

    public void setWeaponType(AttackType attackType) {
        this.f_19804_.m_135381_(DATA_HANDED_STATE, (Object)attackType.getState());
    }

    protected void reassessAttackModeGoal() {
        if (!this.m_9236_().f_46443_) {
            ItemStack mainHandItem = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            AttackType type = mainHandItem.m_150930_(Items.f_42411_) ? AttackType.BOW : (!this.m_6844_(EquipmentSlot.MAINHAND).m_41619_() ? AttackType.MAIN_HANDED : AttackType.NONE);
            ItemStack offhandItem = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof ShieldItem));
            if (offhandItem.m_150930_(Items.f_42740_)) {
                type = type == AttackType.BOW ? AttackType.BOW_SHIELD : (type == AttackType.MAIN_HANDED ? AttackType.MAIN_HANDED_SHIELD : AttackType.NONE_SHIELD);
            }
            this.setWeaponType(type);
        }
    }

    public static enum AttackType {
        NONE(0),
        MAIN_HANDED(1),
        BOW(2),
        MAIN_HANDED_SHIELD(3, true),
        BOW_SHIELD(4, true),
        NONE_SHIELD(5, true);

        private final int state;
        private boolean canBlock;

        private AttackType(int state) {
            this(state, false);
        }

        private AttackType(int state, boolean canBlock) {
            this.state = state;
            this.canBlock = canBlock;
        }

        public int getState() {
            return this.state;
        }

        public void setBlock(boolean canBlock) {
            this.canBlock = canBlock;
        }

        public boolean canBlock() {
            return this.canBlock;
        }

        public static AttackType byState(int id) {
            for (AttackType attackType : AttackType.values()) {
                if (id != attackType.state) continue;
                return attackType;
            }
            return NONE;
        }
    }
}

