/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.immortal;

import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.EEEABMobLibrary;
import com.eeeab.eeeabsmobs.sever.entity.GlowEntity;
import com.eeeab.eeeabsmobs.sever.entity.VenerableEntity;
import com.eeeab.eeeabsmobs.sever.entity.util.ModMobType;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.github.alexthe666.citadel.animation.Animation;
import java.util.UUID;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityAbsImmortal
extends EEEABMobLibrary
implements GlowEntity,
VenerableEntity<EntityAbsImmortal> {
    protected int attackTick;
    protected boolean attacking;
    private boolean isSummon;
    private int countdown = -1;
    @Nullable
    private EntityAbsImmortal owner;
    private UUID ownerUUID;
    private static final EntityDataAccessor<Boolean> DATA_ACTIVE = SynchedEntityData.m_135353_(EntityAbsImmortal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntityAbsImmortal(EntityType<? extends EntityAbsImmortal> type, Level level) {
        super((EntityType<? extends EEEABMobLibrary>)type, level);
    }

    @Override
    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        return effectInstance.m_19544_() != EffectInit.ERODE_EFFECT.get() && super.m_147207_(effectInstance, entity);
    }

    @Override
    protected void onAnimationFinish(Animation animation) {
        if (animation == this.getSpawnAnimation()) {
            this.setActive(true);
            this.active = true;
        }
    }

    protected boolean m_8028_() {
        return true;
    }

    public boolean m_6063_() {
        return this.isActive();
    }

    public void m_6075_() {
        super.m_6075_();
        if (this.m_9236_().f_46443_ && this.getAnimation() == this.getSpawnAnimation()) {
            this.setSpawnParticle(5);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.active && !this.isActive()) {
            this.setActive(true);
        }
        this.active = this.isActive();
        if (!this.active) {
            this.m_21573_().m_26573_();
            this.m_146922_(this.f_19859_);
            this.f_20883_ = this.m_146908_();
            if ((this.m_20096_() || this.m_20069_() || this.m_20077_()) && this.getAnimation() == NO_ANIMATION) {
                this.playAnimation(this.getSpawnAnimation());
            }
            return;
        }
        if (this.isSummon() && --this.countdown <= 0) {
            this.m_6469_(this.m_269291_().m_269064_(), 1.0f);
            this.countdown = 20;
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, 5, false, false, null));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractSkeleton.class, 5, false, false, null));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, 5, false, false, zombie -> !(zombie instanceof ZombifiedPiglin)));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractIllager.class, 5, false, false, illager -> !(illager instanceof SpellcasterIllager)));
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        LivingEntity livingEntity;
        if (this.m_9236_().f_46443_) {
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6336_() == this.m_6336_() && ((Boolean)EMConfigHandler.COMMON.OTHER.enableSameMobsTypeInjury.get()).booleanValue()) {
            return false;
        }
        return super.m_6469_(source, damage);
    }

    protected void setSummonAliveTime(int time) {
        this.isSummon = true;
        this.countdown = time;
    }

    @NotNull
    public MobType m_6336_() {
        return ModMobType.IMMORTAL;
    }

    @Override
    protected void m_147246_() {
        for (int i = 0; i < 20; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void setSpawnParticle(int amount) {
        RandomSource randomsource = this.m_217043_();
        BlockState blockstate = this.m_20075_();
        if (blockstate.m_60799_() != RenderShape.INVISIBLE) {
            for (int i = 0; i < amount; ++i) {
                double d0 = this.m_20185_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.2f, (float)0.2f);
                double d1 = this.m_20186_();
                double d2 = this.m_20189_() + (double)Mth.m_216283_((RandomSource)randomsource, (float)-0.2f, (float)0.2f);
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).m_6336_() == ModMobType.IMMORTAL) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ACTIVE, (Object)true);
    }

    public void setActive(boolean isActive) {
        this.f_19804_.m_135381_(DATA_ACTIVE, (Object)isActive);
    }

    public boolean isActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ACTIVE);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.isSummon) {
            compound.m_128405_("countdown", this.countdown);
        }
        if (this.owner != null && this.owner.m_21223_() > 0.0f) {
            compound.m_128362_("owner", this.owner.m_20148_());
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("countdown")) {
            this.setSummonAliveTime(compound.m_128451_("countdown"));
        }
        this.setOwnerUUID(compound.m_128403_("owner") ? compound.m_128342_("owner") : null);
    }

    protected Animation getSpawnAnimation() {
        return null;
    }

    public void setInitSpawn() {
        this.active = false;
        this.setActive(false);
    }

    @Override
    @Nullable
    public EntityAbsImmortal getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@Nullable EntityAbsImmortal owner) {
        this.owner = owner;
    }

    @Override
    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    @Override
    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public boolean isSummon() {
        return this.isSummon;
    }

    @Override
    public boolean isGlow() {
        return this.m_21223_() > 0.0f;
    }
}

