/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.effects;

import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class EntityFallingBlock
extends Entity {
    public static float DROP_FACTORS = 0.1f;
    private static final EntityDataAccessor<String> MODE = SynchedEntityData.m_135353_(EntityFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> ANIM_V_Y = SynchedEntityData.m_135353_(EntityFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DURATION = SynchedEntityData.m_135353_(EntityFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<BlockState> BLOCK_STATE = SynchedEntityData.m_135353_(EntityFallingBlock.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    public float animY = 0.0f;
    public float prevAnimY = 0.0f;

    public EntityFallingBlock(EntityType<EntityFallingBlock> entityType, Level level) {
        super(entityType, level);
        this.setDuration(20);
    }

    public EntityFallingBlock(Level worldIn, BlockState blockState, float vy) {
        super((EntityType)EntityInit.FALLING_BLOCK.get(), worldIn);
        this.setMode(FallingMoveType.RENDER_MOVE);
        this.setBlockState(blockState);
        this.setAnimVY(vy);
    }

    public EntityFallingBlock(Level level, double px, double py, double pz, BlockState blockState, int duration) {
        super((EntityType)EntityInit.FALLING_BLOCK.get(), level);
        this.setMode(FallingMoveType.OVERALL_MOVE);
        this.setBlockState(blockState);
        this.m_6034_(px, py + (double)((1.0f - this.m_20206_()) / 2.0f), pz);
        this.setDuration(duration);
        this.f_19854_ = px;
        this.f_19855_ = py;
        this.f_19856_ = pz;
        this.m_20256_(Vec3.f_82478_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BLOCK_STATE, (Object)Blocks.f_50493_.m_49966_());
        this.f_19804_.m_135372_(MODE, (Object)FallingMoveType.RENDER_MOVE.toString());
        this.f_19804_.m_135372_(ANIM_V_Y, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DURATION, (Object)20);
    }

    public void m_8119_() {
        if (this.getMode() == FallingMoveType.RENDER_MOVE) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        super.m_8119_();
        if (this.getMode() == FallingMoveType.OVERALL_MOVE) {
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82492_(0.0, (double)(DROP_FACTORS / 2.0f), 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.98));
            if (this.m_20096_() && this.f_19797_ > this.getDuration() || this.f_19797_ > 300) {
                this.m_146870_();
            }
        } else {
            float animVY = this.getAnimVY();
            this.prevAnimY = this.animY;
            this.animY += animVY;
            this.setAnimVY(animVY - DROP_FACTORS);
            if ((double)this.animY < -0.5) {
                this.m_146870_();
            }
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        BlockState blockState = this.getBlockState();
        compoundTag.m_128365_("block_state", (Tag)NbtUtils.m_129202_((BlockState)blockState));
        compoundTag.m_128405_("duration", this.getDuration());
        compoundTag.m_128405_("tickTimer", this.f_19797_);
        compoundTag.m_128350_("vy", ((Float)this.m_20088_().m_135370_(ANIM_V_Y)).floatValue());
    }

    protected void m_7378_(CompoundTag compoundTag) {
        this.setBlockState(NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)compoundTag.m_128469_("block_state")));
        this.setDuration(compoundTag.m_128451_("duration"));
        this.f_19797_ = compoundTag.m_128451_("tickTimer");
        this.setAnimVY(compoundTag.m_128457_("vy"));
    }

    public boolean m_6051_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public BlockState getBlockState() {
        return (BlockState)this.f_19804_.m_135370_(BLOCK_STATE);
    }

    public void setBlockState(BlockState p_270267_) {
        this.f_19804_.m_135381_(BLOCK_STATE, (Object)p_270267_);
    }

    public FallingMoveType getMode() {
        String mode = (String)this.f_19804_.m_135370_(MODE);
        if (mode.isEmpty()) {
            return FallingMoveType.RENDER_MOVE;
        }
        return FallingMoveType.valueOf(mode);
    }

    public void setMode(FallingMoveType type) {
        this.f_19804_.m_135381_(MODE, (Object)type.toString());
    }

    public float getAnimVY() {
        return ((Float)this.m_20088_().m_135370_(ANIM_V_Y)).floatValue();
    }

    private void setAnimVY(float vy) {
        this.m_20088_().m_135381_(ANIM_V_Y, (Object)Float.valueOf(vy));
    }

    public int getDuration() {
        return (Integer)this.m_20088_().m_135370_(DURATION);
    }

    public void setDuration(int duration) {
        this.m_20088_().m_135381_(DURATION, (Object)duration);
    }

    public static enum FallingMoveType {
        RENDER_MOVE,
        OVERALL_MOVE;

    }
}

