/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.corpse;

import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleBase;
import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleComponent;
import com.eeeab.eeeabsmobs.client.particle.util.anim.AnimData;
import com.eeeab.eeeabsmobs.client.util.ModParticleUtils;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.IEntity;
import com.eeeab.eeeabsmobs.sever.entity.NeedStopAiEntity;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.KeepDistanceGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationDieGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationFullRangeAttackGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.base.AnimationCommonGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.base.AnimationSpellAIGoal;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityAbsCorpse;
import com.eeeab.eeeabsmobs.sever.entity.corpse.EntityCorpse;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityCrimsonCrack;
import com.eeeab.eeeabsmobs.sever.entity.projectile.EntityBloodBall;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.Nullable;

public class EntityCorpseWarlock
extends EntityAbsCorpse
implements IEntity,
NeedStopAiEntity,
RangedAttackMob {
    public static final Animation DIE_ANIMATION = Animation.create((int)0);
    public static final Animation ATTACK_ANIMATION = Animation.create((int)15);
    public static final Animation SUMMON_ANIMATION = Animation.create((int)30);
    public static final Animation FRENZY_ANIMATION = Animation.create((int)30);
    public static final Animation TELEPORT_ANIMATION = Animation.create((int)30);
    public static final Animation REST_POS_ANIMATION = Animation.create((int)30);
    public static final Animation VAMPIRE_ANIMATION = Animation.create((int)90);
    public static final Animation BABBLE_ANIMATION = Animation.create((int)666);
    public static final Animation TEARAPARTSPACE_ANIMATION = Animation.create((int)30);
    private static final Animation[] ANIMATIONS = new Animation[]{DIE_ANIMATION, ATTACK_ANIMATION, SUMMON_ANIMATION, FRENZY_ANIMATION, TELEPORT_ANIMATION, REST_POS_ANIMATION, VAMPIRE_ANIMATION, BABBLE_ANIMATION, TEARAPARTSPACE_ANIMATION};
    private int nextDPTick;
    private int hurtCount;
    private int nextHealTick;
    private List<EntityCorpse> entities = new ArrayList<EntityCorpse>();
    public static final int[] SPAWN_COUNT = new int[]{2, 4, 6};
    private static final int MAX_HURT_COUNT = 3;
    private static final UniformInt NEXT_HEAL_TIME = TimeUtil.m_145020_((int)12, (int)24);
    private static final TargetingConditions IGNORE_ALLIES = TargetingConditions.m_148352_().m_26888_(e -> {
        if (e instanceof EntityAbsCorpse) {
            return (Boolean)EMConfigHandler.COMMON.OTHER.enableSameMobsTypeInjury.get() == false;
        }
        return true;
    });
    private static final EntityDataAccessor<Boolean> DATA_IS_HEAL = SynchedEntityData.m_135353_(EntityCorpseWarlock.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> DATA_REST_POSITION = SynchedEntityData.m_135353_(EntityCorpseWarlock.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] myPos;

    public EntityCorpseWarlock(EntityType<? extends EntityAbsCorpse> type, Level level) {
        super(type, level);
        this.active = true;
        if (this.m_9236_().f_46443_) {
            this.myPos = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
        }
    }

    @Override
    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_ELITE;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        return (this.getAnimation() == NO_ANIMATION || effectInstance.m_19544_() == EffectInit.VERTIGO_EFFECT.get()) && super.m_147207_(effectInstance, entity);
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplier) {
        if (!state.m_60713_(Blocks.f_50033_)) {
            super.m_7601_(state, motionMultiplier);
        }
    }

    protected boolean m_7341_(Entity vehicle) {
        return false;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    @Override
    public boolean m_6051_() {
        return false;
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.CORPSES.CORPSE_WARLOCK.combatConfig;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false).m_26146_(300));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(1, new AnimationDieGoal<EntityCorpseWarlock>(this));
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationCommonGoal(this, SUMMON_ANIMATION, true));
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationCommonGoal(this, TELEPORT_ANIMATION, true){

            @Override
            public void m_8056_() {
                super.m_8056_();
                for (int i = 0; i < 16 && !((EntityCorpseWarlock)this.entity).tryTeleportToTargetBehind((Entity)(((EntityCorpseWarlock)this.entity).targetDistance < 8.0f ? ((EntityCorpseWarlock)this.entity).m_5448_() : null)); ++i) {
                }
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationCommonGoal(this, REST_POS_ANIMATION, false){

            @Override
            public void m_8056_() {
                super.m_8056_();
                ((EntityCorpseWarlock)this.entity).tryTeleportToRestPosition();
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationCommonGoal(this, FRENZY_ANIMATION, true));
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationCommonGoal(this, TEARAPARTSPACE_ANIMATION, true));
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationCommonGoal(this, VAMPIRE_ANIMATION, false));
        this.f_21345_.m_25352_(1, (Goal)new WarlockAnimationCommonGoal(this, BABBLE_ANIMATION, false));
        this.f_21345_.m_25352_(2, new AnimationFullRangeAttackGoal<EntityCorpseWarlock>(this, ATTACK_ANIMATION, 4.0f, 6, 2.0f, 5.0f, true));
        this.f_21345_.m_25352_(2, (Goal)new WarlockTeleportGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new WarlockSummonGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new WarlockTearApartGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new WarlockReinforceGoal(this));
        this.f_21345_.m_25352_(6, new KeepDistanceGoal<EntityCorpseWarlock>(this, 0.96, 18.0f, 2.0f));
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new EMLookAtGoal(this, Mob.class, 6.0f));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (!this.m_9236_().f_46443_ && !this.m_21525_() && this.noConflictingTasks() && this.m_5448_() == null && this.f_19797_ % 2 == 0 && this.f_19796_.m_188503_(400) == 0) {
            this.playAnimation(BABBLE_ANIMATION);
        }
        if (!this.m_9236_().f_46443_ && !this.m_21525_() && this.noConflictingTasks() && this.m_5448_() == null && this.f_19797_ % 10 == 0 && this.isNoAtRestPos() && this.nextDPTick <= 0) {
            this.nextDPTick = 1200;
            this.playAnimation(REST_POS_ANIMATION);
        }
        if (!this.m_9236_().f_46443_ && !this.m_21525_() && this.noConflictingTasks() && this.hurtCount >= 3 && this.m_5448_() != null && this.f_19797_ % 2 == 0 && (!this.m_9236_().m_45971_(LivingEntity.class, IGNORE_ALLIES, (LivingEntity)this, this.m_20191_().m_82400_(2.0)).isEmpty() || this.targetDistance <= 5.0f && ModEntityUtils.checkTargetComingCloser((LivingEntity)this, this.m_5448_()) || this.targetDistance < 4.0f)) {
            this.hurtCount = 0;
            this.playAnimation(ATTACK_ANIMATION);
        }
        if (!this.m_9236_().f_46443_ && !this.m_21525_() && this.f_19797_ % 30 == 0 && this.m_5448_() != null && this.noConflictingTasks() && this.nextHealTick <= 0) {
            this.entities = this.m_9236_().m_45971_(EntityCorpse.class, TargetingConditions.m_148353_().m_26888_(e -> {
                EntityCorpse c;
                return e instanceof EntityCorpse && (!(c = (EntityCorpse)e).m_21023_((MobEffect)EffectInit.FRENZY_EFFECT.get()) || this.getHealthPercentage() < 50.0f) && this == c.getOwner() && !c.valuable;
            }), (LivingEntity)this, this.m_20191_().m_82377_(32.0, 16.0, 32.0)).stream().limit(10L).collect(Collectors.toList());
            if (!this.entities.isEmpty()) {
                this.nextHealTick = NEXT_HEAL_TIME.m_214085_(this.f_19796_);
                this.playAnimation(VAMPIRE_ANIMATION);
            }
        }
        if (!this.m_9236_().f_46443_ && !this.m_21525_() && this.f_19797_ % 40 == 0 && this.m_5448_() == null && this.noConflictingTasks() && this.getHealthPercentage() != 100.0f && this.nextHealTick <= 0) {
            this.entities = this.m_9236_().m_45971_(EntityCorpse.class, TargetingConditions.m_148353_().m_26888_(e -> {
                EntityCorpse c;
                return e instanceof EntityCorpse && this == (c = (EntityCorpse)e).getOwner();
            }), (LivingEntity)this, this.m_20191_().m_82377_(32.0, 16.0, 32.0)).stream().limit(10L).collect(Collectors.toList());
            if (!this.entities.isEmpty()) {
                this.nextHealTick = NEXT_HEAL_TIME.m_214085_(this.f_19796_);
                this.playAnimation(VAMPIRE_ANIMATION);
            }
        }
        if (this.getAnimation() == VAMPIRE_ANIMATION) {
            int tick = this.getAnimationTick();
            if (!this.m_9236_().f_46443_) {
                for (EntityCorpse corps : this.entities) {
                    if (corps == null || !corps.isActive()) continue;
                    Vec3 diff = corps.m_20182_().m_82546_(this.m_20182_().m_82520_(0.0, 5.0, 0.0));
                    float strength = 0.05f;
                    if (this.m_20270_((Entity)corps) >= 16.0f) {
                        strength += 0.05f;
                    }
                    diff = diff.m_82541_().m_82490_((double)strength);
                    corps.m_20256_(corps.m_20184_().m_82546_(diff));
                    if (!(corps.m_20186_() < this.m_20186_() + 3.0)) continue;
                    corps.m_20256_(corps.m_20184_().m_82520_(0.0, 0.075, 0.0));
                }
                LivingEntity target = this.m_5448_();
                if (tick == 50) {
                    this.entities.forEach(LivingEntity::m_6074_);
                    this.setIsHeal(target != null && this.getHealthPercentage() < 50.0f || target == null && this.getHealthPercentage() != 100.0f);
                    this.m_6504_(target, 1.0f);
                } else if (tick > 60) {
                    this.m_20334_(0.0, 0.0, 0.0);
                    if (!this.isHeal() && target != null) {
                        this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    }
                } else {
                    this.m_20334_(0.0, 0.12f, 0.0);
                }
            } else if (tick == 20) {
                Vec3 vec3 = this.m_20182_();
                float yRot = this.f_20883_;
                float offsetX = (float)(Math.cos(Math.toRadians(yRot + 90.0f)) * 1.5);
                float offsetZ = (float)(Math.sin(Math.toRadians(yRot + 90.0f)) * 1.5);
                this.myPos[0] = new Vec3(vec3.f_82479_ + (double)offsetX, vec3.f_82480_ + (double)this.m_20206_() * 0.6, vec3.f_82481_ + (double)offsetZ);
                AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.CRIMSON.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 10.0, 1.0, 1.0, 1.0, 1.0, 1.0, 30.0, true, false, false, new ParticleComponent[]{new ParticleComponent.PinLocation(this.myPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.oscillate(0.25f, -0.24f, 12), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Y, AnimData.startAndEnd(0.0f, 8.0f), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_X, AnimData.startAndEnd(0.0f, -offsetX), true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.POS_Z, AnimData.startAndEnd(0.0f, -offsetZ), true)});
            } else if (tick == 50) {
                this.myPos[1] = this.m_20182_().m_82520_(0.0, 5.0, 0.0);
                for (int i = 0; i < 64; ++i) {
                    double d0 = this.myPos[1].f_82479_ + (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.5f, (float)0.5f);
                    double d1 = this.myPos[1].f_82480_;
                    double d2 = this.myPos[1].f_82481_ + (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.5f, (float)0.5f);
                    this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_()), d0, d1, d2, 0.0, 0.0, 0.0);
                }
                this.m_9236_().m_7785_(this.myPos[1].f_82479_, this.myPos[1].f_82480_, this.myPos[1].f_82481_, (SoundEvent)SoundInit.CORPSE_WARLOCK_TEAR.get(), this.m_5720_(), this.m_6121_(), this.m_6100_(), false);
            } else if (this.isHeal() && tick == 80) {
                for (int i = 0; i < 5; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.1, this.m_20262_(1.0), d0, d1, d2);
                }
            }
        } else if (this.getAnimation() == TELEPORT_ANIMATION || this.getAnimation() == REST_POS_ANIMATION) {
            int tick = this.getAnimationTick();
            if (tick == 1) {
                this.m_6842_(true);
                this.doTeleportEffect();
            } else if (tick == 15) {
                this.doTeleportEffect();
            } else if (tick >= 20) {
                this.m_6842_(false);
            }
        } else if (this.getAnimation() == BABBLE_ANIMATION) {
            int tick = this.getAnimationTick();
            if (this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < 12.0f) {
                this.setAnimation(NO_ANIMATION);
            }
            if (this.m_9236_().f_46443_) {
                if (tick % 20 == 0) {
                    Vec3 vec3 = this.m_20182_();
                    float yRot = this.f_20883_;
                    float offsetX = (float)(Math.cos(Math.toRadians(yRot + 90.0f)) * 2.5);
                    float offsetZ = (float)(Math.sin(Math.toRadians(yRot + 90.0f)) * 2.5);
                    this.myPos[0] = new Vec3(vec3.f_82479_ + (double)offsetX, vec3.f_82480_ + (double)this.m_20206_() * 1.5, vec3.f_82481_ + (double)offsetZ);
                    AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.CRIMSON_EYE.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 10.0, 1.0, 1.0, 1.0, 1.0, 1.0, 20.0, true, false, true, new ParticleComponent[]{new ParticleComponent.PinLocation(this.myPos)});
                }
                if (tick % 5 == 0) {
                    ModParticleUtils.advAttractorParticle((ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.ADV_ORB.get()), (Entity)this, 12, 0.0f, 2.5f, 20.0f, new ParticleComponent[]{new ParticleComponent.Attractor(this.myPos, 1.2f, 0.0f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.0f, 0.6f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.KeyTrack.startAndEnd(3.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.BLUE, AnimData.KeyTrack.constant(0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.GREEN, AnimData.KeyTrack.constant(0.0f), false)}, false);
                }
            }
        } else if (this.getAnimation() == ATTACK_ANIMATION) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
            if (this.m_9236_().f_46443_ && this.getAnimationTick() == 5) {
                ModParticleUtils.randomAnnularParticleOutburst(this.m_9236_(), 50.0, new ParticleOptions[]{ParticleTypes.f_123762_}, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.4f);
            }
        }
    }

    private void doTeleportEffect() {
        this.m_20334_(0.0, 0.0, 0.0);
        if (this.m_9236_().f_46443_) {
            this.myPos[0] = this.m_20182_().m_82520_(0.0, (double)this.m_20206_() * 0.6, 0.0);
            AnimData.KeyTrack keyTrack1 = AnimData.KeyTrack.oscillate(0.0f, 2.0f, 24);
            AnimData.KeyTrack keyTrack2 = new AnimData.KeyTrack(new float[]{0.0f, 40.0f, 40.0f, 0.0f}, new float[]{0.0f, 0.2f, 0.8f, 1.0f});
            AdvancedParticleBase.spawnParticle(this.m_9236_(), (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.CRIMSON.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 14.0, true, false, false, new ParticleComponent[]{new ParticleComponent.PinLocation(this.myPos), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, keyTrack1, true), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, keyTrack2, false)});
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            if (this.nextDPTick > 0) {
                --this.nextDPTick;
            }
            if (this.nextHealTick > 0) {
                --this.nextHealTick;
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        Entity entity = source.m_7639_();
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (this.m_6673_(source)) {
            return false;
        }
        if (entity != null) {
            if (this.getAnimation() == TELEPORT_ANIMATION) {
                return false;
            }
            if (this.getAnimation() == BABBLE_ANIMATION) {
                this.setAnimation(NO_ANIMATION);
            } else if (this.getAnimation() == VAMPIRE_ANIMATION) {
                damage = 0.0f;
            }
            if (!ModEntityUtils.isProjectileSource(source) && this.f_19796_.m_188501_() < 0.6f) {
                ++this.hurtCount;
            }
            float maxDamageCap = (float)((Double)EMConfigHandler.COMMON.MOB.CORPSES.CORPSE_WARLOCK.maximumDamageCap.damageCap.get() * 1.0);
            float maxHurtDamage = this.m_21233_() * maxDamageCap;
            damage = Math.min(damage, maxHurtDamage);
            return super.m_6469_(source, damage);
        }
        if (source.m_269533_(EMTagKey.GENERAL_UNRESISTANT_TO)) {
            return super.m_6469_(source, damage);
        }
        return false;
    }

    protected float m_6515_(DamageSource source, float damage) {
        damage = super.m_6515_(source, damage);
        if (source.m_7639_() == this) {
            damage = 0.0f;
        }
        if (source.m_269533_(EMTagKey.MAGIC_UNRESISTANT_TO)) {
            damage *= 0.2f;
        }
        return damage;
    }

    @Override
    protected void m_147246_() {
        for (int j = 0; j < 64; ++j) {
            double d0 = (double)j / 63.0;
            float f = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
            float f1 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
            float f2 = (this.f_19796_.m_188501_() - 0.5f) * 0.2f;
            double d1 = Mth.m_14139_((double)d0, (double)this.f_19854_, (double)this.m_20185_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
            double d2 = Mth.m_14139_((double)d0, (double)this.f_19855_, (double)this.m_20186_()) + this.f_19796_.m_188500_() * (double)this.m_20206_();
            double d3 = Mth.m_14139_((double)d0, (double)this.f_19856_, (double)this.m_20189_()) + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_() * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, d1, d2, d3, (double)f, (double)f1, (double)f2);
            if (j >= 10) continue;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123746_, d1, d2, d3, (double)f, (double)f1, (double)f2);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        return super.m_6518_(level, instance, spawnType, groupData, tag);
    }

    public boolean tryTeleportToTargetBehind(@Nullable Entity target) {
        double d2;
        double d1;
        double radian = target != null && target.m_6084_() ? Math.toRadians(this.getAngleBetweenEntities((Entity)this, target) + 90.0) : Math.toRadians(this.f_19796_.m_188503_(360));
        double d0 = this.m_20185_() - (double)(this.f_19796_.m_188503_(12) + 12) * Math.cos(radian);
        EntityTeleportEvent.TeleportCommand event = ForgeEventFactory.onEntityTeleportCommand((Entity)this, (double)d0, (double)(d1 = this.m_20186_() + (double)(this.f_19796_.m_188503_(64) - 32)), (double)(d2 = this.m_20189_() - (double)(this.f_19796_.m_188503_(12) + 12) * Math.sin(radian)));
        if (event.isCanceled()) {
            return false;
        }
        boolean flag = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
        if (flag && !this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
            this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        return flag;
    }

    public void tryTeleportToRestPosition() {
        Optional<BlockPos> restPos = this.getRestPos();
        if (restPos.isPresent()) {
            BlockPos pos = restPos.get();
            if (this.m_5448_() != null) {
                return;
            }
            EntityTeleportEvent.TeleportCommand event = ForgeEventFactory.onEntityTeleportCommand((Entity)this, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            if (event.isCanceled()) {
                return;
            }
            boolean flag = this.m_20984_((float)pos.m_123341_() + 0.5f, pos.m_123342_(), (float)pos.m_123343_() + 0.5f, false);
            if (flag && !this.m_20067_()) {
                this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
            }
        }
    }

    public boolean checkCanSummonCorpse() {
        return this.getNearByEntities(EntityCorpse.class, 16.0, 16.0, 16.0, 16.0).size() <= 12;
    }

    public void summonCorpse(Vec3 vec3) {
        EntityType entityType = this.f_19796_.m_188499_() ? (EntityType)EntityInit.CORPSE.get() : (EntityType)EntityInit.CORPSE_VILLAGER.get();
        EntityCorpse entity = (EntityCorpse)entityType.m_20615_(this.m_9236_());
        if (entity != null && vec3 != null && !this.m_9236_().f_46443_) {
            entity.setInitSpawn();
            entity.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_9236_()), this.m_9236_().m_6436_(BlockPos.m_274561_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_)), MobSpawnType.MOB_SUMMONED, null, null);
            entity.setOwner(this);
            entity.m_20219_(vec3);
            this.m_9236_().m_7967_((Entity)entity);
        }
    }

    public TargetType assessTargetAI() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            float threat;
            AttributeInstance attribute = target.m_21051_(Attributes.f_22281_);
            AttributeInstance attribute1 = target.m_21051_(Attributes.f_22284_);
            float health = target.m_21233_();
            float attack = 0.0f;
            float armor = 0.0f;
            if (attribute != null) {
                attack = (float)attribute.m_22115_();
            }
            if (attribute1 != null) {
                armor = (float)attribute1.m_22115_();
            }
            if ((threat = Math.max(attack + armor, health / 10.0f)) >= 10.0f && threat <= 30.0f) {
                return TargetType.KNOTTY;
            }
            if (threat > 30.0f) {
                return TargetType.HARD;
            }
        }
        return TargetType.COMMON;
    }

    public void m_6504_(@Nullable LivingEntity entity, float velocity) {
        EntityBloodBall bloodBall = new EntityBloodBall(this.m_9236_(), 30, this.isHeal(), this.entities.size());
        if (entity != null) {
            bloodBall.setTargetUUID(entity.m_20148_());
        }
        bloodBall.m_5602_((Entity)this);
        bloodBall.m_146884_(this.m_20182_().m_82520_(0.0, 5.0, 0.0));
        this.m_9236_().m_7967_((Entity)bloodBall);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_HEAL, (Object)false);
        this.f_19804_.m_135372_(DATA_REST_POSITION, Optional.empty());
    }

    protected void m_7472_(DamageSource source, int pLooting, boolean pRecentlyHit) {
        ItemEntity itementity;
        super.m_7472_(source, pLooting, pRecentlyHit);
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (itementity = this.m_19998_((ItemLike)ItemInit.HEART_OF_PAGAN.get())) != null) {
            itementity.m_32064_();
        }
    }

    @Nullable
    protected SoundEvent m_5592_() {
        this.m_5496_((SoundEvent)SoundInit.CORPSE_WARLOCK_HURT.get(), this.m_6121_(), this.m_6100_() - 0.5f);
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        this.m_5496_((SoundEvent)SoundInit.CORPSE_WARLOCK_HURT.get(), this.m_6121_() * 0.8f, this.m_6100_() + 0.25f);
        return null;
    }

    @Override
    public Animation getDeathAnimation() {
        return DIE_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return null;
    }

    public Animation[] getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public boolean noConflictingTasks() {
        return this.getAnimation() == NO_ANIMATION;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.getRestPos().ifPresent(pos -> compound.m_128365_("spawnPos", (Tag)NbtUtils.m_129224_((BlockPos)pos)));
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("spawnPos")) {
            this.setRestPos(NbtUtils.m_129239_((CompoundTag)compound.m_128469_("spawnPos")));
        }
    }

    public boolean isHeal() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_HEAL);
    }

    public void setIsHeal(boolean isHeal) {
        this.f_19804_.m_135381_(DATA_IS_HEAL, (Object)isHeal);
    }

    private boolean isNoAtRestPos() {
        Optional<BlockPos> restPos = this.getRestPos();
        return restPos.filter(blockPos -> blockPos.m_123331_((Vec3i)this.m_20183_()) > 9.0).isPresent();
    }

    public Optional<BlockPos> getRestPos() {
        return (Optional)this.f_19804_.m_135370_(DATA_REST_POSITION);
    }

    public void setRestPos(BlockPos pos) {
        this.f_19804_.m_135381_(DATA_REST_POSITION, Optional.ofNullable(pos));
    }

    public int getNextHealTick() {
        return this.nextHealTick;
    }

    public static AttributeSupplier.Builder setAttributes() {
        return EntityCorpseWarlock.m_21552_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22279_, 0.32).m_22268_(Attributes.f_22277_, 36.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    static class WarlockAnimationCommonGoal
    extends AnimationCommonGoal<EntityCorpseWarlock> {
        private final boolean lookAtTarget;

        public WarlockAnimationCommonGoal(EntityCorpseWarlock entity, Animation animation, boolean lookAtTarget) {
            super(entity, animation);
            this.lookAtTarget = lookAtTarget;
        }

        public void m_8037_() {
            LivingEntity target = ((EntityCorpseWarlock)this.entity).m_5448_();
            if (this.lookAtTarget && target != null) {
                ((EntityCorpseWarlock)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
        }
    }

    static class WarlockTeleportGoal
    extends AnimationSpellAIGoal<EntityCorpseWarlock> {
        public WarlockTeleportGoal(EntityCorpseWarlock spellCaster) {
            super(spellCaster);
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target;
            if (super.m_8036_() && (target = ((EntityCorpseWarlock)this.spellCaster).m_5448_()) != null) {
                float distance = ((EntityCorpseWarlock)this.spellCaster).m_20270_((Entity)target) - target.m_20205_() / 2.0f;
                return distance < 16.0f && ((EntityCorpseWarlock)this.spellCaster).m_217043_().m_188503_(200) == 0 || distance < 8.0f && ModEntityUtils.checkTargetComingCloser((LivingEntity)this.spellCaster, target) || distance < 6.0f;
            }
            return false;
        }

        @Override
        protected void inSpellCasting() {
        }

        @Override
        protected int getSpellCastingCooling() {
            return 100;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return null;
        }

        @Override
        protected Animation getAnimation() {
            return TELEPORT_ANIMATION;
        }
    }

    static class WarlockSummonGoal
    extends AnimationSpellAIGoal<EntityCorpseWarlock> {
        public WarlockSummonGoal(EntityCorpseWarlock spellCaster) {
            super(spellCaster);
        }

        @Override
        public boolean m_8036_() {
            LivingEntity target = ((EntityCorpseWarlock)this.spellCaster).m_5448_();
            boolean flag = ((EntityCorpseWarlock)this.spellCaster).getNextHealTick() <= 0;
            boolean flag1 = ((EntityCorpseWarlock)this.spellCaster).f_19797_ >= this.nextAttackTickCount;
            boolean flag2 = ((EntityCorpseWarlock)this.spellCaster).checkCanSummonCorpse();
            if (target != null && target.m_6084_()) {
                if (!((EntityCorpseWarlock)this.spellCaster).noConflictingTasks()) {
                    return false;
                }
                return flag1 && flag2;
            }
            return flag && flag1 && ((EntityCorpseWarlock)this.spellCaster).getHealthPercentage() != 100.0f && flag2;
        }

        @Override
        public boolean m_8045_() {
            return this.attackDelay > 0;
        }

        @Override
        protected void inSpellCasting() {
            LivingEntity target = ((EntityCorpseWarlock)this.spellCaster).m_5448_();
            double minY = ((EntityCorpseWarlock)this.spellCaster).m_20186_();
            double maxY = ((EntityCorpseWarlock)this.spellCaster).m_20186_() + 1.0;
            if (target != null) {
                minY = Math.min(target.m_20186_(), ((EntityCorpseWarlock)this.spellCaster).m_20186_());
                maxY = Math.max(target.m_20186_(), ((EntityCorpseWarlock)this.spellCaster).m_20186_()) + 1.0;
            }
            TargetType targetType = ((EntityCorpseWarlock)this.spellCaster).assessTargetAI();
            int count = SPAWN_COUNT[Math.min(targetType.type, SPAWN_COUNT.length - 1)];
            for (int i = 0; i < count; ++i) {
                float f1 = (float)((double)((EntityCorpseWarlock)this.spellCaster).m_146908_() + (double)((float)i * (float)Math.PI) * (2.0 / (double)count));
                double x = ((EntityCorpseWarlock)this.spellCaster).m_20185_() + (double)Mth.m_14089_((float)f1) * 3.0;
                double z = ((EntityCorpseWarlock)this.spellCaster).m_20189_() + (double)Mth.m_14031_((float)f1) * 3.0;
                ((EntityCorpseWarlock)this.spellCaster).summonCorpse(ModEntityUtils.checkSummonEntityPoint((LivingEntity)this.spellCaster, x, z, minY, maxY));
            }
        }

        @Override
        protected int getSpellCastingCooling() {
            return ((EntityCorpseWarlock)this.spellCaster).assessTargetAI().duration;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return null;
        }

        @Override
        protected Animation getAnimation() {
            return SUMMON_ANIMATION;
        }
    }

    static class WarlockTearApartGoal
    extends AnimationSpellAIGoal<EntityCorpseWarlock> {
        private double preX;
        private double preZ;
        private double targetY;
        private double targetX;
        private double targetZ;
        private LivingEntity target;

        public WarlockTearApartGoal(EntityCorpseWarlock spellCaster) {
            super(spellCaster);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            LivingEntity target = ((EntityCorpseWarlock)this.spellCaster).m_5448_();
            if (target != null) {
                this.target = target;
                this.preX = target.m_20185_();
                this.preZ = target.m_20189_();
            }
        }

        @Override
        public void m_8037_() {
            super.m_8037_();
            if (this.target == null) {
                return;
            }
            if (this.attackDelay > 5) {
                ((EntityCorpseWarlock)this.spellCaster).m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            }
            if (this.attackDelay <= 5) {
                ((EntityCorpseWarlock)this.spellCaster).m_21563_().m_24950_(this.targetX, this.targetY, this.targetZ, 30.0f, 30.0f);
            }
            if (this.attackDelay == 6) {
                double dz;
                double x = this.target.m_20185_();
                this.targetY = Mth.m_14107_((double)(this.target.m_20186_() + 1.0));
                double z = this.target.m_20189_();
                double vx = (x - this.preX) / 9.0;
                double vz = (z - this.preZ) / 9.0;
                int radius = 32;
                this.targetX = Mth.m_14107_((double)(x + vx * (double)radius));
                this.targetZ = Mth.m_14107_((double)(z + vz * (double)radius));
                double dx = this.targetX - ((EntityCorpseWarlock)this.spellCaster).m_20185_();
                double dist = dx * dx + (dz = this.targetZ - ((EntityCorpseWarlock)this.spellCaster).m_20189_()) * dz;
                if (dist < 3.0) {
                    this.targetX = Mth.m_14107_((double)this.target.m_20185_());
                    this.targetZ = Mth.m_14107_((double)this.target.m_20189_());
                }
            }
        }

        @Override
        protected void inSpellCasting() {
            if (!((EntityCorpseWarlock)this.spellCaster).m_9236_().f_46443_) {
                double radians = 0.0;
                if (this.target != null) {
                    radians = Math.toRadians(((EntityCorpseWarlock)this.spellCaster).getAngleBetweenEntities((Entity)this.spellCaster, (Entity)this.target) + 90.0);
                }
                EntityCrimsonCrack crack = new EntityCrimsonCrack(((EntityCorpseWarlock)this.spellCaster).m_9236_(), (LivingEntity)this.spellCaster, new Vec3(this.targetX - 2.0 * Math.cos(radians), this.targetY + (double)0.56125f, this.targetZ - 2.0 * Math.sin(radians)));
                ((EntityCorpseWarlock)this.spellCaster).m_9236_().m_7967_((Entity)crack);
            }
        }

        @Override
        protected int getSpellCastingCooling() {
            return 200;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return null;
        }

        @Override
        protected Animation getAnimation() {
            return TEARAPARTSPACE_ANIMATION;
        }
    }

    static class WarlockReinforceGoal
    extends AnimationSpellAIGoal<EntityCorpseWarlock> {
        private final TargetingConditions reinforceConditions = TargetingConditions.m_148352_().m_26883_(16.0).m_26888_(e -> {
            if (!(e instanceof EntityCorpse)) return false;
            EntityCorpse c = (EntityCorpse)e;
            if (!c.valuable) return false;
            return true;
        });
        private List<EntityCorpse> list;

        public WarlockReinforceGoal(EntityCorpseWarlock spellCaster) {
            super(spellCaster);
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            if (((EntityCorpseWarlock)this.spellCaster).f_19797_ % 5 != 0) {
                return false;
            }
            this.list = ((EntityCorpseWarlock)this.spellCaster).m_9236_().m_45971_(EntityCorpse.class, this.reinforceConditions, (LivingEntity)this.spellCaster, ((EntityCorpseWarlock)this.spellCaster).m_20191_().m_82377_(32.0, 16.0, 32.0));
            return !this.list.isEmpty();
        }

        @Override
        protected void inSpellCasting() {
            if (this.list != null && !this.list.isEmpty()) {
                this.list.stream().filter(c -> c.m_6084_() && this.spellCaster == c.getOwner() && !c.m_21023_((MobEffect)EffectInit.FRENZY_EFFECT.get())).forEach(c -> {
                    c.m_7292_(new MobEffectInstance((MobEffect)EffectInit.FRENZY_EFFECT.get(), 200, ((EntityCorpseWarlock)this.spellCaster).assessTargetAI().type));
                    c.valuable = false;
                });
            }
        }

        @Override
        protected int getSpellCastingCooling() {
            return ((EntityCorpseWarlock)this.spellCaster).assessTargetAI().duration;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellCastingSound() {
            return null;
        }

        @Override
        protected Animation getAnimation() {
            return FRENZY_ANIMATION;
        }
    }

    public static enum TargetType {
        COMMON(0, 200),
        KNOTTY(1, 300),
        HARD(2, 400);

        public final int type;
        public final int duration;

        private TargetType(int type, int duration) {
            this.type = type;
            this.duration = duration;
        }
    }
}

