/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation;

import com.eeeab.eeeabsmobs.sever.entity.EEEABMobLibrary;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animation.AnimationAttackGoal;
import com.github.alexthe666.citadel.animation.Animation;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class AnimationAreaAttackGoal<T extends EEEABMobLibrary>
extends AnimationAttackGoal<T> {
    private final float attackArc;
    private final float attackHeight;
    private final boolean faceTarget;

    public AnimationAreaAttackGoal(T entity, Animation animation, int damageKeyframes, float attackDistance, float applyDamage, float applyKnockBack, float attackArc, float attackHeight) {
        this(entity, animation, damageKeyframes, attackDistance, applyDamage, applyKnockBack, attackArc, attackHeight, true);
    }

    public AnimationAreaAttackGoal(T entity, Animation animation, int damageKeyframes, float attackDistance, float applyDamage, float applyKnockBack, float attackArc, float attackHeight, boolean faceTarget) {
        super(entity, animation, damageKeyframes, attackDistance, applyDamage, applyKnockBack);
        this.attackArc = attackArc;
        this.attackHeight = attackHeight;
        this.faceTarget = faceTarget;
        if (faceTarget) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }
    }

    @Override
    public void m_8037_() {
        if (this.faceTarget && this.entity.getAnimationTick() < this.damageKeyframes && this.attackTarget != null) {
            this.entity.m_21391_((Entity)this.attackTarget, 30.0f, 30.0f);
        } else if (this.entity.getAnimationTick() == this.damageKeyframes) {
            this.hitEntity();
        }
    }

    public void hitEntity() {
        List<LivingEntity> entitiesHit = this.entity.getNearByLivingEntities(this.attackDistance, this.attackHeight, this.attackDistance, this.attackDistance);
        boolean hit = false;
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.entity.m_20189_(), entityHit.m_20185_() - this.entity.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.entity.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.entity.m_20189_()) * (entityHit.m_20189_() - this.entity.m_20189_()) + (entityHit.m_20185_() - this.entity.m_20185_()) * (entityHit.m_20185_() - this.entity.m_20185_())) - entityHit.m_20205_() / 2.0f;
            if (!(entityHitDistance <= this.attackArc && entityRelativeAngle <= this.attackArc / 2.0f && entityRelativeAngle >= -this.attackArc / 2.0f || entityRelativeAngle >= 360.0f - this.attackArc / 2.0f) && !(entityRelativeAngle <= -360.0f + this.attackArc / 2.0f)) continue;
            this.entity.doHurtTarget((Entity)entityHit, this.damageMultiplier, this.knockBackMultiplier);
            this.onAttack(this.entity, entityHit, this.damageMultiplier, this.knockBackMultiplier);
            hit = true;
        }
    }
}

