/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class EMConfigHandler {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final Common COMMON;

    static {
        COMMON = new Common(BUILDER);
        SPEC = BUILDER.build();
    }

    public static class Common {
        public final Mob MOB;
        public final ExperimentalEntity EXPERIMENTAL_ENTITY;
        public final Other OTHER;

        public Common(ForgeConfigSpec.Builder builder) {
            this.MOB = new Mob(builder);
            this.EXPERIMENTAL_ENTITY = new ExperimentalEntity(builder);
            this.OTHER = new Other(builder);
        }
    }

    public static class GeneralDamageCap {
        public final ForgeConfigSpec.DoubleValue damageCap;

        public GeneralDamageCap(double damageCapPercentage) {
            this.damageCap = BUILDER.comment("Set damage cap percentage (based on max health)").defineInRange("Damage cap percentage", damageCapPercentage, 0.01, 1.0);
        }
    }

    public static class AttributeConfig {
        public final ForgeConfigSpec.DoubleValue healthMultiplier;
        public final ForgeConfigSpec.DoubleValue attackMultiplier;

        public AttributeConfig() {
            this(1.0f, 1.0f);
        }

        public AttributeConfig(float healthMultiplier, float attackMultiplier) {
            this.healthMultiplier = BUILDER.comment("Set this mob health multiplier").defineInRange("Health multiplier", (double)healthMultiplier, 0.0, Double.MAX_VALUE);
            this.attackMultiplier = BUILDER.comment("Set this mob attack multiplier").defineInRange("Attack multiplier", (double)attackMultiplier, 0.0, Double.MAX_VALUE);
        }
    }

    public static class Other {
        public final ForgeConfigSpec.BooleanValue enableCameraShake;
        public final ForgeConfigSpec.BooleanValue enableShowBloodBars;
        public final ForgeConfigSpec.BooleanValue enableSameMobsTypeInjury;
        public final ForgeConfigSpec.BooleanValue enableRenderFallingBlock;
        public final ForgeConfigSpec.BooleanValue enablePlayBossMusic;

        public Other(ForgeConfigSpec.Builder builder) {
            builder.push("Other");
            this.enableCameraShake = BUILDER.comment("If 'False' disable camera shake").define("Enable camera shake", true);
            this.enableShowBloodBars = BUILDER.comment("If 'False' disable bosses blood bars").define("Enable bosses blood bars", true);
            this.enableSameMobsTypeInjury = BUILDER.comment("If 'False' able inflict damage between mobs of the same type").define("Mobs of the same type cannot cause harm", true);
            this.enableRenderFallingBlock = BUILDER.comment("If 'False' disable falling block rendering").define("Enable falling block rendering", true);
            this.enablePlayBossMusic = BUILDER.comment("If 'False' disable play boss music").define("Enable play boss music", true);
            builder.pop();
        }
    }

    public static class Immortal {
        public final AttributeConfig combatConfig;

        public Immortal(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Boss");
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class NamelessGuardian {
        public final ForgeConfigSpec.BooleanValue enableNonCombatHeal;
        public final ForgeConfigSpec.DoubleValue suckBloodFactor;
        public final ForgeConfigSpec.BooleanValue challengeMode;
        public final AttributeConfig combatConfig;
        public final GeneralDamageCap maximumDamageCap;

        public NamelessGuardian(ForgeConfigSpec.Builder builder) {
            builder.push("Nameless Guardian");
            this.enableNonCombatHeal = BUILDER.comment("If 'False' disable non-combat heal").define("Enable non-combat heal", true);
            this.suckBloodFactor = BUILDER.comment("Max life steal coefficient (based on max health percentage)").defineInRange("Suck blood factor", 0.05, 0.0, 1.0);
            this.challengeMode = BUILDER.comment("Challenge mode!").define("Be careful! It's going to get tricky!", false);
            this.combatConfig = new AttributeConfig();
            this.maximumDamageCap = new GeneralDamageCap(0.05);
            builder.pop();
        }
    }

    public static class CorpseWarlock {
        public final AttributeConfig combatConfig;
        public final GeneralDamageCap maximumDamageCap;

        public CorpseWarlock(ForgeConfigSpec.Builder builder) {
            builder.push("Corpse Warlock");
            this.combatConfig = new AttributeConfig();
            this.maximumDamageCap = new GeneralDamageCap(0.25);
            builder.pop();
        }
    }

    public static class Corpse {
        public final AttributeConfig combatConfig;
        public final ForgeConfigSpec.BooleanValue enableConvertToCorpse;

        public Corpse(ForgeConfigSpec.Builder builder) {
            builder.push("Corpse & Corpse Villager");
            this.combatConfig = new AttributeConfig();
            this.enableConvertToCorpse = BUILDER.comment("If 'False', it will not be converted to corpse").define("Converted to corpse", true);
            builder.pop();
        }
    }

    public static class CorpseMobs {
        public final Corpse CORPSE;
        public final CorpseWarlock CORPSE_WARLOCK;

        public CorpseMobs(ForgeConfigSpec.Builder builder) {
            builder.push("Corpse Mobs");
            this.CORPSE = new Corpse(builder);
            this.CORPSE_WARLOCK = new CorpseWarlock(builder);
            builder.pop();
        }
    }

    public static class ImmortalGolem {
        public final AttributeConfig combatConfig;

        public ImmortalGolem(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Golem");
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class ImmortalShaman {
        public final AttributeConfig combatConfig;
        public final GeneralDamageCap maximumDamageCap;
        public final ForgeConfigSpec.DoubleValue healPercentage;

        public ImmortalShaman(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Shaman");
            this.healPercentage = BUILDER.comment("Immortal Shaman heal values (based on max health percentage)").defineInRange("Heal percentage", 0.5, 0.0, 1.0);
            this.combatConfig = new AttributeConfig();
            this.maximumDamageCap = new GeneralDamageCap(0.25);
            builder.pop();
        }
    }

    public static class ImmortalKnight {
        public final AttributeConfig combatConfig;

        public ImmortalKnight(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Knight");
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class ImmortalSkeleton {
        public final AttributeConfig combatConfig;

        public ImmortalSkeleton(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Skeleton");
            this.combatConfig = new AttributeConfig();
            builder.pop();
        }
    }

    public static class ImmortalMobs {
        public final ImmortalSkeleton IMMORTAL_SKELETON;
        public final ImmortalKnight IMMORTAL_KNIGHT;
        public final ImmortalShaman IMMORTAL_SHAMAN;
        public final ImmortalGolem IMMORTAL_GOLEM;
        public final Immortal THE_IMMORTAL;

        public ImmortalMobs(ForgeConfigSpec.Builder builder) {
            builder.push("Immortal Mobs");
            this.IMMORTAL_SKELETON = new ImmortalSkeleton(builder);
            this.IMMORTAL_KNIGHT = new ImmortalKnight(builder);
            this.IMMORTAL_SHAMAN = new ImmortalShaman(builder);
            this.IMMORTAL_GOLEM = new ImmortalGolem(builder);
            this.THE_IMMORTAL = new Immortal(builder);
            builder.pop();
        }
    }

    public static class Mob {
        public final CorpseMobs CORPSES;
        public final ImmortalMobs IMMORTAL;
        public final NamelessGuardian NAMELESS_GUARDIAN;

        public Mob(ForgeConfigSpec.Builder builder) {
            builder.push("Mobs");
            this.IMMORTAL = new ImmortalMobs(builder);
            this.CORPSES = new CorpseMobs(builder);
            this.NAMELESS_GUARDIAN = new NamelessGuardian(builder);
            builder.pop();
        }
    }

    public static class GuardianLaser {
        public final ForgeConfigSpec.BooleanValue enableGenerateScorchEntity;

        public GuardianLaser(ForgeConfigSpec.Builder builder) {
            builder.push("Guardian Laser");
            this.enableGenerateScorchEntity = BUILDER.comment("If 'False' disable scorch generate on the ground").define("Enable scorch generate", true);
            builder.pop();
        }
    }

    public static class ExperimentalEntity {
        public final GuardianLaser GUARDIAN_LASER;

        public ExperimentalEntity(ForgeConfigSpec.Builder builder) {
            builder.push("Experimental Entity");
            this.GUARDIAN_LASER = new GuardianLaser(builder);
            builder.pop();
        }
    }
}

