/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.capability;

import com.eeeab.eeeabsmobs.client.particle.base.ParticleRing;
import com.eeeab.eeeabsmobs.sever.handler.HandlerCapability;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrenzyCapability {
    public static final ResourceLocation ID = new ResourceLocation("eeeabsmobs", "frenzy_cap");

    public static class FrenzyCapabilityProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        private final LazyOptional<FrenzyCapabilityImpl> instance = LazyOptional.of(FrenzyCapabilityImpl::new);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return HandlerCapability.FRENZY_CAPABILITY_CAPABILITY.orEmpty(cap, this.instance.cast());
        }

        public CompoundTag serializeNBT() {
            return ((FrenzyCapabilityImpl)this.instance.orElseThrow(NullPointerException::new)).serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((FrenzyCapabilityImpl)this.instance.orElseThrow(NullPointerException::new)).deserializeNBT(nbt);
        }
    }

    public static class FrenzyCapabilityImpl
    implements IFrenzyCapability {
        private final UUID ATTACK_UUID = UUID.fromString("3039A932-0AF9-E41C-2DD5-996DCCF1E8A0");
        private final UUID SPEED_UUID = UUID.fromString("CB12110E-C2D2-2E2B-3F2E-97956CB5A564");
        private boolean isFrenzy;
        private long count;
        private int level;

        @Override
        public boolean isFrenzy() {
            return this.isFrenzy;
        }

        @Override
        public void setLevel(int level) {
            this.level = level;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public void onStart(LivingEntity entity) {
            if (entity != null) {
                this.isFrenzy = true;
                AttributeInstance attack = entity.m_21051_(Attributes.f_22281_);
                AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
                if (attack != null && speed != null) {
                    int i = Math.min(this.level + 1, 5);
                    double attackValue = attack.m_22115_() * 0.2 * (double)i;
                    double speedValue = speed.m_22115_() * 0.2 * (double)i;
                    attack.m_22120_(this.ATTACK_UUID);
                    speed.m_22120_(this.SPEED_UUID);
                    attack.m_22118_(new AttributeModifier(this.ATTACK_UUID, "Add frenzy attack", attackValue, AttributeModifier.Operation.ADDITION));
                    speed.m_22118_(new AttributeModifier(this.SPEED_UUID, "Add frenzy speed", speedValue, AttributeModifier.Operation.ADDITION));
                }
            }
        }

        @Override
        public void tick(LivingEntity entity) {
            if (this.isFrenzy()) {
                int duration;
                MobEffectInstance effect = entity.m_21124_((MobEffect)EffectInit.FRENZY_EFFECT.get());
                if (effect != null && (duration = effect.m_19557_()) <= 10 && duration >= 0) {
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200 * (this.level + 1), this.level, false, true, true));
                    entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 200 * (this.level + 1), this.level, false, true, true));
                    entity.m_7292_(new MobEffectInstance((MobEffect)EffectInit.ARMOR_LOWER_EFFECT.get(), 200 * (this.level + 1), this.level, false, true, true));
                    return;
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    this.count = player.m_20142_() ? ++this.count : 0L;
                    if (this.count > 20L) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 20, this.level, false, false, true));
                        if (player.m_9236_().f_46443_) {
                            double x = player.m_20185_();
                            double y = player.m_20186_() + (double)(player.m_20206_() / 2.0f);
                            double z = player.m_20189_();
                            double motionX = player.m_20184_().f_82479_;
                            double motionY = player.m_20184_().f_82480_;
                            double motionZ = player.m_20184_().f_82481_;
                            float yaw = (float)Math.toRadians(-player.m_146908_());
                            float pitch = (float)Math.toRadians(-player.m_146909_());
                            if (player.f_19797_ % 5 == 0) {
                                player.m_9236_().m_7106_((ParticleOptions)new ParticleRing.RingData(yaw, pitch, 60, 0.8f, 0.8f, 0.9f, 0.1f, 40.0f, false, ParticleRing.EnumRingBehavior.GROW_THEN_SHRINK), x + 8.0 * motionX, y + 1.5 * motionY, z + 8.0 * motionZ, 0.0, 0.0, 0.0);
                            }
                        }
                    }
                }
            }
        }

        @Override
        public void onEnd(LivingEntity entity) {
            if (entity != null && this.isFrenzy()) {
                this.isFrenzy = false;
                AttributeInstance attack = entity.m_21051_(Attributes.f_22281_);
                AttributeInstance speed = entity.m_21051_(Attributes.f_22279_);
                if (attack != null && speed != null) {
                    attack.m_22120_(this.ATTACK_UUID);
                    speed.m_22120_(this.SPEED_UUID);
                }
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("is_frenzy", this.isFrenzy);
            nbt.m_128405_("level", this.level);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.isFrenzy = nbt.m_128471_("is_frenzy");
            this.level = nbt.m_128451_("level");
        }
    }

    public static interface IFrenzyCapability
    extends INBTSerializable<CompoundTag> {
        public boolean isFrenzy();

        public void setLevel(int var1);

        public int getLevel();

        public void onStart(LivingEntity var1);

        public void onEnd(LivingEntity var1);

        public void tick(LivingEntity var1);
    }
}

