/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.render.layer;

import com.eeeab.eeeabsmobs.sever.entity.GlowEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerGlow<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    protected final ResourceLocation location;
    protected final GlowPredicate<T> predicate;
    protected final float brightness;

    public LayerGlow(RenderLayerParent<T, M> renderLayerParent, ResourceLocation location) {
        this(renderLayerParent, location, 1.0f, rec$ -> ((GlowEntity)rec$).isGlow());
    }

    public LayerGlow(RenderLayerParent<T, M> renderLayerParent, ResourceLocation location, float brightness) {
        this(renderLayerParent, location, brightness, rec$ -> ((GlowEntity)rec$).isGlow());
    }

    public LayerGlow(RenderLayerParent<T, M> renderLayerParent, ResourceLocation location, float brightness, GlowPredicate<T> predicate) {
        super(renderLayerParent);
        this.location = location;
        this.brightness = brightness;
        this.predicate = predicate;
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int packedLightIn, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.predicate.glow(entity)) {
            float brightness = this.getBrightness(entity);
            this.renderLayer(stack, bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)this.location)), packedLightIn, brightness, brightness, brightness, brightness);
        }
    }

    protected void renderLayer(PoseStack stack, VertexConsumer vertexConsumer, int packedLightIn, float r, float g, float b, float alpha) {
        this.m_117386_().m_7695_(stack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, r, g, b, alpha);
    }

    protected float getBrightness(T entity) {
        return this.brightness;
    }

    @FunctionalInterface
    public static interface GlowPredicate<T> {
        public boolean glow(T var1);
    }
}

