/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.render.effects;

import com.eeeab.eeeabsmobs.sever.entity.projectile.EntityShamanBomb;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class RenderShamanBomb
extends EntityRenderer<EntityShamanBomb> {
    private final float SCALE = 2.0f;
    private static final ResourceLocation N_TEXTURE = new ResourceLocation("eeeabsmobs", "textures/entity/projectile/shaman_bomb.png");
    private static final ResourceLocation D_TEXTURE = new ResourceLocation("eeeabsmobs", "textures/entity/projectile/shaman_bomb_dangerous.png");
    private final RandomSource random = RandomSource.m_216327_();

    public RenderShamanBomb(EntityRendererProvider.Context context) {
        super(context);
    }

    protected int getBlockLightLevel(EntityShamanBomb entity, BlockPos pos) {
        return 15;
    }

    public Vec3 getRenderOffset(EntityShamanBomb entity, float partialTicks) {
        double d0 = 0.005;
        return new Vec3(this.random.m_188583_() * d0, 0.0, this.random.m_188583_() * d0);
    }

    public void render(EntityShamanBomb entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.m_85836_();
        int timer = entity.scaleControlled.getTimer();
        float scale = (float)timer * 0.1f;
        matrixStack.m_85841_(scale, scale, scale);
        matrixStack.m_252781_(this.f_114476_.m_253208_());
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        this.drawCircle(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    private void drawCircle(EntityShamanBomb entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        PoseStack.Pose posestack$pose = matrixStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        VertexConsumer vertexconsumer = !entity.isDangerous() ? buffer.m_6299_(RenderType.m_110458_((ResourceLocation)N_TEXTURE)) : buffer.m_6299_(RenderType.m_110458_((ResourceLocation)D_TEXTURE));
        RenderShamanBomb.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 0, 0, 1);
        RenderShamanBomb.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 0, 1, 1);
        RenderShamanBomb.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 1, 1, 0);
        RenderShamanBomb.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 1, 0, 0);
        matrixStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    private static void vertex(VertexConsumer consumer, Matrix4f matrix4f, Matrix3f matrix3f, int lightMapUV, float x, int y, int u, int v) {
        consumer.m_252986_(matrix4f, x - 0.5f, (float)y - 0.25f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(lightMapUV).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(EntityShamanBomb entity) {
        return entity.isDangerous() ? D_TEXTURE : N_TEXTURE;
    }
}

