/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.particle.util;

import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleComponent;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleRotation;
import com.eeeab.eeeabsmobs.client.render.EMRenderType;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedParticleBase
extends TextureSheetParticle {
    public float airDiffusionSpeed;
    public float red;
    public float green;
    public float blue;
    public float alpha;
    public float prevRed;
    public float prevGreen;
    public float prevBlue;
    public float prevAlpha;
    public float scale;
    public float prevScale;
    public float particleScale;
    public ParticleRotation rotation;
    public boolean emissive;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    public SpriteSet spriteSet;
    public ParticleComponent[] components;

    protected AdvancedParticleBase(ClientLevel worldIn, double pX, double pY, double pZ, double motionX, double motionY, double motionZ, ParticleRotation rotation, double scale, double r, double g, double b, double a, double airDiffusionSpeed, double duration, boolean emissive, boolean canCollide, ParticleComponent[] components, SpriteSet spriteSet) {
        super(worldIn, pX, pY, pZ, 0.0, 0.0, 0.0);
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
        this.alpha = (float)a;
        this.scale = (float)scale;
        this.f_107225_ = (int)duration;
        this.airDiffusionSpeed = (float)airDiffusionSpeed;
        this.rotation = rotation;
        this.components = components;
        this.emissive = emissive;
        for (ParticleComponent component : components) {
            component.init(this);
        }
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.prevRed = this.red;
        this.prevGreen = this.green;
        this.prevBlue = this.blue;
        this.prevAlpha = this.alpha;
        this.rotation.setPrevValues();
        this.prevScale = this.scale;
        this.f_107219_ = canCollide;
        this.spriteSet = spriteSet;
    }

    public ParticleRenderType m_7556_() {
        return EMRenderType.PARTICLE_SHEET_TRANSLUCENT_NO_DEPTH;
    }

    public int m_6355_(float partialTick) {
        int i = super.m_6355_(partialTick);
        if (this.emissive) {
            int k = i >> 16 & 0xFF;
            return 0xF0 | k << 16;
        }
        return i;
    }

    public void m_5989_() {
        this.prevRed = this.red;
        this.prevGreen = this.green;
        this.prevBlue = this.blue;
        this.prevAlpha = this.alpha;
        this.prevScale = this.scale;
        this.rotation.setPrevValues();
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.prevMotionX = this.f_107215_;
        this.prevMotionY = this.f_107216_;
        this.prevMotionZ = this.f_107217_;
        for (ParticleComponent component : this.components) {
            component.preUpdate(this);
        }
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else if (this.spriteSet != null) {
            this.m_108339_(this.spriteSet);
        }
        this.updatePosition();
        for (ParticleComponent component : this.components) {
            component.postUpdate(this);
        }
    }

    protected void updatePosition() {
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (this.f_107218_ && this.f_107219_) {
            this.f_107215_ *= (double)0.7f;
            this.f_107217_ *= (double)0.7f;
        }
        this.f_107215_ *= (double)this.airDiffusionSpeed;
        this.f_107216_ *= (double)this.airDiffusionSpeed;
        this.f_107217_ *= (double)this.airDiffusionSpeed;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        this.alpha = this.prevAlpha + (this.alpha - this.prevAlpha) * partialTicks;
        if ((double)this.alpha < 0.01) {
            this.alpha = 0.01f;
        }
        this.f_107227_ = this.prevRed + (this.red - this.prevRed) * partialTicks;
        this.f_107228_ = this.prevGreen + (this.green - this.prevGreen) * partialTicks;
        this.f_107229_ = this.prevBlue + (this.blue - this.prevBlue) * partialTicks;
        this.particleScale = this.prevScale + (this.scale - this.prevScale) * partialTicks;
        for (ParticleComponent component : this.components) {
            component.preRender(this, partialTicks);
        }
        Vec3 Vector3d = renderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - Vector3d.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - Vector3d.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - Vector3d.m_7094_());
        Quaternionf quaternion = new Quaternionf();
        ParticleRotation particleRotation = this.rotation;
        if (particleRotation instanceof ParticleRotation.FaceCamera) {
            ParticleRotation.FaceCamera faceCameraRot = (ParticleRotation.FaceCamera)particleRotation;
            if (faceCameraRot.faceCameraAngle == 0.0f && faceCameraRot.prevFaceCameraAngle == 0.0f) {
                quaternion = renderInfo.m_253121_();
            } else {
                quaternion = new Quaternionf((Quaternionfc)renderInfo.m_253121_());
                quaternion.rotateZ(Mth.m_14179_((float)partialTicks, (float)faceCameraRot.prevFaceCameraAngle, (float)faceCameraRot.faceCameraAngle));
            }
        } else {
            particleRotation = this.rotation;
            if (particleRotation instanceof ParticleRotation.EulerAngles) {
                ParticleRotation.EulerAngles eulerRot = (ParticleRotation.EulerAngles)particleRotation;
                float rotX = eulerRot.prevPitch + (eulerRot.pitch - eulerRot.prevPitch) * partialTicks;
                float rotY = eulerRot.prevYaw + (eulerRot.yaw - eulerRot.prevYaw) * partialTicks;
                float rotZ = eulerRot.prevRoll + (eulerRot.roll - eulerRot.prevRoll) * partialTicks;
                Quaternionf quaternionf = new Quaternionf();
                Quaternionf quatX = new Quaternionf((Quaternionfc)quaternionf.rotateZYX(rotX, 0.0f, 0.0f));
                Quaternionf quatY = new Quaternionf((Quaternionfc)quaternionf.rotateZYX(0.0f, rotY, 0.0f));
                Quaternionf quatZ = new Quaternionf((Quaternionfc)quaternionf.rotateZYX(0.0f, 0.0f, rotZ));
                quaternion.mul((Quaternionfc)quatZ);
                quaternion.mul((Quaternionfc)quatY);
                quaternion.mul((Quaternionfc)quatX);
            } else {
                ParticleRotation rotX = this.rotation;
                if (rotX instanceof ParticleRotation.OrientVector) {
                    ParticleRotation.OrientVector orientRot = (ParticleRotation.OrientVector)rotX;
                    double x = orientRot.prevOrientation.f_82479_ + (orientRot.orientation.f_82479_ - orientRot.prevOrientation.f_82479_) * (double)partialTicks;
                    double y = orientRot.prevOrientation.f_82480_ + (orientRot.orientation.f_82480_ - orientRot.prevOrientation.f_82480_) * (double)partialTicks;
                    double z = orientRot.prevOrientation.f_82481_ + (orientRot.orientation.f_82481_ - orientRot.prevOrientation.f_82481_) * (double)partialTicks;
                    float pitch = (float)Math.asin(-y);
                    float yaw = (float)Mth.m_14136_((double)x, (double)z);
                    Quaternionf quaternionf = new Quaternionf();
                    Quaternionf quatX = new Quaternionf((Quaternionfc)quaternionf.rotateZYX(pitch, 0.0f, 0.0f));
                    Quaternionf quatY = new Quaternionf((Quaternionfc)quaternionf.rotateZYX(0.0f, yaw, 0.0f));
                    quaternion.mul((Quaternionfc)quatY);
                    quaternion.mul((Quaternionfc)quatX);
                }
            }
        }
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = this.particleScale * 0.1f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = this.m_5970_();
        float f8 = this.m_5952_();
        float f5 = this.m_5951_();
        float f6 = this.m_5950_();
        int j = this.m_6355_(partialTicks);
        buffer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.alpha).m_85969_(j).m_5752_();
        for (ParticleComponent component : this.components) {
            component.postRender(this, buffer, renderInfo, partialTicks, j);
        }
    }

    public float getAge() {
        return this.f_107224_;
    }

    public double getPosX() {
        return this.f_107212_;
    }

    public void setPosX(double posX) {
        this.m_107264_(posX, this.f_107213_, this.f_107214_);
    }

    public double getPosY() {
        return this.f_107213_;
    }

    public void setPosY(double posY) {
        this.m_107264_(this.f_107212_, posY, this.f_107214_);
    }

    public double getPosZ() {
        return this.f_107214_;
    }

    public void setPosZ(double posZ) {
        this.m_107264_(this.f_107212_, this.f_107213_, posZ);
    }

    public double getMotionX() {
        return this.f_107215_;
    }

    public void setMotionX(double motionX) {
        this.f_107215_ = motionX;
    }

    public double getMotionY() {
        return this.f_107216_;
    }

    public void setMotionY(double motionY) {
        this.f_107216_ = motionY;
    }

    public double getMotionZ() {
        return this.f_107217_;
    }

    public void setMotionZ(double motionZ) {
        this.f_107217_ = motionZ;
    }

    public Vec3 getPrevPos() {
        return new Vec3(this.f_107209_, this.f_107210_, this.f_107211_);
    }

    public double getPrevPosX() {
        return this.f_107209_;
    }

    public double getPrevPosY() {
        return this.f_107210_;
    }

    public double getPrevPosZ() {
        return this.f_107211_;
    }

    public Level getWorld() {
        return this.f_107208_;
    }

    public static void spawnParticle(Level level, ParticleType<AdvancedParticleData> particle, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double faceCameraAngle, double scale, double r, double g, double b, double a, double airDiffusionSpeed, double duration, boolean emissive, boolean canCollide, boolean isAnimation, ParticleComponent[] components) {
        ParticleRotation rotation = faceCamera ? new ParticleRotation.FaceCamera((float)faceCameraAngle) : new ParticleRotation.EulerAngles((float)yaw, (float)pitch, (float)roll);
        level.m_7106_((ParticleOptions)new AdvancedParticleData(particle, rotation, scale, r, g, b, a, airDiffusionSpeed, duration, emissive, canCollide, components, isAnimation), x, y, z, motionX, motionY, motionZ);
    }

    public static void spawnEmptyComponentParticle(Level level, ParticleType<AdvancedParticleData> particle, double x, double y, double z, double motionX, double motionY, double motionZ, boolean faceCamera, double yaw, double pitch, double roll, double faceCameraAngle, double scale, double r, double g, double b, double a, double airDiffusionSpeed, double duration, boolean emissive, boolean canCollide, boolean isAnimation) {
        AdvancedParticleBase.spawnParticle(level, particle, x, y, z, motionX, motionY, motionZ, faceCamera, yaw, pitch, roll, faceCameraAngle, scale, r, g, b, a, airDiffusionSpeed, duration, emissive, canCollide, isAnimation, new ParticleComponent[0]);
    }

    public static void spawnCustomRotationParticle(Level level, ParticleType<AdvancedParticleData> particle, double x, double y, double z, double motionX, double motionY, double motionZ, ParticleRotation rotation, double scale, double r, double g, double b, double a, double airDiffusionSpeed, double duration, boolean emissive, boolean canCollide, ParticleComponent[] components, boolean isAnimation) {
        level.m_7106_((ParticleOptions)new AdvancedParticleData(particle, rotation, scale, r, g, b, a, airDiffusionSpeed, duration, emissive, canCollide, components, isAnimation), x, y, z, motionX, motionY, motionZ);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<AdvancedParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet sprite) {
            this.spriteSet = sprite;
        }

        public Particle createParticle(AdvancedParticleData typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            AdvancedParticleBase particle;
            if (typeIn.isAnimation()) {
                particle = new AdvancedParticleBase(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getRotation(), typeIn.getScale(), typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue(), typeIn.getAlpha(), typeIn.getAirDiffusionSpeed(), typeIn.getDuration(), typeIn.isEmissive(), typeIn.getCanCollide(), typeIn.getComponents(), this.spriteSet);
                particle.m_108339_(this.spriteSet);
            } else {
                particle = new AdvancedParticleBase(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, typeIn.getRotation(), typeIn.getScale(), typeIn.getRed(), typeIn.getGreen(), typeIn.getBlue(), typeIn.getAlpha(), typeIn.getAirDiffusionSpeed(), typeIn.getDuration(), typeIn.isEmissive(), typeIn.getCanCollide(), typeIn.getComponents(), null);
                particle.m_108335_(this.spriteSet);
            }
            particle.m_107253_((float)typeIn.getRed(), (float)typeIn.getGreen(), (float)typeIn.getBlue());
            return particle;
        }
    }
}

