/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.compile.tasks;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBufferSorter;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderCache;
import me.jellysquid.mods.sodium.client.render.chunk.compile.pipeline.BlockRenderContext;
import me.jellysquid.mods.sodium.client.render.chunk.compile.tasks.ChunkBuilderTask;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionInfo;
import me.jellysquid.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import me.jellysquid.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import me.jellysquid.mods.sodium.client.util.task.CancellationToken;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.embeddedt.embeddium.api.ChunkDataBuiltEvent;
import org.embeddedt.embeddium.chunk.MeshAppenderRenderer;
import org.embeddedt.embeddium.model.ModelDataSnapshotter;

public class ChunkBuilderMeshingTask
extends ChunkBuilderTask<ChunkBuildOutput> {
    private final RandomSource random = new SingleThreadedRandomSource(42L);
    private final RenderSection render;
    private final ChunkRenderContext renderContext;
    private final int buildTime;
    private final Map<BlockPos, ModelData> modelDataMap;
    private Vec3 camera = Vec3.f_82478_;

    public ChunkBuilderMeshingTask(RenderSection render, ChunkRenderContext renderContext, int time) {
        this.render = render;
        this.renderContext = renderContext;
        this.buildTime = time;
        this.modelDataMap = ModelDataSnapshotter.getModelDataForSection(Minecraft.m_91087_().f_91073_, this.renderContext.getOrigin());
    }

    public ChunkBuilderMeshingTask withCameraPosition(Vec3 camera) {
        this.camera = camera;
        return this;
    }

    @Override
    public ChunkBuildOutput execute(ChunkBuildContext buildContext, CancellationToken cancellationToken) {
        BuiltSectionInfo.Builder renderData = new BuiltSectionInfo.Builder();
        VisGraph occluder = new VisGraph();
        ChunkBuildBuffers buffers = buildContext.buffers;
        buffers.init(renderData, this.render.getSectionIndex());
        BlockRenderCache cache = buildContext.cache;
        cache.init(this.renderContext);
        WorldSlice slice = cache.getWorldSlice();
        int minX = this.render.getOriginX();
        int minY = this.render.getOriginY();
        int minZ = this.render.getOriginZ();
        int maxX = minX + 16;
        int maxY = minY + 16;
        int maxZ = minZ + 16;
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(minX, minY, minZ);
        BlockPos.MutableBlockPos modelOffset = new BlockPos.MutableBlockPos();
        BlockRenderContext context = new BlockRenderContext(slice);
        try {
            for (int y = minY; y < maxY; ++y) {
                if (cancellationToken.isCancelled()) {
                    return null;
                }
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        BlockEntityRenderer renderer;
                        BlockEntity entity;
                        FluidState fluidState;
                        BlockState blockState = slice.getBlockState(x, y, z);
                        if (blockState.m_60795_() && !blockState.m_155947_()) continue;
                        blockPos.m_122178_(x, y, z);
                        modelOffset.m_122178_(x & 0xF, y & 0xF, z & 0xF);
                        if (blockState.m_60799_() == RenderShape.MODEL) {
                            BakedModel model = cache.getBlockModels().m_110893_(blockState);
                            ModelData modelData = model.getModelData((BlockAndTintGetter)context.localSlice(), (BlockPos)blockPos, blockState, this.modelDataMap.getOrDefault(blockPos, ModelData.EMPTY));
                            long seed = blockState.m_60726_((BlockPos)blockPos);
                            this.random.m_188584_(seed);
                            for (RenderType layer : model.getRenderTypes(blockState, this.random, modelData)) {
                                context.update((BlockPos)blockPos, (BlockPos)modelOffset, blockState, model, seed, modelData, layer);
                                cache.getBlockRenderer().renderModel(context, buffers);
                            }
                        }
                        if (!(fluidState = blockState.m_60819_()).m_76178_()) {
                            cache.getFluidRenderer().render(slice, fluidState, (BlockPos)blockPos, (BlockPos)modelOffset, buffers);
                        }
                        if (blockState.m_155947_() && (entity = slice.m_7702_((BlockPos)blockPos)) != null && (renderer = Minecraft.m_91087_().m_167982_().m_112265_(entity)) != null) {
                            renderData.addBlockEntity(entity, !renderer.m_5932_(entity));
                        }
                        if (!blockState.m_60804_((BlockGetter)slice, (BlockPos)blockPos)) continue;
                        occluder.m_112971_((BlockPos)blockPos);
                    }
                }
            }
            MeshAppenderRenderer.renderMeshAppenders(this.renderContext.getMeshAppenders(), context.localSlice(), this.renderContext.getOrigin(), buffers);
        }
        catch (ReportedException ex) {
            throw this.fillCrashInfo(ex.m_134761_(), slice, (BlockPos)blockPos);
        }
        catch (Throwable ex) {
            throw this.fillCrashInfo(CrashReport.m_127521_((Throwable)ex, (String)"Encountered exception while building chunk meshes"), slice, (BlockPos)blockPos);
        }
        Reference2ReferenceOpenHashMap meshes = new Reference2ReferenceOpenHashMap();
        for (TerrainRenderPass pass : DefaultTerrainRenderPasses.ALL) {
            BuiltSectionMeshParts mesh = buffers.createMesh(pass);
            if (mesh == null) continue;
            if (pass.isReverseOrder() && SodiumClientMod.options().performance.useTranslucentFaceSorting) {
                ChunkBufferSorter.sort(new ChunkBufferSorter.SortBuffer(mesh.getVertexData().getDirectBuffer(), buffers.getVertexType(), mesh.getVertexRanges()), (float)this.camera.f_82479_ - (float)minX, (float)this.camera.f_82480_ - (float)minY, (float)this.camera.f_82481_ - (float)minZ);
            }
            meshes.put(pass, mesh);
            renderData.addRenderPass(pass);
        }
        renderData.setOcclusionData(occluder.m_112958_());
        MinecraftForge.EVENT_BUS.post((Event)new ChunkDataBuiltEvent(renderData));
        return new ChunkBuildOutput(this.render, renderData.build(), (Map<TerrainRenderPass, BuiltSectionMeshParts>)meshes, this.buildTime);
    }

    private ReportedException fillCrashInfo(CrashReport report, WorldSlice slice, BlockPos pos) {
        CrashReportCategory crashReportSection = report.m_127516_("Block being rendered", 1);
        BlockState state = null;
        try {
            state = slice.m_8055_(pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CrashReportCategory.m_178950_((CrashReportCategory)crashReportSection, (LevelHeightAccessor)slice, (BlockPos)pos, (BlockState)state);
        crashReportSection.m_128159_("Chunk section", (Object)this.render);
        if (this.renderContext != null) {
            crashReportSection.m_128159_("Render context volume", (Object)this.renderContext.getVolume());
        }
        return new ReportedException(report);
    }
}

