/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.forge;

import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.anti_ad.mc.common.input.GlobalInputHandler;
import org.anti_ad.mc.common.input.GlobalScreenEventListener;
import org.anti_ad.mc.common.vanilla.Vanilla;

public class CommonForgeEventHandler {
    private int lastMods = 0;

    @SubscribeEvent
    public void onKeyLast(InputEvent.Key event) {
        if (Vanilla.INSTANCE.screen() == null) {
            GlobalInputHandler.INSTANCE.onKey(event.getKey(), event.getScanCode(), event.getAction(), event.getModifiers(), true, 0L);
        }
    }

    @SubscribeEvent
    public void onKeyPressed(ScreenEvent.KeyPressed.Pre event) {
        this.onScreenKey(event.getKeyCode(), event.getScanCode(), 1, event.getModifiers(), (ScreenEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyPressed(event.getKeyCode(), event.getScanCode(), event.getModifiers(), true));
    }

    @SubscribeEvent
    public void onKeyRelease(ScreenEvent.KeyReleased.Pre event) {
        this.onScreenKey(event.getKeyCode(), event.getScanCode(), 0, event.getModifiers(), (ScreenEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyReleased(event.getKeyCode(), event.getScanCode(), event.getModifiers(), true));
    }

    @SubscribeEvent
    public void onKeyPressedPost(ScreenEvent.KeyPressed.Post event) {
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyPressed(event.getKeyCode(), event.getScanCode(), event.getModifiers(), false));
    }

    @SubscribeEvent
    public void onKeyReleasePost(ScreenEvent.KeyReleased.Post event) {
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onKeyReleased(event.getKeyCode(), event.getScanCode(), event.getModifiers(), false));
    }

    private void onScreenKey(int key, int scanCode, int action, int modifiers, ScreenEvent event) {
        Screen lastScreen = Vanilla.INSTANCE.screen();
        long handle = Vanilla.INSTANCE.window().m_85439_();
        boolean result = GlobalInputHandler.INSTANCE.onKey(key, scanCode, action, modifiers, true, handle);
        event.setCanceled(result || lastScreen != Vanilla.INSTANCE.screen());
    }

    @SubscribeEvent
    public void onMouseButtonLast(InputEvent.MouseButton.Post event) {
        if (Vanilla.INSTANCE.screen() == null) {
            GlobalInputHandler.INSTANCE.onMouseButton(event.getButton(), event.getAction(), event.getModifiers());
        }
    }

    @SubscribeEvent
    public void onMouseClicked(ScreenEvent.MouseButtonPressed.Pre event) {
        this.onScreenMouseButton(event.getButton(), 1, this.lastMods, (ScreenEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onMouseClicked(event.getMouseX(), event.getMouseY(), event.getButton(), true));
    }

    @SubscribeEvent
    public void onMouseReleased(ScreenEvent.MouseButtonReleased.Pre event) {
        this.onScreenMouseButton(event.getButton(), 0, this.lastMods, (ScreenEvent)event);
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(GlobalScreenEventListener.INSTANCE.onMouseReleased(event.getMouseX(), event.getMouseY(), event.getButton(), true));
    }

    @SubscribeEvent
    public void onMouseClickedPost(ScreenEvent.MouseButtonPressed.Post event) {
        GlobalScreenEventListener.INSTANCE.onMouseClicked(event.getMouseX(), event.getMouseY(), event.getButton(), false);
    }

    @SubscribeEvent
    public void onMouseReleasedPost(ScreenEvent.MouseButtonReleased.Post event) {
        GlobalScreenEventListener.INSTANCE.onMouseReleased(event.getMouseX(), event.getMouseY(), event.getButton(), false);
    }

    private void onScreenMouseButton(int button2, int action, int mods, ScreenEvent event) {
        Screen lastScreen = Vanilla.INSTANCE.screen();
        boolean result = GlobalInputHandler.INSTANCE.onMouseButton(button2, action, mods);
        event.setCanceled(result || lastScreen != Vanilla.INSTANCE.screen());
    }

    @SubscribeEvent
    public void onRawMouse(InputEvent.MouseButton.Pre event) {
        this.lastMods = event.getModifiers();
    }

    @SubscribeEvent
    public void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        double delta = event.getScrollDelta();
        if (delta != 0.0) {
            event.setCanceled(CommonForgeEventHandler.processScrollEvent(delta));
        }
    }

    @SubscribeEvent
    public void onGuiMouseScroll(ScreenEvent.MouseScrolled.Pre event) {
        double delta = event.getScrollDelta();
        if (delta != 0.0) {
            Screen lastScreen = Vanilla.INSTANCE.screen();
            int button2 = delta > 0.0 ? -10000 : -10001;
            boolean result = CommonForgeEventHandler.processScrollEvent(delta);
            result = GlobalScreenEventListener.INSTANCE.onMouseClicked(event.getMouseX(), event.getMouseY(), button2, true) || result;
            result = GlobalScreenEventListener.INSTANCE.onMouseReleased(event.getMouseX(), event.getMouseY(), button2, true) || result;
            event.setCanceled(result || lastScreen != Vanilla.INSTANCE.screen());
        }
    }

    private static boolean processScrollEvent(double delta) {
        int button2 = delta > 0.0 ? -10000 : -10001;
        boolean result = GlobalInputHandler.INSTANCE.onMouseButton(button2, 1, 0);
        result = GlobalInputHandler.INSTANCE.onMouseButton(button2, 0, 0) | result;
        return result;
    }
}

