/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StatTask
extends Task {
    private ResourceLocation stat = Stats.f_12936_;
    private int value = 1;

    public StatTask(long id, Quest quest) {
        super(id, quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.STAT;
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public String formatMaxProgress() {
        return Integer.toString(this.value);
    }

    @Override
    public String formatProgress(TeamData teamData, long progress) {
        return Long.toUnsignedString(progress);
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("stat", this.stat.toString());
        nbt.m_128405_("value", this.value);
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.stat = new ResourceLocation(nbt.m_128461_("stat"));
        this.value = nbt.m_128451_("value");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130085_(this.stat);
        buffer.m_130130_(this.value);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.stat = buffer.m_130281_();
        this.value = buffer.m_130242_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        ArrayList list = new ArrayList();
        Stats.f_12988_.iterator().forEachRemaining(s -> list.add((ResourceLocation)s.m_12867_()));
        config.addEnum("stat", (Object)this.stat, v -> {
            this.stat = v;
        }, NameMap.of((Object)Stats.f_12936_, list).name(v -> Component.m_237115_((String)("stat." + v.m_135827_() + "." + v.m_135815_()))).create());
        config.addInt("value", this.value, v -> {
            this.value = v;
        }, 1, 1, Integer.MAX_VALUE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)("stat." + this.stat.m_135827_() + "." + this.stat.m_135815_()));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 3;
    }

    @Override
    public void submitTask(TeamData teamData, ServerPlayer player, ItemStack craftedItem) {
        int set;
        if (teamData.isCompleted(this)) {
            return;
        }
        ResourceLocation statId = (ResourceLocation)BuiltInRegistries.f_256771_.m_7745_(this.stat);
        if (statId == null) {
            statId = (ResourceLocation)BuiltInRegistries.f_256771_.m_7745_(new ResourceLocation(this.stat.m_135815_()));
        }
        if (statId != null && (long)(set = Math.min(this.value, player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)statId)))) > teamData.getProgress(this)) {
            teamData.setProgress(this, set);
        }
    }
}

