/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.ConfigIconItemStack;
import dev.ftb.mods.ftbquests.integration.RecipeModHelper;
import dev.ftb.mods.ftbquests.item.CustomIconItem;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.BaseQuestFile;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import dev.ftb.mods.ftbquests.util.NetUtils;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import dev.ftb.mods.ftbquests.util.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class QuestObjectBase {
    private static final Pattern TAG_PATTERN = Pattern.compile("^[a-z0-9_]*$");
    private static Tristate sendNotifications = Tristate.DEFAULT;
    public final long id;
    protected boolean invalid = false;
    protected String rawTitle = "";
    private ItemStack rawIcon = ItemStack.f_41583_;
    private List<String> tags = new ArrayList<String>(0);
    private Icon cachedIcon = null;
    private Component cachedTitle = null;
    private Set<String> cachedTags = null;

    public QuestObjectBase(long id) {
        this.id = id;
    }

    public static boolean isNull(@Nullable QuestObjectBase object) {
        return object == null || object.invalid;
    }

    public static long getID(@Nullable QuestObjectBase object) {
        return QuestObjectBase.isNull(object) ? 0L : object.id;
    }

    public static String getCodeString(long id) {
        return String.format("%016X", id);
    }

    public static String getCodeString(@Nullable QuestObjectBase object) {
        return QuestObjectBase.getCodeString(QuestObjectBase.getID(object));
    }

    public static boolean shouldSendNotifications() {
        return sendNotifications.get(true);
    }

    public final boolean isValid() {
        return !this.invalid;
    }

    public final void setRawIcon(ItemStack rawIcon) {
        this.rawIcon = rawIcon;
    }

    public final String getRawTitle() {
        return this.rawTitle;
    }

    public final void setRawTitle(String rawTitle) {
        this.rawTitle = rawTitle;
    }

    public static long parseCodeString(String id) {
        if (id.isEmpty() || id.equals("-")) {
            return 0L;
        }
        try {
            return Long.parseLong(id.charAt(0) == '#' ? id.substring(1) : id, 16);
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public static Optional<String> titleToID(String s) {
        s = s.replace(' ', '_').replaceAll("\\W", "").toLowerCase().trim();
        while (s.startsWith("_")) {
            s = s.substring(1);
        }
        while (s.endsWith("_")) {
            s = s.substring(0, s.length() - 1);
        }
        return s.isEmpty() ? Optional.empty() : Optional.of(s);
    }

    public final String getCodeString() {
        return QuestObjectBase.getCodeString(this.id);
    }

    public final String toString() {
        return this.getCodeString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return Long.hashCode(this.id);
    }

    public abstract QuestObjectType getObjectType();

    public abstract BaseQuestFile getQuestFile();

    public Set<String> getTags() {
        if (this.tags.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.cachedTags == null) {
            this.cachedTags = new LinkedHashSet<String>(this.tags);
        }
        return this.cachedTags;
    }

    public boolean hasTag(String tag) {
        return !this.tags.isEmpty() && this.getTags().contains(tag);
    }

    public void forceProgress(TeamData teamData, ProgressChange progressChange) {
    }

    public final void forceProgressRaw(TeamData teamData, ProgressChange progressChange) {
        if (teamData.isLocked()) {
            return;
        }
        teamData.clearCachedProgress();
        sendNotifications = progressChange.shouldNotify() ? Tristate.TRUE : Tristate.FALSE;
        this.forceProgress(teamData, progressChange);
        sendNotifications = Tristate.DEFAULT;
        teamData.clearCachedProgress();
        teamData.markDirty();
    }

    @Nullable
    public Chapter getQuestChapter() {
        return null;
    }

    public long getParentID() {
        return 1L;
    }

    public void writeData(CompoundTag nbt) {
        if (!this.rawTitle.isEmpty()) {
            nbt.m_128359_("title", this.rawTitle);
        }
        NBTUtils.write(nbt, "icon", this.rawIcon);
        if (!this.tags.isEmpty()) {
            ListTag tagList = new ListTag();
            for (String s : this.tags) {
                tagList.add((Object)StringTag.m_129297_((String)s));
            }
            nbt.m_128365_("tags", (Tag)tagList);
        }
    }

    public void readData(CompoundTag nbt) {
        this.rawTitle = nbt.m_128461_("title");
        this.rawIcon = NBTUtils.read(nbt, "icon");
        ListTag tagsList = nbt.m_128437_("tags", 8);
        this.tags = new ArrayList<String>(tagsList.size());
        for (int i = 0; i < tagsList.size(); ++i) {
            this.tags.add(tagsList.m_128778_(i));
        }
        if (nbt.m_128441_("custom_id")) {
            this.tags.add(nbt.m_128461_("custom_id"));
        }
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (!this.rawTitle.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)2, (!this.rawIcon.m_41619_() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)4, (!this.tags.isEmpty() ? 1 : 0) != 0);
        buffer.m_130130_(flags);
        if (!this.rawTitle.isEmpty()) {
            buffer.m_130072_(this.rawTitle, Short.MAX_VALUE);
        }
        if (!this.rawIcon.m_41619_()) {
            buffer.m_130055_(this.rawIcon);
        }
        if (!this.tags.isEmpty()) {
            NetUtils.writeStrings(buffer, this.tags);
        }
    }

    public void readNetData(FriendlyByteBuf buffer) {
        int flags = buffer.m_130242_();
        this.rawTitle = Bits.getFlag((int)flags, (int)1) ? buffer.m_130136_(Short.MAX_VALUE) : "";
        this.rawIcon = Bits.getFlag((int)flags, (int)2) ? buffer.m_130267_() : ItemStack.f_41583_;
        this.tags = new ArrayList<String>(0);
        if (Bits.getFlag((int)flags, (int)4)) {
            NetUtils.readStrings(buffer, this.tags);
        }
    }

    protected boolean hasTitleConfig() {
        return true;
    }

    protected boolean hasIconConfig() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        if (this.hasTitleConfig()) {
            config.addString("title", this.rawTitle, v -> {
                this.rawTitle = v;
            }, "").setNameKey("ftbquests.title").setOrder(-127);
        }
        if (this.hasIconConfig()) {
            ((ConfigIconItemStack)config.add("icon", (ConfigValue)new ConfigIconItemStack(), (Object)this.rawIcon, v -> {
                this.rawIcon = v;
            }, (Object)ItemStack.f_41583_)).setNameKey("ftbquests.icon").setOrder(-126);
        }
        config.addList("tags", this.tags, (ConfigValue)new StringConfig(TAG_PATTERN), (Object)"").setNameKey("ftbquests.tags").setOrder(-125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract Component getAltTitle();

    @OnlyIn(value=Dist.CLIENT)
    public abstract Icon getAltIcon();

    @OnlyIn(value=Dist.CLIENT)
    public final Component getTitle() {
        if (this.cachedTitle != null) {
            return this.cachedTitle.m_6881_();
        }
        this.cachedTitle = !this.rawTitle.isEmpty() ? TextUtils.parseRawText(this.rawTitle) : this.getAltTitle();
        return this.cachedTitle.m_6881_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public final MutableComponent getMutableTitle() {
        return this.getTitle().m_6881_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public final Icon getIcon() {
        if (this.cachedIcon == null) {
            if (!this.rawIcon.m_41619_()) {
                this.cachedIcon = CustomIconItem.getIcon(this.rawIcon);
            }
            if (this.cachedIcon == null || this.cachedIcon.isEmpty()) {
                this.cachedIcon = (Icon)ThemeProperties.ICON.get(this);
            }
            if (this.cachedIcon.isEmpty()) {
                this.cachedIcon = this.getAltIcon();
            }
        }
        return this.cachedIcon;
    }

    public void deleteSelf() {
        this.getQuestFile().remove(this.id);
    }

    public void deleteChildren() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void editedFromGUI() {
        ClientQuestFile.INSTANCE.refreshGui();
    }

    public void editedFromGUIOnServer() {
    }

    public void onCreated() {
    }

    public Optional<String> getPath() {
        return Optional.empty();
    }

    public void clearCachedData() {
        this.cachedIcon = null;
        this.cachedTitle = null;
        this.cachedTags = null;
    }

    public ConfigGroup createSubGroup(ConfigGroup group) {
        return group.getOrCreateSubgroup(this.getObjectType().getId());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onEditButtonClicked(Runnable gui) {
        ConfigGroup group = new ConfigGroup("ftbquests", accepted -> {
            gui.run();
            if (accepted && this.validateEditedConfig()) {
                new EditObjectMessage(this).sendToServer();
            }
        });
        this.fillConfigGroup(this.createSubGroup(group));
        new EditConfigScreen(group).openGui();
    }

    protected boolean validateEditedConfig() {
        return true;
    }

    public Set<RecipeModHelper.Components> componentsToRefresh() {
        return EnumSet.noneOf(RecipeModHelper.Components.class);
    }

    public static <T extends QuestObjectBase> T copy(T orig, Supplier<T> factory) {
        QuestObjectBase copied = (QuestObjectBase)factory.get();
        if (copied == null) {
            return null;
        }
        CompoundTag tag = new CompoundTag();
        orig.writeData(tag);
        copied.readData(tag);
        return (T)copied;
    }
}

