/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.BrewConfig;
import com.Polarice3.Goety.Goety;
import com.Polarice3.Goety.MainConfig;
import com.Polarice3.Goety.api.entities.IOwned;
import com.Polarice3.Goety.api.items.armor.ISoulDiscount;
import com.Polarice3.Goety.api.items.magic.ITotem;
import com.Polarice3.Goety.common.capabilities.soulenergy.FocusCooldown;
import com.Polarice3.Goety.common.capabilities.soulenergy.ISoulEnergy;
import com.Polarice3.Goety.common.capabilities.soulenergy.SEImp;
import com.Polarice3.Goety.common.capabilities.soulenergy.SEProvider;
import com.Polarice3.Goety.common.capabilities.soulenergy.SEUpdatePacket;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.util.SurveyEye;
import com.Polarice3.Goety.common.events.ArcaTeleporter;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.ModTiers;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import com.Polarice3.Goety.common.research.Research;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.compat.minecolonies.MinecoloniesLoaded;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.TotemFinder;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCameraPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import org.slf4j.Logger;

public class SEHelper {
    public static ISoulEnergy getCapability(Player player) {
        return (ISoulEnergy)player.getCapability(SEProvider.CAPABILITY).orElse((Object)new SEImp());
    }

    public static boolean getSEActive(Player player) {
        return SEHelper.getCapability(player).getSEActive();
    }

    public static void setSEActive(Player player, boolean active) {
        SEHelper.getCapability(player).setSEActive(active);
    }

    public static int getSESouls(Player player) {
        return SEHelper.getCapability(player).getSoulEnergy();
    }

    public static void setSESouls(Player player, int souls) {
        SEHelper.getCapability(player).setSoulEnergy(souls);
    }

    public static void setSoulsAmount(Player player, int souls) {
        if (SEHelper.getSEActive(player)) {
            SEHelper.setSESouls(player, souls);
            SEHelper.sendSEUpdatePacket(player);
        } else if (!TotemFinder.FindTotem(player).m_41619_()) {
            ITotem.setSoulsamount(TotemFinder.FindTotem(player), souls);
        }
    }

    public static BlockPos getArcaBlock(Player player) {
        return SEHelper.getCapability(player).getArcaBlock();
    }

    public static ResourceKey<Level> getArcaDimension(Player player) {
        return SEHelper.getCapability(player).getArcaBlockDimension();
    }

    public static void setEndWalk(Player player, @Nullable BlockPos blockPos, @Nullable ResourceKey<Level> dimension) {
        SEHelper.getCapability(player).setEndWalkPos(blockPos);
        SEHelper.getCapability(player).setEndWalkDimension(dimension);
    }

    public static void removeEndWalk(Player player) {
        SEHelper.setEndWalk(player, null, null);
    }

    @Nullable
    public static BlockPos getEndWalkPos(Player player) {
        return SEHelper.getCapability(player).getEndWalkPos();
    }

    @Nullable
    public static ResourceKey<Level> getEndWalkDimension(Player player) {
        return SEHelper.getCapability(player).getEndWalkDimension();
    }

    public static boolean hasEndWalk(Player player) {
        return SEHelper.getEndWalkPos(player) != null;
    }

    public static boolean decreaseSESouls(Player player, int souls) {
        return SEHelper.getCapability(player).decreaseSE(souls);
    }

    public static boolean increaseSESouls(Player player, int souls) {
        return SEHelper.getCapability(player).increaseSE(souls);
    }

    public static boolean apostleWarned(Player player) {
        return SEHelper.getCapability(player).apostleWarned();
    }

    public static void setApostleWarned(Player player, boolean warned) {
        SEHelper.getCapability(player).setApostleWarned(warned);
    }

    public static boolean getSoulsContainer(Player player) {
        if (SEHelper.getSEActive(player)) {
            return true;
        }
        return !TotemFinder.FindTotem(player).m_41619_();
    }

    public static boolean getSoulsAmount(Player player, int souls) {
        if (SEHelper.getSEActive(player) && SEHelper.getSESouls(player) >= souls) {
            return true;
        }
        return !TotemFinder.FindTotem(player).m_41619_() && ITotem.currentSouls(TotemFinder.FindTotem(player)) >= souls && !SEHelper.getSEActive(player);
    }

    public static int getSoulAmountInt(Player player) {
        if (SEHelper.getSEActive(player)) {
            return SEHelper.getSESouls(player);
        }
        if (!TotemFinder.FindTotem(player).m_41619_()) {
            return ITotem.currentSouls(TotemFinder.FindTotem(player));
        }
        return 0;
    }

    public static int getSoulGiven(LivingEntity victim) {
        if (victim != null) {
            boolean flag;
            boolean bl = flag = victim instanceof IOwned && !(victim instanceof Enemy) && !victim.m_6162_();
            if (!flag) {
                if (victim.m_6336_() == MobType.f_21641_) {
                    return (Integer)MainConfig.UndeadSouls.get();
                }
                if (victim.m_6336_() == MobType.f_21642_) {
                    return (Integer)MainConfig.AnthropodSouls.get();
                }
                if (victim instanceof Animal) {
                    return (Integer)MainConfig.AnimalSouls.get();
                }
                if (victim instanceof Raider) {
                    return (Integer)MainConfig.IllagerSouls.get();
                }
                if (victim instanceof Villager) {
                    return (Integer)MainConfig.VillagerSouls.get();
                }
                if (victim instanceof AbstractPiglin) {
                    return (Integer)MainConfig.PiglinSouls.get();
                }
                if (victim instanceof EnderDragon) {
                    return (Integer)MainConfig.EnderDragonSouls.get();
                }
                if (victim instanceof EnderMan) {
                    return (Integer)MainConfig.EndermanSouls.get();
                }
                if (victim instanceof Warden) {
                    return (Integer)MainConfig.WardenSouls.get();
                }
                if (victim instanceof Player) {
                    return (Integer)MainConfig.PlayerSouls.get();
                }
                if (MinecoloniesLoaded.MINECOLONIES.isLoaded() && victim.m_6095_().m_20675_().contains("minecolonies") && victim.m_6095_().m_20674_() != MobCategory.MISC) {
                    return (Integer)MainConfig.VillagerSouls.get();
                }
                return (Integer)MainConfig.DefaultSouls.get();
            }
        }
        return 0;
    }

    public static void rawHandleKill(LivingEntity killer, LivingEntity victim, int soulEater, DamageSource source) {
        IOwned summonedEntity;
        Player player = null;
        int multi = Mth.m_14045_((int)((Integer)MainConfig.SoulTakenMultiplier.get()), (int)1, (int)Integer.MAX_VALUE);
        float extra = soulEater;
        if (killer instanceof Player) {
            player = (Player)killer;
        } else if (killer instanceof IOwned && (summonedEntity = (IOwned)killer).getTrueOwner() instanceof Player) {
            player = (Player)summonedEntity.getTrueOwner();
        }
        if (player != null) {
            TieredItem tieredItem;
            ItemStack itemStack;
            Item item;
            if (ModDamageSource.physicalAttacks(source) && ((item = (itemStack = killer.m_21205_()).m_41720_()) == ModItems.FANGED_DAGGER.get() || item instanceof TieredItem && (tieredItem = (TieredItem)item).m_43314_() == ModTiers.DARK)) {
                extra *= 1.5f;
            }
            SEHelper.increaseSouls(player, Mth.m_14143_((float)((float)SEHelper.getSoulGiven(victim) * extra)) * multi);
        }
    }

    public static void handleKill(LivingEntity killer, LivingEntity victim, DamageSource source) {
        SEHelper.rawHandleKill(killer, victim, SEHelper.SoulMultiply(killer, source), source);
    }

    public static void increaseSouls(Player player, int souls) {
        if (SEHelper.getSEActive(player)) {
            SEHelper.increaseSESouls(player, souls);
            SEHelper.sendSEUpdatePacket(player);
        } else {
            ItemStack foundStack = TotemFinder.FindTotem(player);
            if (foundStack != null) {
                ITotem.increaseSouls(foundStack, souls);
            }
        }
    }

    public static float soulDiscount(LivingEntity living) {
        float init = 1.0f;
        for (ItemStack itemStack : living.m_6168_()) {
            Item item = itemStack.m_41720_();
            if (!(item instanceof ISoulDiscount)) continue;
            ISoulDiscount soulDiscount = (ISoulDiscount)item;
            init -= (float)soulDiscount.getSoulDiscount(LivingEntity.m_147233_((ItemStack)itemStack)) / 100.0f;
        }
        return init;
    }

    public static void decreaseSouls(Player player, int souls) {
        souls = (int)((float)souls * SEHelper.soulDiscount((LivingEntity)player));
        if (SEHelper.getSEActive(player)) {
            SEHelper.decreaseSESouls(player, souls);
            SEHelper.sendSEUpdatePacket(player);
        } else {
            ItemStack foundStack = TotemFinder.FindTotem(player);
            if (foundStack != null) {
                ITotem.decreaseSouls(foundStack, souls);
            }
        }
    }

    public static int SoulMultiply(LivingEntity livingEntity, DamageSource source) {
        int i;
        ItemStack weapon = livingEntity.m_21205_();
        int multiply = 1;
        if (ModDamageSource.physicalAttacks(source) && (i = weapon.getEnchantmentLevel((Enchantment)ModEnchantments.SOUL_EATER.get())) > 0) {
            multiply = Mth.m_14045_((int)(i + 1), (int)1, (int)10);
        }
        return multiply;
    }

    public static int getRestPeriod(Player player) {
        return SEHelper.getCapability(player).getRestPeriod();
    }

    public static void setRestPeriod(Player player, int restPeriod) {
        SEHelper.getCapability(player).setRestPeriod(restPeriod);
    }

    public static boolean increaseRestPeriod(Player player, int increase) {
        return SEHelper.getCapability(player).increaseRestPeriod(increase);
    }

    public static boolean decreaseRestPeriod(Player player, int decrease) {
        return SEHelper.getCapability(player).decreaseRestPeriod(decrease);
    }

    public static boolean teleportToArca(Player player) {
        Optional optional;
        ServerLevel serverWorld;
        ISoulEnergy soulEnergy = SEHelper.getCapability(player);
        BlockPos blockPos = SEHelper.getArcaBlock(player);
        BlockPos blockPos1 = BlockPos.m_274561_((double)((float)blockPos.m_123341_() + 0.5f), (double)((float)blockPos.m_123342_() + 0.5f), (double)((float)blockPos.m_123343_() + 0.5f));
        if (soulEnergy.getArcaBlockDimension() == player.f_19853_.m_46472_()) {
            Optional optional2 = RespawnAnchorBlock.m_55839_((EntityType)EntityType.f_20532_, (CollisionGetter)player.f_19853_, (BlockPos)blockPos1);
            if (optional2.isPresent()) {
                player.m_6021_(((Vec3)optional2.get()).f_82479_, ((Vec3)optional2.get()).f_82480_, ((Vec3)optional2.get()).f_82481_);
                return true;
            }
        } else if (soulEnergy.getArcaBlockDimension() != null && player.m_20194_() != null && (serverWorld = player.m_20194_().m_129880_(soulEnergy.getArcaBlockDimension())) != null && (optional = RespawnAnchorBlock.m_55839_((EntityType)EntityType.f_20532_, (CollisionGetter)serverWorld, (BlockPos)blockPos1)).isPresent()) {
            player.changeDimension(serverWorld, (ITeleporter)new ArcaTeleporter((Vec3)optional.get()));
            player.m_6021_(((Vec3)optional.get()).f_82479_, ((Vec3)optional.get()).f_82480_, ((Vec3)optional.get()).f_82481_);
            return true;
        }
        return false;
    }

    public static boolean addGrudgeEntity(Player owner, LivingEntity target) {
        if (target != owner && !SEHelper.getGrudgeEntities(owner).contains(target)) {
            SEHelper.getCapability(owner).addGrudge(target.m_20148_());
            return true;
        }
        return false;
    }

    public static boolean removeGrudgeEntity(Player owner, LivingEntity target) {
        if (target != owner && SEHelper.getGrudgeEntities(owner).contains(target)) {
            SEHelper.getCapability(owner).removeGrudge(target.m_20148_());
            return true;
        }
        return false;
    }

    public static List<LivingEntity> getGrudgeEntities(Player owner) {
        ArrayList<LivingEntity> livingEntities = new ArrayList<LivingEntity>();
        if (!SEHelper.getCapability(owner).grudgeList().isEmpty()) {
            for (UUID uuid : SEHelper.getCapability(owner).grudgeList()) {
                LivingEntity target;
                LivingEntity entity = EntityFinder.getLivingEntityByUuiD(uuid);
                if (!(entity instanceof LivingEntity) || livingEntities.contains(target = entity) || target == owner) continue;
                livingEntities.add(target);
            }
        }
        return livingEntities;
    }

    public static boolean addGrudgeEntityType(Player owner, EntityType<?> target) {
        if (!SEHelper.getGrudgeEntityTypes(owner).contains(target)) {
            SEHelper.getCapability(owner).addGrudgeType(target);
            return true;
        }
        return false;
    }

    public static boolean removeGrudgeEntityType(Player owner, EntityType<?> target) {
        if (SEHelper.getGrudgeEntityTypes(owner).contains(target)) {
            SEHelper.getCapability(owner).removeGrudgeType(target);
            return true;
        }
        return false;
    }

    public static List<EntityType<?>> getGrudgeEntityTypes(Player owner) {
        ArrayList entityTypes = new ArrayList();
        if (!SEHelper.getCapability(owner).grudgeTypeList().isEmpty()) {
            for (EntityType<?> entityType : SEHelper.getCapability(owner).grudgeTypeList()) {
                if (entityTypes.contains(entityType)) continue;
                entityTypes.add(entityType);
            }
        }
        return entityTypes;
    }

    public static boolean addAllyEntity(Player owner, LivingEntity target) {
        if (target != owner && !SEHelper.getAllyEntities(owner).contains(target)) {
            SEHelper.getCapability(owner).addAlly(target.m_20148_());
            return true;
        }
        return false;
    }

    public static boolean removeAllyEntity(Player owner, LivingEntity target) {
        if (target != owner && SEHelper.getAllyEntities(owner).contains(target)) {
            SEHelper.getCapability(owner).removeAlly(target.m_20148_());
            return true;
        }
        return false;
    }

    public static List<LivingEntity> getAllyEntities(Player owner) {
        ArrayList<LivingEntity> livingEntities = new ArrayList<LivingEntity>();
        if (!SEHelper.getCapability(owner).allyList().isEmpty()) {
            for (UUID uuid : SEHelper.getCapability(owner).allyList()) {
                LivingEntity target;
                LivingEntity entity = EntityFinder.getLivingEntityByUuiD(uuid);
                if (!(entity instanceof LivingEntity) || livingEntities.contains(target = entity) || target == owner) continue;
                livingEntities.add(target);
            }
        }
        return livingEntities;
    }

    public static boolean addAllyEntityType(Player owner, EntityType<?> target) {
        if (!SEHelper.getAllyEntityTypes(owner).contains(target)) {
            SEHelper.getCapability(owner).addAllyType(target);
            return true;
        }
        return false;
    }

    public static boolean removeAllyEntityType(Player owner, EntityType<?> target) {
        if (SEHelper.getAllyEntityTypes(owner).contains(target)) {
            SEHelper.getCapability(owner).removeAllyType(target);
            return true;
        }
        return false;
    }

    public static List<EntityType<?>> getAllyEntityTypes(Player owner) {
        ArrayList entityTypes = new ArrayList();
        if (!SEHelper.getCapability(owner).allyTypeList().isEmpty()) {
            for (EntityType<?> entityType : SEHelper.getCapability(owner).allyTypeList()) {
                if (entityTypes.contains(entityType)) continue;
                entityTypes.add(entityType);
            }
        }
        return entityTypes;
    }

    public static boolean addSummon(Player owner, LivingEntity target) {
        if (target != owner && !SEHelper.getSummons(owner).contains(target)) {
            SEHelper.getCapability(owner).addSummon(target.m_20148_());
            return true;
        }
        return false;
    }

    public static boolean removeSummon(Player owner, LivingEntity target) {
        if (target != owner && SEHelper.getSummons(owner).contains(target)) {
            SEHelper.getCapability(owner).removeSummon(target.m_20148_());
            return true;
        }
        return false;
    }

    public static List<LivingEntity> getSummons(Player owner) {
        ArrayList<LivingEntity> livingEntities = new ArrayList<LivingEntity>();
        if (!SEHelper.getCapability(owner).summonList().isEmpty()) {
            for (UUID uuid : SEHelper.getCapability(owner).summonList()) {
                LivingEntity target;
                LivingEntity entity = EntityFinder.getLivingEntityByUuiD(uuid);
                if (!(entity instanceof LivingEntity) || livingEntities.contains(target = entity) || target == owner) continue;
                livingEntities.add(target);
            }
        }
        return livingEntities;
    }

    public static List<LivingEntity> getSpecificSummons(Player owner, EntityType<?> entityType) {
        ArrayList<LivingEntity> livingEntities = new ArrayList<LivingEntity>();
        if (!SEHelper.getSummons(owner).isEmpty()) {
            for (LivingEntity livingEntity : SEHelper.getSummons(owner)) {
                if (livingEntity.m_6095_() != entityType) continue;
                livingEntities.add(livingEntity);
            }
        }
        return livingEntities;
    }

    public static List<LivingEntity> getSpecificSummons(Player owner, Class<?> aClass) {
        ArrayList<LivingEntity> livingEntities = new ArrayList<LivingEntity>();
        if (!SEHelper.getSummons(owner).isEmpty()) {
            for (LivingEntity livingEntity : SEHelper.getSummons(owner)) {
                if (livingEntity.getClass() != aClass) continue;
                livingEntities.add(livingEntity);
            }
        }
        return livingEntities;
    }

    public static boolean addResearch(Player player, Research research) {
        if (!SEHelper.getResearch(player).contains(research)) {
            SEHelper.getCapability(player).addResearch(research);
            return true;
        }
        return false;
    }

    public static boolean removeResearch(Player player, Research research) {
        if (SEHelper.getResearch(player).contains(research)) {
            SEHelper.getCapability(player).removeResearch(research);
            return true;
        }
        return false;
    }

    public static List<Research> getResearch(Player player) {
        ArrayList<Research> research = new ArrayList<Research>();
        if (!SEHelper.getCapability(player).getResearch().isEmpty()) {
            research.addAll(SEHelper.getCapability(player).getResearch());
        }
        return research;
    }

    public static boolean hasResearch(Player player, Research research) {
        return SEHelper.getResearch(player).contains(research);
    }

    public static FocusCooldown getFocusCoolDown(Player player) {
        return SEHelper.getCapability(player).cooldowns();
    }

    public static void addCooldown(Player player, Item item, int duration) {
        SEHelper.getFocusCoolDown(player).addCooldown(player, player.f_19853_, item, duration);
    }

    public static FocusCooldown.CooldownInstance getCooldownInstance(Player player, Item item) {
        return SEHelper.getFocusCoolDown(player).getInstance(item);
    }

    public static int getShields(Player player) {
        return SEHelper.getCapability(player).shieldsLeft();
    }

    public static void setShields(Player player, int amount) {
        SEHelper.getCapability(player).setShields(amount);
        SEHelper.sendSEUpdatePacket(player);
    }

    public static void increaseShields(Player player) {
        SEHelper.getCapability(player).increaseShields();
        SEHelper.sendSEUpdatePacket(player);
    }

    public static void decreaseShields(Player player) {
        SEHelper.getCapability(player).breakShield();
        SEHelper.sendSEUpdatePacket(player);
        if (!player.f_19853_.f_46443_) {
            ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_12347_, 1.0f, 1.0f));
        }
    }

    public static int getShieldTime(Player player) {
        return SEHelper.getCapability(player).shieldTime();
    }

    public static void setShieldTime(Player player, int time) {
        SEHelper.getCapability(player).setShieldTime(time);
        SEHelper.sendSEUpdatePacket(player);
    }

    public static void decreaseShieldTime(Player player) {
        SEHelper.getCapability(player).decreaseShieldTime();
        SEHelper.sendSEUpdatePacket(player);
    }

    public static int getShieldCool(Player player) {
        return SEHelper.getCapability(player).shieldCool();
    }

    public static void setShieldCool(Player player, int cool) {
        SEHelper.getCapability(player).setShieldCool(cool);
    }

    public static void decreaseShieldCool(Player player) {
        SEHelper.getCapability(player).decreaseShieldCool();
        SEHelper.sendSEUpdatePacket(player);
    }

    public static int getBottling(Player player) {
        return SEHelper.getCapability(player).bottling();
    }

    public static int getBottleLevel(Player player) {
        return SEHelper.getBottling(player) / (Integer)BrewConfig.BottlingLevelReq.get();
    }

    public static void setBottling(Player player, int bottling) {
        SEHelper.getCapability(player).setBottling(bottling);
        SEHelper.sendSEUpdatePacket(player);
    }

    public static void increaseBottling(Player player) {
        SEHelper.increaseBottling(player, 1);
    }

    public static void increaseBottling(Player player, int increase) {
        if ((Integer)BrewConfig.MaxBottlingLevel.get() > 0 && SEHelper.getBottling(player) < (Integer)BrewConfig.MaxBottlingLevel.get()) {
            if (SEHelper.getBottling(player) > 0 && SEHelper.getBottling(player) % (Integer)BrewConfig.BottlingLevelReq.get() == 0) {
                if (!player.f_19853_.f_46443_) {
                    ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_12275_, 1.0f, 0.5f));
                }
                player.m_5661_((Component)Component.m_237115_((String)"info.goety.brew.level_up").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
            }
            SEHelper.setBottling(player, SEHelper.getBottling(player) + increase);
        }
    }

    public static boolean hasCamera(Player player) {
        return SEHelper.getCapability(player).getCameraUUID() != null;
    }

    public static void setCamera(Player player, @Nullable Entity target) {
        if (target != null) {
            if (target == player) {
                SurveyEye surveyEye = new SurveyEye((EntityType<? extends FlyingMob>)((EntityType)ModEntityType.SURVEY_EYE.get()), player.f_19853_);
                BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos(player.m_20185_(), player.m_20186_() + 8.0, player.m_20189_());
                while ((double)blockpos$mutable.m_123342_() < player.m_20186_() + 16.0 && !player.f_19853_.m_8055_((BlockPos)blockpos$mutable).m_280555_()) {
                    blockpos$mutable.m_122173_(Direction.UP);
                }
                surveyEye.m_146884_(Vec3.m_82512_((Vec3i)blockpos$mutable));
                surveyEye.m_21391_((Entity)player, 90.0f, 90.0f);
                surveyEye.setOwner(player);
                if (player.f_19853_.m_7967_((Entity)surveyEye)) {
                    SEHelper.getCapability(player).setCameraUUID(surveyEye.m_20148_());
                    target = surveyEye;
                }
            } else {
                SEHelper.getCapability(player).setCameraUUID(target.m_20148_());
            }
        } else {
            SEHelper.getCapability(player).setCameraUUID(null);
            target = player;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetCameraPacket(target));
        }
        SEHelper.sendSEUpdatePacket(player);
    }

    public static void sendSEUpdatePacket(Player player) {
        if (!player.f_19853_.m_5776_()) {
            ModNetwork.sendTo(player, new SEUpdatePacket(player));
        }
    }

    public static CompoundTag save(CompoundTag tag, ISoulEnergy soulEnergy) {
        CompoundTag compoundTag;
        ListTag listTag;
        tag.m_128379_("seActive", soulEnergy.getSEActive());
        tag.m_128405_("soulEnergy", soulEnergy.getSoulEnergy());
        tag.m_128405_("restPeriod", soulEnergy.getRestPeriod());
        tag.m_128379_("apostleWarned", soulEnergy.apostleWarned());
        tag.m_128405_("shields", soulEnergy.shieldsLeft());
        tag.m_128405_("shieldTime", soulEnergy.shieldTime());
        tag.m_128405_("shieldCool", soulEnergy.shieldCool());
        tag.m_128405_("bottling", soulEnergy.bottling());
        if (soulEnergy.getCameraUUID() != null) {
            tag.m_128362_("cameraUUID", soulEnergy.getCameraUUID());
        }
        if (soulEnergy.getArcaBlock() != null) {
            tag.m_128405_("arcax", soulEnergy.getArcaBlock().m_123341_());
            tag.m_128405_("arcay", soulEnergy.getArcaBlock().m_123342_());
            tag.m_128405_("arcaz", soulEnergy.getArcaBlock().m_123343_());
            ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)soulEnergy.getArcaBlockDimension().m_135782_()).resultOrPartial(arg_0 -> ((Logger)Goety.LOGGER).error(arg_0)).ifPresent(p_241148_1_ -> tag.m_128365_("dimension", p_241148_1_));
        }
        if (soulEnergy.grudgeList() != null) {
            listTag = new ListTag();
            if (!soulEnergy.grudgeList().isEmpty()) {
                for (UUID uUID : soulEnergy.grudgeList()) {
                    listTag.add((Object)NbtUtils.m_129226_((UUID)uUID));
                }
                tag.m_128365_("grudgeList", (Tag)listTag);
            }
        }
        if (soulEnergy.grudgeTypeList() != null) {
            listTag = new ListTag();
            if (!soulEnergy.grudgeTypeList().isEmpty()) {
                for (EntityType entityType : soulEnergy.grudgeTypeList()) {
                    compoundTag = new CompoundTag();
                    compoundTag.m_128359_("id", EntityType.m_20613_((EntityType)entityType).toString());
                    listTag.add((Object)compoundTag);
                }
                tag.m_128365_("grudgeTypeList", (Tag)listTag);
            }
        }
        if (soulEnergy.allyList() != null) {
            listTag = new ListTag();
            if (!soulEnergy.allyList().isEmpty()) {
                for (UUID uUID : soulEnergy.allyList()) {
                    listTag.add((Object)NbtUtils.m_129226_((UUID)uUID));
                }
                tag.m_128365_("allyList", (Tag)listTag);
            }
        }
        if (soulEnergy.allyTypeList() != null) {
            listTag = new ListTag();
            if (!soulEnergy.allyTypeList().isEmpty()) {
                for (EntityType entityType : soulEnergy.allyTypeList()) {
                    compoundTag = new CompoundTag();
                    compoundTag.m_128359_("id", EntityType.m_20613_((EntityType)entityType).toString());
                    listTag.add((Object)compoundTag);
                }
                tag.m_128365_("allyTypeList", (Tag)listTag);
            }
        }
        if (soulEnergy.getResearch() != null) {
            listTag = new ListTag();
            if (!soulEnergy.getResearch().isEmpty()) {
                for (Research research : soulEnergy.getResearch()) {
                    compoundTag = new CompoundTag();
                    compoundTag.m_128359_("research", research.getId());
                    listTag.add((Object)compoundTag);
                }
                tag.m_128365_("researchList", (Tag)listTag);
            }
        }
        if (soulEnergy.summonList() != null) {
            listTag = new ListTag();
            if (!soulEnergy.summonList().isEmpty()) {
                for (UUID uUID : soulEnergy.summonList()) {
                    listTag.add((Object)NbtUtils.m_129226_((UUID)uUID));
                }
                tag.m_128365_("summonList", (Tag)listTag);
            }
        }
        if (soulEnergy.cooldowns() != null) {
            listTag = new ListTag();
            soulEnergy.cooldowns().save(listTag);
            tag.m_128365_("coolDowns", (Tag)listTag);
        }
        if (soulEnergy.getEndWalkPos() != null) {
            tag.m_128405_("EndWalkX", soulEnergy.getEndWalkPos().m_123341_());
            tag.m_128405_("EndWalkY", soulEnergy.getEndWalkPos().m_123342_());
            tag.m_128405_("EndWalkZ", soulEnergy.getEndWalkPos().m_123343_());
            ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)soulEnergy.getEndWalkDimension().m_135782_()).resultOrPartial(arg_0 -> ((Logger)Goety.LOGGER).error(arg_0)).ifPresent(p_241148_1_ -> tag.m_128365_("EndWalkDim", p_241148_1_));
        }
        return tag;
    }

    public static ISoulEnergy load(CompoundTag tag, ISoulEnergy soulEnergy) {
        String string;
        ListTag listtag;
        soulEnergy.setSEActive(tag.m_128471_("seActive"));
        soulEnergy.setArcaBlock(new BlockPos(tag.m_128451_("arcax"), tag.m_128451_("arcay"), tag.m_128451_("arcaz")));
        if (tag.m_128441_("EndWalkX") && tag.m_128441_("EndWalkY") && tag.m_128441_("EndWalkZ") && tag.m_128441_("EndWalkDim")) {
            soulEnergy.setEndWalkPos(new BlockPos(tag.m_128451_("EndWalkX"), tag.m_128451_("EndWalkY"), tag.m_128451_("EndWalkZ")));
            soulEnergy.setEndWalkDimension((ResourceKey<Level>)Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("EndWalkDim")).resultOrPartial(arg_0 -> ((Logger)Goety.LOGGER).error(arg_0)).orElse(Level.f_46428_));
        }
        soulEnergy.setSoulEnergy(tag.m_128451_("soulEnergy"));
        soulEnergy.setRestPeriod(tag.m_128451_("restPeriod"));
        soulEnergy.setApostleWarned(tag.m_128471_("apostleWarned"));
        soulEnergy.setShields(tag.m_128451_("shields"));
        soulEnergy.setShieldTime(tag.m_128451_("shieldTime"));
        soulEnergy.setShieldCool(tag.m_128451_("shieldCool"));
        soulEnergy.setBottling(tag.m_128451_("bottling"));
        if (tag.m_128441_("cameraUUID")) {
            soulEnergy.setCameraUUID(tag.m_128342_("cameraUUID"));
        } else {
            soulEnergy.setCameraUUID(null);
        }
        soulEnergy.setArcaBlockDimension((ResourceKey<Level>)Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("dimension")).resultOrPartial(arg_0 -> ((Logger)Goety.LOGGER).error(arg_0)).orElse(Level.f_46428_));
        if (tag.m_128425_("grudgeList", 9)) {
            listtag = tag.m_128437_("grudgeList", 11);
            for (Tag value : listtag) {
                soulEnergy.addGrudge(NbtUtils.m_129233_((Tag)value));
            }
        }
        if (tag.m_128425_("grudgeTypeList", 9)) {
            listtag = tag.m_128437_("grudgeTypeList", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                string = listtag.m_128728_(i).m_128461_("id");
                if (!EntityType.m_20632_((String)string).isPresent()) continue;
                soulEnergy.addGrudgeType((EntityType)EntityType.m_20632_((String)string).get());
            }
        }
        if (tag.m_128425_("allyList", 9)) {
            listtag = tag.m_128437_("allyList", 11);
            for (Tag value : listtag) {
                soulEnergy.addAlly(NbtUtils.m_129233_((Tag)value));
            }
        }
        if (tag.m_128425_("allyTypeList", 9)) {
            listtag = tag.m_128437_("allyTypeList", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                string = listtag.m_128728_(i).m_128461_("id");
                if (!EntityType.m_20632_((String)string).isPresent()) continue;
                soulEnergy.addAllyType((EntityType)EntityType.m_20632_((String)string).get());
            }
        }
        if (tag.m_128425_("researchList", 9)) {
            listtag = tag.m_128437_("researchList", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                string = listtag.m_128728_(i).m_128461_("research");
                if (ResearchList.getResearch(string) == null) continue;
                soulEnergy.addResearch(ResearchList.getResearch(string));
            }
        }
        if (tag.m_128425_("summonList", 9)) {
            listtag = tag.m_128437_("summonList", 11);
            for (Tag value : listtag) {
                soulEnergy.addSummon(NbtUtils.m_129233_((Tag)value));
            }
        }
        if (tag.m_128425_("coolDowns", 9)) {
            ListTag listTag = (ListTag)tag.m_128423_("coolDowns");
            soulEnergy.cooldowns().load(listTag);
        }
        return soulEnergy;
    }
}

