/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.Goety;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class ModLootTables {
    private static final Set<ResourceLocation> LOCATIONS = Sets.newHashSet();
    private static final Set<ResourceLocation> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);
    public static final ResourceLocation EMPTY = new ResourceLocation("empty");
    public static final ResourceLocation CRYPT_TOMB = ModLootTables.register("chests/crypt_tomb");
    public static final ResourceLocation TALL_SKULL = ModLootTables.register("entities/tall_skull_mobs");
    public static final ResourceLocation PLAYER_WITCH = ModLootTables.register("entities/player_witch");
    public static final ResourceLocation CULTISTS = ModLootTables.register("entities/cultist_extra");
    public static final ResourceLocation CRYPT_SLIME = ModLootTables.register("entities/crypt_slime");
    public static final ResourceLocation INFERNO = ModLootTables.register("entities/inferno_extra");
    public static final ResourceLocation APOSTLE_HARD = ModLootTables.register("entities/apostle_2");
    public static final ResourceLocation WITCH_BARTER = ModLootTables.register("gameplay/witch_bartering");
    public static final ResourceLocation WARLOCK_BARTER = ModLootTables.register("gameplay/warlock_bartering");
    public static final ResourceLocation CRONE_BARTER = ModLootTables.register("gameplay/crone_bartering");

    private static ResourceLocation register(String pId) {
        return ModLootTables.register(Goety.location(pId));
    }

    private static ResourceLocation register(ResourceLocation pId) {
        if (LOCATIONS.add(pId)) {
            return pId;
        }
        throw new IllegalArgumentException(pId + " is already a registered built-in loot table");
    }

    public static Set<ResourceLocation> all() {
        return IMMUTABLE_LOCATIONS;
    }
}

